/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers.noschema;

import java.util.List;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.delimited.identifiers.noschema.EntityC;
import org.apache.openjpa.persistence.delimited.identifiers.noschema.EntityD;
import org.apache.openjpa.persistence.delimited.identifiers.noschema.EntityD2;
import org.apache.openjpa.persistence.delimited.identifiers.noschema.EntityD3;
import org.apache.openjpa.persistence.delimited.identifiers.noschema.EntityD4;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNoSchemaManualDelimitedJoinAnnotations
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    EntityC entityC;
    EntityD entityD;
    EntityD2 entityD2;
    EntityD3 entityD3;
    EntityD4 entityD4;
    JDBCConfiguration conf;
    DBDictionary dict;

    @Override
    public void setUp() throws Exception {
        this.setUnsupportedDatabases(MariaDBDictionary.class);
        this.setUnsupportedDatabases(MySQLDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(EntityC.class, EntityD.class, EntityD2.class, EntityD3.class, EntityD4.class, DROP_TABLES);
        TestNoSchemaManualDelimitedJoinAnnotations.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestNoSchemaManualDelimitedJoinAnnotations.assertNotNull((Object)this.em);
        this.conf = (JDBCConfiguration)this.emf.getConfiguration();
        this.dict = this.conf.getDBDictionaryInstance();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
        this.dict = null;
        this.conf = null;
        super.tearDown();
    }

    private void createCandD(int id) {
        this.entityC = new EntityC(id);
        this.entityC.setName("ec");
        this.entityC.setSecName("secName1");
        this.entityD = new EntityD(id);
        this.entityD.setName("ed");
        this.entityD2 = new EntityD2(id);
        this.entityD2.setName("ed2");
        this.entityD3 = new EntityD3(id);
        this.entityD3.setName("ed3");
        this.entityD4 = new EntityD4(id);
        this.entityD4.setName("ed4");
        this.entityC.addEntityD(this.entityD);
        this.entityD.addEntityC(this.entityC);
        this.entityC.setEntityD2(this.entityD2);
        this.entityC.addMapValues(this.entityD3, this.entityD4);
        this.entityC.addMap2Values(this.entityD4, this.entityD3);
        this.entityD2.setEntityD3(this.entityD3);
    }

    public void testCreate() {
        ++this.id;
        this.createCandD(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityC);
        this.em.persist((Object)this.entityD);
        this.em.persist((Object)this.entityD2);
        this.em.persist((Object)this.entityD3);
        this.em.persist((Object)this.entityD4);
        this.em.getTransaction().commit();
        this.runQueries();
    }

    private void runQueries() {
        this.em.clear();
        this.queryJoinTable();
        this.em.clear();
        this.queryJoinColumn();
        this.em.clear();
        this.querySecondaryTableValue();
        this.em.clear();
        this.queryMapValue();
    }

    private void queryJoinTable() {
        String query = "SELECT c FROM EntityC c JOIN c.entityDs d WHERE d.name = 'ed'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestNoSchemaManualDelimitedJoinAnnotations.assertEquals((int)1, (int)results.size());
    }

    private void queryJoinColumn() {
        String query = "SELECT c FROM EntityC c JOIN c.entityD2 d2 WHERE d2.name = 'ed2'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestNoSchemaManualDelimitedJoinAnnotations.assertEquals((int)1, (int)results.size());
    }

    private void querySecondaryTableValue() {
        String query = "SELECT c FROM EntityC c WHERE c.secName = 'secName1'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestNoSchemaManualDelimitedJoinAnnotations.assertEquals((int)1, (int)results.size());
    }

    private void queryMapValue() {
        String query = "SELECT c FROM EntityC c, IN(c.map2) m WHERE m.name = 'ed3'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestNoSchemaManualDelimitedJoinAnnotations.assertEquals((int)1, (int)results.size());
    }
}

