/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import java.util.List;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.delimited.identifiers.Animal;
import org.apache.openjpa.persistence.delimited.identifiers.Cat;
import org.apache.openjpa.persistence.delimited.identifiers.Dog;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestManualDelimInheritance
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    Dog dog;
    Cat cat;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DB2Dictionary.class, DerbyDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(Animal.class, Dog.class, Cat.class, DROP_TABLES);
        TestManualDelimInheritance.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestManualDelimInheritance.assertNotNull((Object)this.em);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
        super.tearDown();
    }

    private void createDog(int id) {
        this.dog = new Dog(id);
        this.dog.setName("Spot");
        this.dog.setType("dog");
    }

    private void createCat(int id) {
        this.cat = new Cat(id);
        this.cat.setName("Puff");
        this.cat.setType("cat");
    }

    public void testCreate() {
        ++this.id;
        this.createDog(this.id);
        ++this.id;
        this.createCat(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.dog);
        this.em.persist((Object)this.cat);
        this.em.getTransaction().commit();
        this.runQueries();
    }

    private void runQueries() {
        this.em.clear();
        this.queryCat();
        this.em.clear();
        this.queryDog();
    }

    private void queryCat() {
        String query = "SELECT DISTINCT a FROM Animal a WHERE a.type = 'cat'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestManualDelimInheritance.assertEquals((int)1, (int)results.size());
    }

    private void queryDog() {
        String query = "SELECT * FROM \"Animal\" a WHERE a.\"discr col\" = 'Dog'";
        OpenJPAQuery q = this.em.createNativeQuery(query);
        List results = q.getResultList();
        TestManualDelimInheritance.assertEquals((int)1, (int)results.size());
    }
}

