/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import java.util.List;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.delimited.identifiers.Car;
import org.apache.openjpa.persistence.delimited.identifiers.Chevrolet;
import org.apache.openjpa.persistence.delimited.identifiers.Pontiac;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestDelimInheritance
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    Pontiac pontiac;
    Chevrolet chevrolet;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DerbyDictionary.class, DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(Car.class, Pontiac.class, Chevrolet.class, DROP_TABLES);
        TestDelimInheritance.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestDelimInheritance.assertNotNull((Object)this.em);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
        super.tearDown();
    }

    @Override
    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        return this.createNamedEMF("delimited-identifiers", props);
    }

    private void createPontiac(int id) {
        this.pontiac = new Pontiac(id);
        this.pontiac.setModel("G6");
        this.pontiac.setColor("red");
    }

    private void createChevrolet(int id) {
        this.chevrolet = new Chevrolet(id);
        this.chevrolet.setModel("Malibu");
        this.chevrolet.setColor("black");
    }

    public void testCreate() {
        ++this.id;
        this.createPontiac(this.id);
        ++this.id;
        this.createChevrolet(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.pontiac);
        this.em.persist((Object)this.chevrolet);
        this.em.getTransaction().commit();
        this.runQueries();
    }

    private void runQueries() {
        this.em.clear();
        this.queryChevrolet();
        this.em.clear();
        this.queryPontiac();
    }

    private void queryChevrolet() {
        String query = "SELECT DISTINCT c FROM Car c WHERE c.model = 'Malibu'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestDelimInheritance.assertEquals((int)1, (int)results.size());
    }

    private void queryPontiac() {
        String query = "SELECT * FROM \"Car\" c WHERE c.\"discr col\" = 'Pontiac'";
        OpenJPAQuery q = this.em.createNativeQuery(query);
        List results = q.getResultList();
        TestDelimInheritance.assertEquals((int)1, (int)results.size());
    }
}

