/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectA;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectB;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestQueryResultTypes
extends AbstractTestCase {
    public TestQueryResultTypes(String test) {
        super(test, "datacachecactusapp");
    }

    public void testQueryResultTypesWithThis() {
        Broker broker = this.getBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name,a FROM " + CacheObjectA.class.getSimpleName() + " a"));
        Class[] types = q.getProjectionTypes();
        TestQueryResultTypes.assertEquals((int)2, (int)types.length);
        TestQueryResultTypes.assertEquals(String.class, (Object)types[0]);
        TestQueryResultTypes.assertEquals(CacheObjectA.class, (Object)types[1]);
    }

    public void testQueryResultTypesWithRelated() {
        Broker broker = this.getBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name,a.relatedB FROM " + CacheObjectA.class.getSimpleName() + " a"));
        Class[] types = q.getProjectionTypes();
        TestQueryResultTypes.assertEquals((int)2, (int)types.length);
        TestQueryResultTypes.assertEquals(String.class, (Object)types[0]);
        TestQueryResultTypes.assertEquals(CacheObjectB.class, (Object)types[1]);
    }

    public void testSingleProjectionOfNonThisRelation() {
        Broker broker = this.getBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.relatedB FROM " + CacheObjectA.class.getSimpleName() + " a"));
        Class[] types = q.getProjectionTypes();
        TestQueryResultTypes.assertEquals((int)1, (int)types.length);
        TestQueryResultTypes.assertEquals(CacheObjectB.class, (Object)types[0]);
    }

    public void testSingleProjectionOfThisRelation() {
        Broker broker = this.getBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a FROM " + CacheObjectA.class.getSimpleName() + " a"));
        Class[] types = q.getProjectionTypes();
        TestQueryResultTypes.assertEquals((int)0, (int)types.length);
    }

    public void testNoResultClause() {
        Broker broker = this.getBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a FROM " + CacheObjectA.class.getSimpleName() + " a"));
        Class[] types = q.getProjectionTypes();
        TestQueryResultTypes.assertEquals((int)0, (int)types.length);
    }

    private Broker getBroker() {
        return JPAFacadeHelper.toBroker((EntityManager)this.currentEntityManager());
    }
}

