/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import org.apache.openjpa.datacache.CacheDistributionPolicy;
import org.apache.openjpa.datacache.ConcurrentDataCache;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.PartitionedDataCache;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.UserException;

public class TestPartitionedDataCache
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp("openjpa.DataCache", "partitioned(PartitionType=concurrent,partitions='(name=a,cacheSize=100),(name=b,cacheSize=200)')", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.CacheDistributionPolicy", "org.apache.openjpa.persistence.datacache.TestPartitionedDataCache$TestPolicy");
    }

    public void testPropertyParsing() {
        PartitionedDataCache cache = new PartitionedDataCache();
        String badProperty = "(name=a,cacheSize=100),(name=b,cacheSize=200";
        try {
            cache.setPartitions(badProperty);
            TestPartitionedDataCache.fail((String)("Expected parse error on " + badProperty));
        }
        catch (UserException e) {
            System.err.println((Object)e);
        }
        badProperty = "(name=a,cacheSize=100)(name=b,cacheSize=200)";
        try {
            cache.setPartitions(badProperty);
            TestPartitionedDataCache.fail((String)("Expected parse error on " + badProperty));
        }
        catch (UserException e) {
            System.err.println((Object)e);
        }
        badProperty = "(cacheSize=100),(name=b,cacheSize=200)";
        try {
            cache.setPartitions(badProperty);
            TestPartitionedDataCache.fail((String)("Expected parse error on " + badProperty));
        }
        catch (UserException e) {
            System.err.println((Object)e);
        }
        badProperty = "(name=a,cacheSize=100),(name=a,cacheSize=200)";
        try {
            cache.setPartitions(badProperty);
            TestPartitionedDataCache.fail((String)("Expected parse error on " + badProperty));
        }
        catch (UserException e) {
            System.err.println((Object)e);
        }
        badProperty = "(name=default,cacheSize=100),(name=a,cacheSize=200)";
        try {
            cache.setPartitions(badProperty);
            TestPartitionedDataCache.fail((String)("Expected parse error on " + badProperty));
        }
        catch (UserException e) {
            System.err.println((Object)e);
        }
    }

    public void testPolicyConfiguration() {
        Object v = this.emf.getConfiguration().toProperties(true).get("openjpa.CacheDistributionPolicy");
        String policyPlugin = this.emf.getConfiguration().getCacheDistributionPolicy();
        CacheDistributionPolicy policyInstance = this.emf.getConfiguration().getCacheDistributionPolicyInstance();
        CacheDistributionPolicy policy = this.emf.getConfiguration().getDataCacheManagerInstance().getDistributionPolicy();
        TestPartitionedDataCache.assertNotNull((Object)policy);
        TestPartitionedDataCache.assertTrue((String)(policy.getClass() + " not TestPolicy"), (boolean)(policy instanceof TestPolicy));
    }

    public void testPluginConfiguration() {
        DataCache cache = ((StoreCacheImpl)this.emf.getStoreCache()).getDelegate();
        TestPartitionedDataCache.assertTrue((boolean)(cache instanceof PartitionedDataCache));
        TestPartitionedDataCache.assertFalse((boolean)cache.getPartitionNames().isEmpty());
        TestPartitionedDataCache.assertNotNull((Object)cache.getPartition("a", false));
        TestPartitionedDataCache.assertNotNull((Object)cache.getPartition("b", false));
        TestPartitionedDataCache.assertNull((Object)cache.getPartition("c", false));
        this.assertCacheConfiguration("a", 100);
        this.assertCacheConfiguration("b", 200);
    }

    void assertCacheConfiguration(String name, int size) {
        DataCache cache = this.emf.getConfiguration().getDataCacheManagerInstance().getDataCache(name);
        TestPartitionedDataCache.assertNotNull((Object)cache);
        TestPartitionedDataCache.assertTrue((boolean)(cache instanceof ConcurrentDataCache));
        TestPartitionedDataCache.assertEquals((int)size, (int)((ConcurrentDataCache)cache).getCacheSize());
    }

    public static class TestPolicy
    implements CacheDistributionPolicy {
        public String selectCache(OpenJPAStateManager sm, Object context) {
            return "a";
        }

        public void endConfiguration() {
        }

        public void setConfiguration(Configuration conf) {
        }

        public void startConfiguration() {
        }
    }
}

