/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.openjpa.datacache.ConcurrentQueryCache;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.datacache.CachedPerson;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.IntId;

public class TestLRUCache
extends SingleEMFTestCase {
    private final int cacheSize = 5;
    private final String QUERY = "SELECT p FROM CachedPerson p WHERE p.id=";

    @Override
    protected void setUp(Object ... props) {
        super.setUp(CLEAR_TABLES, CachedPerson.class, "openjpa.RemoteCommitProvider", "sjvm", "openjpa.DataCache", "true(SoftReferenceSize=0,Lru=true,CacheSize=5)", "openjpa.QueryCache", "true(SoftReferenceSize=0,Lru=true,CacheSize=5)");
    }

    public void testQueryCacheOverFlow() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ConcurrentQueryCache cache = (ConcurrentQueryCache)this.emf.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache();
        em.getTransaction().begin();
        for (i = 0; i < 6; ++i) {
            CachedPerson person = new CachedPerson();
            person.setId(i);
            em.persist((Object)person);
        }
        em.getTransaction().commit();
        em.clear();
        for (i = 0; i < 6; ++i) {
            em.createQuery("SELECT p FROM CachedPerson p WHERE p.id=" + i, CachedPerson.class).getSingleResult();
        }
        Set keys = cache.getCacheMap().keySet();
        TestLRUCache.assertEquals((int)5, (int)keys.size());
        ArrayList<String> strKeys = new ArrayList<String>();
        for (Object key : keys) {
            strKeys.add(key.toString());
        }
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            boolean res = this.contains("SELECT p FROM CachedPerson p WHERE p.id=" + i2, strKeys);
            if (i2 == 0) {
                TestLRUCache.assertFalse((boolean)res);
                continue;
            }
            TestLRUCache.assertTrue((boolean)res);
        }
        em.close();
    }

    public void testDataCacheOverFlow() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        StoreCacheImpl storeCache = (StoreCacheImpl)this.emf.getCache();
        DataCache cache = storeCache.getDelegate();
        LinkedList<CachedPerson> people = new LinkedList<CachedPerson>();
        for (i = 0; i < 6; ++i) {
            em.getTransaction().begin();
            CachedPerson person = new CachedPerson();
            person.setId(i);
            em.persist((Object)person);
            people.addFirst(person);
            em.getTransaction().commit();
        }
        for (i = 0; i < 6; ++i) {
            boolean contains;
            IntId id = new IntId(CachedPerson.class, i);
            boolean bl = contains = cache.get((Object)id) != null;
            if (i == 0) {
                TestLRUCache.assertFalse((boolean)contains);
                continue;
            }
            TestLRUCache.assertTrue((boolean)contains);
        }
        em.close();
    }

    private boolean contains(String needle, List<String> haystack) {
        for (String s : haystack) {
            if (!s.contains(needle)) continue;
            return true;
        }
        return false;
    }
}

