/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.TestCase;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.datacache.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.util.Id;

@AllowFailure(message="surefire excluded")
public class TestDistributedKodoDataCache
extends AbstractTestCase {
    private static final int NUM_OBJECTS = 4;
    private Object[] _runtime1sOids;
    private Object[] _runtime2sOids;
    private Object spec_oid;
    static int _fetchGroupSerial = 0;

    public TestDistributedKodoDataCache(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        this.deleteAll(RuntimeTest2.class);
    }

    public void testNormalTransAndDataCacheDelete() {
        this.coreTestTransAndChange(new performAsDelete(), false, true);
    }

    public void testNormalTransAndDataCacheModify() {
        this.coreTestTransAndChange(new performAsModify(), false, false);
    }

    public void testLargeTransAndDataCacheDelete() {
        this.coreTestTransAndChange(new performAsDelete(), true, true);
    }

    public void testLargeTransAndDataCacheModify() {
        this.coreTestTransAndChange(new performAsModify(), true, false);
    }

    public void coreTestTransAndChange(ChangeOperation changeOperation, boolean asLargeTransaction, boolean isDelete) {
        OpenJPAEntityManagerFactory pmfSender = this.createDistinctFactory(TCPRemoteCommitProvider.class, "Port=5636, Addresses=127.0.0.1:6636");
        OpenJPAEntityManagerFactory pmfReceiver = this.createDistinctFactory(TCPRemoteCommitProvider.class, "Port=6636, Addresses=127.0.0.1:5636");
        DataCache dcSender = ((OpenJPAEntityManagerFactorySPI)pmfSender).getConfiguration().getDataCacheManagerInstance().getSystemDataCache();
        DataCache dcReceiver = ((OpenJPAEntityManagerFactorySPI)pmfReceiver).getConfiguration().getDataCacheManagerInstance().getSystemDataCache();
        this.deleteAll(RuntimeTest1.class);
        this.deleteAll(RuntimeTest2.class);
        this._runtime1sOids = null;
        this._runtime2sOids = null;
        String transType = "normal";
        String rcpType = "OIDs";
        if (asLargeTransaction) {
            transType = "large";
            rcpType = "classes";
        }
        System.out.println("-------------------");
        System.out.println("2 PMFs created, acting as a cluster using ports 5636 and 6636");
        System.out.println("Testing scenario:");
        System.out.println("  1 Seed datastore with instances of RuntimeTest1 AND RuntimeTest2 objs.\n  2 pmf2 fills its cache with both sets of objs.\n  3 pmf1 does a " + transType + " tx that invokes an operation of " + changeOperation.getName() + " to affect a single Runtime1 \n    assert that both pmf1 and pmf2's data caches dropped allRuntime1s");
        System.out.println("Remote commit event is transmiting " + rcpType);
        OpenJPAEntityManager pmSender = pmfSender.createEntityManager();
        this.seedDataStore(pmSender, 4);
        this.endEm((EntityManager)pmSender);
        this.pause(1.0);
        OpenJPAEntityManager pm2 = pmfReceiver.createEntityManager();
        this.performLoadAll(pm2);
        this.endEm((EntityManager)pm2);
        pmSender = pmfSender.createEntityManager();
        this.performLoadAll(pmSender);
        this.endEm((EntityManager)pmSender);
        for (Object o : this._runtime1sOids) {
            TestDistributedKodoDataCache.assertTrue((boolean)dcReceiver.contains((Object)Id.newInstance(RuntimeTest1.class, (Object)o)));
        }
        for (Object oid : this._runtime2sOids) {
            TestDistributedKodoDataCache.assertTrue((boolean)dcReceiver.contains((Object)Id.newInstance(RuntimeTest2.class, (Object)oid)));
        }
        changeOperation.operation(pmfSender, asLargeTransaction);
        if (asLargeTransaction) {
            for (Object runtime1sOid : this._runtime1sOids) {
                TestDistributedKodoDataCache.assertFalse((boolean)dcSender.contains((Object)Id.newInstance(RuntimeTest1.class, (Object)runtime1sOid)));
            }
        } else {
            for (int i = 0; i < this._runtime1sOids.length; ++i) {
                if (isDelete && i == 0) {
                    TestDistributedKodoDataCache.assertFalse((boolean)dcSender.contains((Object)Id.newInstance(RuntimeTest1.class, (Object)this._runtime1sOids[i])));
                    continue;
                }
                TestDistributedKodoDataCache.assertTrue((boolean)dcSender.contains((Object)Id.newInstance(RuntimeTest1.class, (Object)this._runtime1sOids[i])));
            }
        }
        for (Object sOid : this._runtime2sOids) {
            TestDistributedKodoDataCache.assertTrue((boolean)dcSender.contains((Object)Id.newInstance(RuntimeTest2.class, (Object)sOid)));
        }
        this.pause(2.0);
        if (asLargeTransaction) {
            for (Object runtime1sOid : this._runtime1sOids) {
                TestDistributedKodoDataCache.assertFalse((boolean)dcReceiver.contains((Object)Id.newInstance(RuntimeTest1.class, (Object)runtime1sOid)));
            }
        } else {
            for (int i = 0; i < this._runtime1sOids.length; ++i) {
                if (i == 0) {
                    TestDistributedKodoDataCache.assertFalse((boolean)dcReceiver.contains((Object)Id.newInstance(RuntimeTest1.class, (Object)this._runtime1sOids[i])));
                    continue;
                }
                TestDistributedKodoDataCache.assertTrue((boolean)dcReceiver.contains((Object)Id.newInstance(RuntimeTest1.class, (Object)this._runtime1sOids[i])));
            }
        }
        for (Object runtime2sOid : this._runtime2sOids) {
            TestDistributedKodoDataCache.assertTrue((boolean)dcReceiver.contains((Object)Id.newInstance(RuntimeTest2.class, (Object)runtime2sOid)));
        }
        pmfSender.close();
        pmfReceiver.close();
    }

    protected void performLoadAll(OpenJPAEntityManager pm) {
        this.startTx((EntityManager)pm);
        List runtime1s = pm.createQuery("SELECT a FROM RuntimeTest1 a").getResultList();
        for (Object runtime1 : runtime1s) {
            RuntimeTest1 temp1 = (RuntimeTest1)runtime1;
        }
        List runtime2s = pm.createQuery("SELECT a FROM RuntimeTest2 a").getResultList();
        for (Object runtime2 : runtime2s) {
            RuntimeTest2 temp2 = (RuntimeTest2)runtime2;
        }
        this.endTx((EntityManager)pm);
    }

    protected void seedDataStore(OpenJPAEntityManager pm, int numObjects) {
        this.startTx((EntityManager)pm);
        RuntimeTest1[] persistables = new RuntimeTest1[numObjects];
        this._runtime1sOids = new Object[numObjects];
        for (int i = 0; i < persistables.length; ++i) {
            persistables[i] = new RuntimeTest1("foo #" + i, i);
            pm.persist((Object)persistables[i]);
            this._runtime1sOids[i] = pm.getObjectId((Object)persistables[i]);
            if (i != 0) continue;
            persistables[i].setStringField("SpecialRuntimeTest1");
            this.spec_oid = pm.getObjectId((Object)persistables[i]);
        }
        RuntimeTest2[] persistables2 = new RuntimeTest2[numObjects];
        this._runtime2sOids = new Object[numObjects];
        for (int i = 0; i < persistables2.length; ++i) {
            persistables2[i] = new RuntimeTest2("bar #" + i, i);
            pm.persist((Object)persistables2[i]);
            this._runtime2sOids[i] = pm.getObjectId((Object)persistables2[i]);
        }
        this.endTx((EntityManager)pm);
    }

    protected OpenJPAEntityManagerFactory createDistinctFactory(Class providerClass, String classProps1) {
        HashMap<String, String> propsMap;
        if (providerClass != null) {
            propsMap = new HashMap<String, String>();
            propsMap.put("openjpa.DataCache", "lru");
            propsMap.put("openjpa.RemoteCommitProvider", Configurations.getPlugin((String)providerClass.getName(), (String)classProps1));
            propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup" + _fetchGroupSerial);
        } else {
            propsMap = new HashMap();
            propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
            propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup" + _fetchGroupSerial);
        }
        ++_fetchGroupSerial;
        return this.getEmf(propsMap);
    }

    private void pause(double seconds) {
        try {
            Thread.currentThread();
            Thread.yield();
            Thread.currentThread();
            Thread.sleep((int)seconds * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class performAsDelete
    implements ChangeOperation {
        private performAsDelete() {
        }

        @Override
        public String getName() {
            return "Delete SpecialRuntimeTest1";
        }

        @Override
        public void operation(OpenJPAEntityManagerFactory kpmf, boolean asLarge) {
            OpenJPAEntityManager pm = kpmf.createEntityManager();
            if (asLarge) {
                pm.setTrackChangesByType(true);
            }
            TestDistributedKodoDataCache.this.startTx((EntityManager)pm);
            RuntimeTest1 specialObj = (RuntimeTest1)pm.find(RuntimeTest1.class, TestDistributedKodoDataCache.this.spec_oid);
            TestCase.assertNotNull((Object)specialObj);
            pm.remove((Object)specialObj);
            TestDistributedKodoDataCache.this.endTx((EntityManager)pm);
            TestDistributedKodoDataCache.this.endEm((EntityManager)pm);
        }
    }

    private class performAsModify
    implements ChangeOperation {
        private performAsModify() {
        }

        @Override
        public String getName() {
            return "Modify SpecialRuntimeTest1";
        }

        @Override
        public void operation(OpenJPAEntityManagerFactory kpmf, boolean asLarge) {
            OpenJPAEntityManager pm = kpmf.createEntityManager();
            if (asLarge) {
                pm.setTrackChangesByType(true);
            }
            TestDistributedKodoDataCache.this.startTx((EntityManager)pm);
            RuntimeTest1 special = (RuntimeTest1)pm.find(RuntimeTest1.class, TestDistributedKodoDataCache.this.spec_oid);
            TestCase.assertNotNull((Object)special);
            special.setStringField("SpeicalRuntimeTest1_MODIFIED");
            TestDistributedKodoDataCache.this.endTx((EntityManager)pm);
            TestDistributedKodoDataCache.this.endEm((EntityManager)pm);
        }
    }

    private static interface ChangeOperation {
        public String getName();

        public void operation(OpenJPAEntityManagerFactory var1, boolean var2);
    }
}

