/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.HashSet;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.datacache.CachedEntityStatistics;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestDataCacheStoreLazyFk
extends SQLListenerTestCase {
    Object[] p = new Object[]{CLEAR_TABLES, CachedEntityStatistics.class, "openjpa.DataCache", "true"};

    @Override
    public void setUp() {
        super.setUp(this.p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheHit() throws Exception {
        EntityManagerImpl em = (EntityManagerImpl)this.emf.createEntityManager();
        ClassMetaData cmd = em.getConfiguration().getMetaDataRepositoryInstance().getMetaData(CachedEntityStatistics.class, null, true);
        cmd.getField("eagerList").setInDefaultFetchGroup(false);
        try {
            em.getTransaction().begin();
            CachedEntityStatistics e = new CachedEntityStatistics();
            CachedEntityStatistics lazy = new CachedEntityStatistics();
            HashSet<CachedEntityStatistics> lazyList = new HashSet<CachedEntityStatistics>();
            lazyList.add(lazy);
            e.setLazyList(lazyList);
            em.persist((Object)e);
            em.persist((Object)lazy);
            em.flush();
            em.clear();
            ((CachedEntityStatistics)em.find(CachedEntityStatistics.class, (Object)e.getId())).getLazyList();
            em.clear();
            this.sql.clear();
            CachedEntityStatistics c = (CachedEntityStatistics)em.find(CachedEntityStatistics.class, (Object)e.getId());
            c.getLazyList();
            TestDataCacheStoreLazyFk.assertEquals((int)0, (int)this.sql.size());
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

