/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Calendar;
import java.util.Date;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.ClearableScheduler;
import org.apache.openjpa.datacache.ConcurrentDataCache;
import org.apache.openjpa.lib.util.Clearable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.CachedPerson;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestClearableScheduler
extends SingleEMFTestCase {
    private static String getMinutesString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 60; ++i) {
            if (i % 2 != 0) continue;
            buf.append(i).append(',');
        }
        return buf.toString();
    }

    @Override
    public void setUp() {
        this.setUp("openjpa.DataCache", "true(EvictionSchedule=+1)", "openjpa.QueryCache", "true", "openjpa.RemoteCommitProvider", "sjvm", CachedPerson.class, CLEAR_TABLES);
    }

    public void testBasic() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAConfiguration conf = em.getConfiguration();
        ClearableScheduler scheduler = new ClearableScheduler(conf);
        scheduler.setInterval(1);
        DummyCache cache1 = new DummyCache();
        DummyCache cache2 = new DummyCache();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int currMin = cal.get(12);
        int plusOne = currMin + 1;
        int plusTwo = plusOne + 1;
        if (plusOne >= 60) {
            plusOne -= 60;
        }
        if (plusTwo >= 60) {
            plusTwo -= 60;
        }
        scheduler.scheduleEviction((Clearable)cache2, plusOne + "," + plusTwo + " * * * *");
        scheduler.scheduleEviction((Clearable)cache1, "+1");
        Thread.currentThread();
        Thread.sleep(61000L);
        TestClearableScheduler.assertEquals((int)1, (int)cache1.getClearCount());
        TestClearableScheduler.assertEquals((int)1, (int)cache2.getClearCount());
        Thread.currentThread();
        Thread.sleep(60000L);
        TestClearableScheduler.assertEquals((int)2, (int)cache1.getClearCount());
        TestClearableScheduler.assertEquals((int)2, (int)cache2.getClearCount());
        Thread.currentThread();
        Thread.sleep(60000L);
        TestClearableScheduler.assertEquals((int)3, (int)cache1.getClearCount());
        TestClearableScheduler.assertEquals((int)2, (int)cache2.getClearCount());
    }

    private class DummyCache
    extends ConcurrentDataCache {
        private static final long serialVersionUID = 1L;
        int clearCount = 0;

        private DummyCache() {
        }

        public synchronized int getClearCount() {
            return this.clearCount;
        }

        public synchronized void clear() {
            ++this.clearCount;
        }
    }
}

