/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.RollbackException;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.OptimisticLockInstance;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBulkUpdatesAndVersionColumn
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        this.setUp("openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", OptimisticLockInstance.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OptimisticLockInstance pc = new OptimisticLockInstance("foo");
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
    }

    public void testSelectOnOplockField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.createQuery("select o from OptimisticLockInstance o where o.oplock = 0").getResultList();
        em.close();
    }

    public void testOplockFieldMapping() {
        ClassMapping cm = (ClassMapping)JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, OptimisticLockInstance.class);
        FieldMapping fm = cm.getFieldMapping("oplock");
        TestBulkUpdatesAndVersionColumn.assertEquals((int)1, (int)fm.getColumns().length);
    }

    public void testBulkUpdateWithManualVersionIncrement() {
        this.bulkUpdateHelper(true);
    }

    public void testBulkUpdateWithoutManualVersionIncrement() {
        this.bulkUpdateHelper(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkUpdateHelper(boolean incrementVersionField) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OptimisticLockInstance oli = (OptimisticLockInstance)em.createQuery("SELECT o FROM OptimisticLockInstance o WHERE o.str = 'foo'").getSingleResult();
        TestBulkUpdatesAndVersionColumn.assertNotNull((Object)oli);
        em.lock((Object)oli, LockModeType.READ);
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        em2.createQuery("UPDATE OptimisticLockInstance o SET o.str = 'foo', o.intField = o.intField + 1" + (incrementVersionField ? ", o.oplock = o.oplock + 1 " : "") + "WHERE o.str = 'foo'").executeUpdate();
        em2.getTransaction().commit();
        em2.close();
        try {
            em.getTransaction().commit();
            TestBulkUpdatesAndVersionColumn.fail((String)"transaction should have failed");
        }
        catch (RollbackException re) {
            TestBulkUpdatesAndVersionColumn.assertTrue((String)"nested exception must be an oplock exception", (boolean)(re.getCause() instanceof OptimisticLockException));
        }
        finally {
            em.close();
        }
    }
}

