/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.datacache.CascadeChild;
import org.apache.openjpa.persistence.datacache.CascadeParent;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBulkJPQLAndDataCache
extends SingleEMFTestCase {
    private Object oid;

    @Override
    public void setUp() throws Exception {
        this.setUp("openjpa.DataCache", "true", "openjpa.QueryCache", "true", "openjpa.RemoteCommitProvider", "sjvm", CLEAR_TABLES, AllFieldTypes.class, CascadeParent.class, CascadeChild.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AllFieldTypes pc = new AllFieldTypes();
        pc.setStringField("DeleteMe");
        em.persist((Object)pc);
        this.oid = em.getObjectId((Object)pc);
        em.getTransaction().commit();
        em.close();
    }

    public void testBulkDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        List result = em.createQuery("SELECT o FROM AllFieldTypes o").getResultList();
        TestBulkJPQLAndDataCache.assertEquals((int)1, (int)result.size());
        em.createQuery("DELETE FROM AllFieldTypes o").executeUpdate();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        TestBulkJPQLAndDataCache.assertFalse((boolean)OpenJPAPersistence.cast((EntityManagerFactory)this.emf).getStoreCache().contains(AllFieldTypes.class, this.oid));
        TestBulkJPQLAndDataCache.assertNull((Object)em.find(AllFieldTypes.class, this.oid));
        em.close();
    }

    public void testBulkUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        List result = em.createQuery("SELECT o FROM AllFieldTypes o WHERE o.intField = 0").getResultList();
        TestBulkJPQLAndDataCache.assertEquals((int)1, (int)result.size());
        em.createQuery("UPDATE AllFieldTypes o SET o.intField = 10").executeUpdate();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        TestBulkJPQLAndDataCache.assertFalse((boolean)OpenJPAPersistence.cast((EntityManagerFactory)this.emf).getStoreCache().contains(AllFieldTypes.class, this.oid));
        em.close();
    }

    public void testBulkDeleteOfCascadingEntity() {
        CascadeParent parent = new CascadeParent();
        parent.setName("parent");
        CascadeChild child = new CascadeChild();
        child.setName("child");
        parent.setChild(child);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)parent);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        TestBulkJPQLAndDataCache.assertEquals((int)1, (int)em.createQuery("SELECT o FROM CascadeParent o").getResultList().size());
        TestBulkJPQLAndDataCache.assertEquals((int)1, (int)em.createQuery("SELECT o FROM CascadeChild o").getResultList().size());
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("DELETE FROM CascadeParent o").executeUpdate();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        TestBulkJPQLAndDataCache.assertEquals((int)0, (int)em.createQuery("SELECT o FROM CascadeParent o").getResultList().size());
        TestBulkJPQLAndDataCache.assertEquals((int)0, (int)em.createQuery("SELECT o FROM CascadeChild o").getResultList().size());
        em.close();
    }
}

