/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria.results;

import java.lang.reflect.Array;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.Person_;
import org.apache.openjpa.persistence.criteria.results.Bar;
import org.apache.openjpa.persistence.criteria.results.Bar_;
import org.apache.openjpa.persistence.criteria.results.Foo;
import org.apache.openjpa.persistence.criteria.results.FooBar;
import org.apache.openjpa.persistence.criteria.results.Foo_;

public class TestMultiselect
extends CriteriaTest {
    private static boolean initialized = false;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (!initialized) {
            this.clearData();
            this.createData();
            initialized = true;
        }
    }

    void clearData() {
        this.em.getTransaction().begin();
        this.em.createQuery("DELETE FROM Foo f").executeUpdate();
        this.em.createQuery("DELETE FROM Bar b").executeUpdate();
        this.em.createQuery("DELETE FROM Person p").executeUpdate();
        this.em.getTransaction().commit();
    }

    void createData() {
        this.em.getTransaction().begin();
        Person p = new Person("Test Result Shape");
        this.em.persist((Object)p);
        Foo foo = new Foo(100L, "Test Foo");
        Bar bar = new Bar(200L, "Test Bar");
        foo.setBar(bar);
        this.em.persist((Object)foo);
        this.em.persist((Object)bar);
        this.em.getTransaction().commit();
    }

    public void testTupleQuery() {
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name), p.get(Person_.id)});
        this.assertResult((CriteriaQuery<?>)q, Tuple.class, String.class, Integer.class);
    }

    public void testTupleQueryExplicit() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Tuple.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name), p.get(Person_.id)});
        this.assertResult((CriteriaQuery<?>)q, Tuple.class, String.class, Integer.class);
    }

    public void testUserResultQueryWithExplictProjectionOfConstructorArguments() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name)});
        this.assertResult((CriteriaQuery<?>)q, Person.class);
    }

    public void testUserResultQueryWithImplicitProjection() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        q.from(Person.class);
        this.assertResult((CriteriaQuery<?>)q, Person.class);
    }

    public void testUserResultQueryWithMismatchProjectionOfConstructorArguments() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name), p.get(Person_.id)});
        this.fail("Person has no constrcutor with (name,id)", (CriteriaQuery<?>)q);
    }

    public void testMultipleConstructorWithAliasRepeatedAndInOrderingClause() {
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{this.cb.construct(Person.class, new Selection[]{p.get(Person_.name)}), p.get(Person_.id), this.cb.construct(Person.class, new Selection[]{p.get(Person_.name)}), p.get(Person_.name)}).orderBy(new Order[]{this.cb.asc((Expression)p.get(Person_.name))});
        List tuples = this.em.createQuery((CriteriaQuery)q).getResultList();
        TestMultiselect.assertTrue((!tuples.isEmpty() ? 1 : 0) != 0);
        for (Tuple row : tuples) {
            TestMultiselect.assertEquals((int)4, (int)row.getElements().size());
            TestMultiselect.assertEquals(Person.class, row.get(0).getClass());
            TestMultiselect.assertEquals(Integer.class, row.get(1).getClass());
            TestMultiselect.assertEquals(Person.class, row.get(2).getClass());
            TestMultiselect.assertEquals(String.class, row.get(3).getClass());
            TestMultiselect.assertEquals((String)((Person)row.get(0)).getName(), (String)((Person)row.get(2)).getName());
            TestMultiselect.assertEquals((Object)((Person)row.get(0)).getName(), (Object)row.get(3));
        }
    }

    public void testUserClassArray() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person[].class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p, p});
        this.assertResult((CriteriaQuery<?>)q, Person[].class, Person.class, Person.class);
    }

    public void testBasicClassArray() {
        OpenJPACriteriaQuery q = this.cb.createQuery(String[].class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name), p.get(Person_.name)});
        this.assertResult((CriteriaQuery<?>)q, String[].class);
    }

    public void testTupleArray() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Tuple[].class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name), p.get(Person_.id), p.get(Person_.name)});
        this.assertResult((CriteriaQuery<?>)q, Tuple[].class, String.class, Integer.class, String.class);
    }

    public void testSingleObject() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p});
        this.assertResult((CriteriaQuery<?>)q, Object.class);
    }

    public void testSingleObjectViaConstructor() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{this.cb.construct(Person.class, new Selection[]{p.get(Person_.name)})});
        this.assertResult((CriteriaQuery<?>)q, Object.class);
    }

    public void testSingleObjectAsProperty() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name)});
        this.assertResult((CriteriaQuery<?>)q, Object.class);
    }

    public void testSingleObjectImplicit() {
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p});
        this.assertResult((CriteriaQuery<?>)q, Object.class);
    }

    public void testSingleObjectViaConstructorImplicit() {
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{this.cb.construct(Person.class, new Selection[]{p.get(Person_.name)})});
        this.assertResult((CriteriaQuery<?>)q, Object.class);
    }

    public void testSingleObjectAsPropertyImplicit() {
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name)});
        this.assertResult((CriteriaQuery<?>)q, Object.class);
    }

    public void testSingleObjectMultipleProjections() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p.get(Person_.name), p.get(Person_.id)});
        this.assertResult((CriteriaQuery<?>)q, Object[].class, String.class, Integer.class);
    }

    public void testSingleObjectMultipleProjectionsAndConstructor() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object.class);
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{this.cb.construct(Person.class, new Selection[]{p.get(Person_.name)}), p.get(Person_.id), p.get(Person_.name)});
        this.assertResult((CriteriaQuery<?>)q, Object[].class, Person.class, Integer.class, String.class);
    }

    public void xtestTupleCanNotBeNested() {
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root p = q.from(Person.class);
        CompoundSelection tuple1 = this.cb.tuple(new Selection[]{p.get(Person_.name), p.get(Person_.id)});
        CompoundSelection tuple2 = this.cb.tuple(new Selection[]{p.get(Person_.id), p.get(Person_.name)});
        try {
            this.cb.tuple(new Selection[]{tuple1, tuple2});
            TestMultiselect.fail((String)"Expected exception while nesting tuples");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMultiConstructor() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object[].class);
        Root f = q.from(Foo.class);
        Join b = f.join(Foo_.bar);
        q.multiselect(new Selection[]{this.cb.construct(Foo.class, new Selection[]{f.get(Foo_.fid), f.get(Foo_.fstring)}), b, this.cb.construct(FooBar.class, new Selection[]{f.get(Foo_.fid), b.get(Bar_.bid)})});
        q.where((Expression)this.cb.equal((Expression)f.get(Foo_.fid), (Object)100L));
        List result = this.em.createQuery((CriteriaQuery)q).getResultList();
        TestMultiselect.assertFalse((boolean)result.isEmpty());
        for (Object[] row : result) {
            TestMultiselect.assertEquals((int)3, (int)row.length);
            TestMultiselect.assertTrue((String)("0-th element " + row[0].getClass() + " is not Foo"), (boolean)(row[0] instanceof Foo));
            TestMultiselect.assertTrue((String)("1-st element " + row[1].getClass() + " is not Bar"), (boolean)(row[1] instanceof Bar));
            TestMultiselect.assertTrue((String)("2-nd element " + row[2].getClass() + " is not FooBar"), (boolean)(row[2] instanceof FooBar));
        }
    }

    public void testSelectSingleTermWithMultiselectObjectArray() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object[].class);
        Root f = q.from(Foo.class);
        q.multiselect(new Selection[]{f});
        this.assertResult((CriteriaQuery<?>)q, Object[].class, Foo.class);
    }

    public void testSelectSingleTermWithMultiselectObject() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Object.class);
        Root f = q.from(Foo.class);
        q.multiselect(new Selection[]{f});
        this.assertResult((CriteriaQuery<?>)q, Foo.class);
    }

    public void testSelectSingleTermWithMultiselectTuple() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Tuple.class);
        Root f = q.from(Foo.class);
        q.multiselect(new Selection[]{f});
        this.assertResult((CriteriaQuery<?>)q, Tuple.class, Foo.class);
    }

    public void testSelectSingleTermWithMultiselectTupleArray() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Tuple[].class);
        Root f = q.from(Foo.class);
        q.multiselect(new Selection[]{f});
        this.assertResult((CriteriaQuery<?>)q, Tuple[].class, Foo.class);
    }

    public void testSanity() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Foo.class);
        Root f = q.from(Foo.class);
        this.assertResult((CriteriaQuery<?>)q, Foo.class);
    }

    public void testSanity2() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Foo.class);
        Root f = q.from(Foo.class);
        q.select((Selection)f);
        this.assertResult((CriteriaQuery<?>)q, Foo.class);
    }

    public void testDeeplyNestedShape() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Tuple.class);
        Root foo = q.from(Foo.class);
        q.multiselect(new Selection[]{this.cb.construct(Foo.class, new Selection[]{foo.get(Foo_.flong), foo.get(Foo_.fstring)}), this.cb.tuple(new Selection[]{foo, this.cb.array(new Selection[]{foo.get(Foo_.fint), this.cb.tuple(new Selection[]{foo.get(Foo_.fstring)})})})});
        List result = this.em.createQuery((CriteriaQuery)q).getResultList();
        TestMultiselect.assertFalse((boolean)result.isEmpty());
        Tuple tuple = (Tuple)result.get(0);
        TestMultiselect.assertEquals(Foo.class, tuple.get(0).getClass());
        TestMultiselect.assertTrue((boolean)Tuple.class.isAssignableFrom(tuple.get(1).getClass()));
        Tuple tuple2 = (Tuple)tuple.get(1);
        TestMultiselect.assertEquals(Foo.class, tuple2.get(0).getClass());
        TestMultiselect.assertEquals(Object[].class, tuple2.get(1).getClass());
        Object[] level3 = (Object[])tuple2.get(1);
        TestMultiselect.assertEquals(Integer.class, level3[0].getClass());
        TestMultiselect.assertTrue((boolean)Tuple.class.isAssignableFrom(level3[1].getClass()));
        Tuple tuple4 = (Tuple)level3[1];
        TestMultiselect.assertEquals(String.class, tuple4.get(0).getClass());
    }

    public void testConstructorFailsFast() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Tuple.class);
        Root foo = q.from(Foo.class);
        try {
            q.multiselect(new Selection[]{this.cb.construct(Foo.class, new Selection[]{foo.get(Foo_.flong)})});
            TestMultiselect.fail((String)"Expected IllegalArgumentException becuase Foo(long) is not a valid constructor");
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
        }
        try {
            q.multiselect(new Selection[]{this.cb.construct(Foo.class, new Selection[0])});
            TestMultiselect.fail((String)"Expected IllegalArgumentException becuase Foo() is not a valid constructor");
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
        }
    }

    void assertResult(CriteriaQuery<?> q, Class<?> resultClass) {
        this.assertResult(q, resultClass, null);
    }

    void assertResult(CriteriaQuery<?> q, Class<?> resultClass, Class<?> ... arrayElementClasses) {
        List result = this.em.createQuery(q).getResultList();
        TestMultiselect.assertFalse((boolean)result.isEmpty());
        for (Object row : result) {
            TestMultiselect.assertTrue((String)(this.toClass(row) + " does not match actual result " + this.toString(resultClass)), (boolean)resultClass.isInstance(row));
            if (resultClass.isArray() && arrayElementClasses != null) {
                for (int i = 0; i < arrayElementClasses.length; ++i) {
                    Object element = Array.get(row, i);
                    if (Tuple.class.isInstance(element)) {
                        TestMultiselect.assertEquals(arrayElementClasses[i], ((Tuple)Tuple.class.cast(element)).get(0).getClass());
                        continue;
                    }
                    TestMultiselect.assertTrue((String)(i + "-th array element " + this.toString(arrayElementClasses[i]) + " does not match actual result " + this.toClass(element)), (boolean)arrayElementClasses[i].isInstance(element));
                }
            }
            if (resultClass != Tuple.class || arrayElementClasses == null) continue;
            Tuple tuple = (Tuple)row;
            for (int i = 0; i < arrayElementClasses.length; ++i) {
                Object element = tuple.get(i);
                TestMultiselect.assertTrue((String)(i + "-th tuple element " + this.toString(arrayElementClasses[i]) + " does not match actual result " + this.toClass(element)), (boolean)arrayElementClasses[i].isInstance(element));
            }
        }
    }

    void fail(String msg, CriteriaQuery<?> q) {
        try {
            this.em.createQuery(q).getResultList();
            TestMultiselect.fail((String)("Expected to fail " + msg));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String toClass(Object o) {
        return this.toString(o.getClass());
    }

    String toString(Class<?> cls) {
        return cls.isArray() ? this.toString(cls.getComponentType()) + "[]" : cls.toString();
    }
}

