/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria.multiselect;

import java.util.ArrayList;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.criteria.multiselect.DimDay;
import org.apache.openjpa.persistence.criteria.multiselect.DimDay_;
import org.apache.openjpa.persistence.criteria.multiselect.FactWorkAssignment;
import org.apache.openjpa.persistence.criteria.multiselect.FactWorkAssignment_;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestCriteriaMultiselectAliasing
extends SQLListenerTestCase {
    CriteriaQuery<Tuple> critQuery;
    String critQueryString;
    String doCB = System.getProperty("doCB");

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(OracleDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(DimDay.class, FactWorkAssignment.class, "openjpa.Log", "SQL=TRACE,Tests=TRACE", "openjpa.ConnectionFactoryProperties", "PrintParameters=true, PrettyPrint=true, PrettyPrintLineLength=72");
        this.critQuery = this.createCriteriaBuilder();
        this.critQueryString = this.critQuery.toString();
        System.out.println("critQueryString = " + this.critQueryString);
    }

    public void test() {
        if ("true".equals(this.doCB)) {
            this.ttestCriteriaQuery();
        } else {
            this.ttestGeneratedCriteriaQueryString();
        }
    }

    public void ttestCriteriaQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.resetSQL();
        em.createQuery(this.critQuery).getResultList();
        this.assertNotSQL(".*T_DIM_DAY t3.*");
        this.assertSQL(".*T_DIM_DAY t1.*");
        em.close();
    }

    public void ttestGeneratedCriteriaQueryString() {
        if (!"true".equals(this.doCB)) {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            System.out.println("NOT doing CB");
            this.resetSQL();
            em.createQuery(this.critQueryString).getResultList();
            this.assertNotSQL(".*T_DIM_DAY t3.*");
            this.assertSQL(".*T_DIM_DAY t1.*");
            em.close();
        }
    }

    public CriteriaQuery<Tuple> createCriteriaBuilder() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createTupleQuery();
        Root day = cq.from(DimDay.class);
        Root wa = cq.from(FactWorkAssignment.class);
        predicates.add(cb.equal((Expression)wa.get(FactWorkAssignment_.orgOID), (Object)"dummy1"));
        predicates.add(cb.equal((Expression)day.get(DimDay_.roll13MonthInd), (Object)1));
        Subquery subQuery = cq.subquery(String.class);
        Root wa1 = subQuery.from(FactWorkAssignment.class);
        subQuery.select((Expression)wa1.get(FactWorkAssignment_.personObjId));
        ArrayList<Predicate> subQueryPredicates = new ArrayList<Predicate>();
        subQueryPredicates.add(cb.equal((Expression)wa1.get(FactWorkAssignment_.orgOID), (Object)"dummy1"));
        subQueryPredicates.add(cb.equal((Expression)day.get(DimDay_.monthStrtDate), (Object)20150201L));
        subQuery.where(subQueryPredicates.toArray(new Predicate[0]));
        Predicate predicate = wa.get(FactWorkAssignment_.personObjId).in(new Expression[]{subQuery});
        predicates.add(predicate);
        ArrayList<Path> selections = new ArrayList<Path>();
        Path expHC = wa.get(FactWorkAssignment_.employeeCount);
        selections.add(expHC);
        cq.multiselect(selections).where(predicates.toArray(new Predicate[0]));
        return cq;
    }
}

