/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria.init;

import java.util.List;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.criteria.init.AddressEntity;
import org.apache.openjpa.persistence.criteria.init.AddressPk;
import org.apache.openjpa.persistence.criteria.init.MyUserEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCriteriaInitialization
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, AddressEntity.class, AddressPk.class, MyUserEntity.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            em.persist((Object)new MyUserEntity("wayne", 1L));
            em.persist((Object)new MyUserEntity("garth", 2L));
            em.persist((Object)new AddressEntity(new AddressPk("street_1", 1L)));
            em.persist((Object)new AddressEntity(new AddressPk("street_2", 2L)));
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        this.emf.close();
        OpenJPAEntityManagerFactorySPI oldEmf = this.emf;
        this.emf = this.createEMF(AddressEntity.class, AddressPk.class, MyUserEntity.class);
        TestCriteriaInitialization.assertNotEquals(oldEmf, this.emf);
        this.emf.getCriteriaBuilder();
        try (OpenJPAEntityManagerSPI em = this.emf.createEntityManager();){
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(MyUserEntity.class);
            Root from = cq.from(MyUserEntity.class);
            CriteriaQuery selectAll = cq.select((Selection)from);
            TypedQuery query = em.createQuery(selectAll);
            List res = query.getResultList();
            TestCriteriaInitialization.assertEquals((int)2, (int)res.size());
        }
    }
}

