/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.apache.openjpa.jdbc.sql.AbstractSQLServerDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.criteria.A;
import org.apache.openjpa.persistence.criteria.A_;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.Account;
import org.apache.openjpa.persistence.criteria.Account_;
import org.apache.openjpa.persistence.criteria.Address_;
import org.apache.openjpa.persistence.criteria.B_;
import org.apache.openjpa.persistence.criteria.Contact_;
import org.apache.openjpa.persistence.criteria.Course;
import org.apache.openjpa.persistence.criteria.Course_;
import org.apache.openjpa.persistence.criteria.CreditCard;
import org.apache.openjpa.persistence.criteria.CreditCard_;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Customer;
import org.apache.openjpa.persistence.criteria.CustomerDetails;
import org.apache.openjpa.persistence.criteria.CustomerFullName;
import org.apache.openjpa.persistence.criteria.Customer_;
import org.apache.openjpa.persistence.criteria.Department;
import org.apache.openjpa.persistence.criteria.Department_;
import org.apache.openjpa.persistence.criteria.Employee;
import org.apache.openjpa.persistence.criteria.Employee_;
import org.apache.openjpa.persistence.criteria.EntityWithIdClass;
import org.apache.openjpa.persistence.criteria.Exempt;
import org.apache.openjpa.persistence.criteria.Item;
import org.apache.openjpa.persistence.criteria.Item_;
import org.apache.openjpa.persistence.criteria.Joins;
import org.apache.openjpa.persistence.criteria.LineItem_;
import org.apache.openjpa.persistence.criteria.Manager;
import org.apache.openjpa.persistence.criteria.Manager_;
import org.apache.openjpa.persistence.criteria.Movie_;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Order;
import org.apache.openjpa.persistence.criteria.Order_;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.Person_;
import org.apache.openjpa.persistence.criteria.Phone_;
import org.apache.openjpa.persistence.criteria.Photo;
import org.apache.openjpa.persistence.criteria.Product;
import org.apache.openjpa.persistence.criteria.Product_;
import org.apache.openjpa.persistence.criteria.Semester;
import org.apache.openjpa.persistence.criteria.Student;
import org.apache.openjpa.persistence.criteria.Student_;
import org.apache.openjpa.persistence.criteria.TransactionHistory;
import org.apache.openjpa.persistence.criteria.VideoStore;
import org.apache.openjpa.persistence.criteria.VideoStore_;
import org.apache.openjpa.persistence.test.AllowFailure;

public class TestTypesafeCriteria
extends CriteriaTest {
    private static final String TRUE_JPQL = "SELECT p FROM Person p WHERE 1=1";
    private static final String FALSE_JPQL = "SELECT p FROM Person p WHERE 1<>1";

    public void testTrueLiteral() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        q.from(Person.class);
        this.assertEquivalence(q.where(this.cb.literal((Object)Boolean.TRUE)), TRUE_JPQL);
    }

    public void testFalseLiteral() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        q.from(Person.class);
        this.assertEquivalence(q.where(this.cb.literal((Object)Boolean.FALSE)), FALSE_JPQL);
    }

    public void testBooleanLiteralInEquals() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root root = q.from(Order.class);
        Path path = root.get("delivered");
        Expression literal = this.cb.literal((Object)Boolean.FALSE);
        TestTypesafeCriteria.assertEquals((String)"SELECT o FROM Order o WHERE o.delivered = false", (String)((OpenJPACriteriaQuery)q.select((Selection)root).where((Expression)this.cb.equal((Expression)path, literal))).toCQL());
    }

    public void testDefaultAndIsTrue() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        q.from(Person.class);
        this.assertEquivalence(q.where((Expression)this.cb.and(new Predicate[0])), TRUE_JPQL);
    }

    public void testDefaultOrIsFalse() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        q.from(Person.class);
        this.assertEquivalence(q.where((Expression)this.cb.or(new Predicate[0])), FALSE_JPQL);
    }

    public void testZeroDisjunctIsFalse() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        q.from(Person.class);
        this.assertEquivalence(q.where((Expression)this.cb.disjunction()), FALSE_JPQL);
    }

    public void testZeroConjunctIsTrue() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        q.from(Person.class);
        this.assertEquivalence(q.where((Expression)this.cb.conjunction()), TRUE_JPQL);
    }

    public void testExpressions() {
        String jpql = "SELECT o.quantity, o.totalCost*1.08, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root cust = q.from(Customer.class);
        SetJoin order = cust.joinSet("orders");
        Join address = cust.join("address");
        q.where(new Predicate[]{this.cb.equal((Expression)address.get("state"), (Object)"CA"), this.cb.equal((Expression)address.get("county"), (Object)"Santa Clara")});
        Expression taxedCost = this.cb.prod((Expression)order.get(Order_.totalCost), (Number)1.08);
        q.multiselect(new Selection[]{order.get("quantity"), taxedCost, address.get("zipCode")});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExplictRoot() {
        String jpql = "select a from Account a";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.select((Selection)account);
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testImplicitRoot() {
        String jpql = "select a from Account a";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        c.from(Account.class);
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testEqualWithAttributeAndLiteral() {
        String jpql = "select a from Account a where a.balance=100";
        OpenJPACriteriaQuery c = this.cb.createQuery();
        Root account = c.from(Account.class);
        c.select((Selection)account).where((Expression)this.cb.equal((Expression)account.get(Account_.balance), (Object)100));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testEqualWithAttributeAndAttribute() {
        String jpql = "select a from Account a where a.balance=a.loan";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.select((Selection)account).where((Expression)this.cb.equal((Expression)account.get(Account_.balance), (Expression)account.get(Account_.loan)));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testProjection() {
        String jpql = "select a.balance,a.loan from Account a";
        OpenJPACriteriaQuery c = this.cb.createTupleQuery();
        Root account = c.from(Account.class);
        c.multiselect(new Selection[]{account.get(Account_.balance), account.get(Account_.loan)});
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testAbsExpression() {
        String jpql = "select a from Account a where abs(a.balance)=100";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.select((Selection)account).where((Expression)this.cb.equal(this.cb.abs((Expression)account.get(Account_.balance)), (Object)100));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testAvgExpression() {
        String jpql = "select avg(a.balance) from Account a";
        OpenJPACriteriaQuery c = this.cb.createQuery(Double.class);
        Root account = c.from(Account.class);
        c.select((Selection)this.cb.avg((Expression)account.get(Account_.balance)));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testInPredicate() {
        String jpql = "select a from Account a where a.name in ('X','Y','Z')";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.where((Expression)this.cb.in((Expression)account.get(Account_.name)).value((Object)"X").value((Object)"Y").value((Object)"Z"));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testInPredicateWithPath() {
        String jpql = "select a from Account a where a.owner.name in ('X','Y','Z')";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.where((Expression)this.cb.in((Expression)account.get(Account_.owner).get(Person_.name)).value((Object)"X").value((Object)"Y").value((Object)"Z"));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testBinaryPredicate() {
        String jpql = "select a from Account a where a.balance>100 and a.balance<200";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.select((Selection)account).where((Expression)this.cb.and((Expression)this.cb.greaterThan((Expression)account.get(Account_.balance), (Comparable)Integer.valueOf(100)), (Expression)this.cb.lessThan((Expression)account.get(Account_.balance), (Comparable)Integer.valueOf(200))));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testEqualWithAttributeAndUnaryExpression() {
        String jpql = "select a from Account a where a.balance=abs(a.balance)";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.select((Selection)account).where((Expression)this.cb.equal((Expression)account.get(Account_.balance), this.cb.abs((Expression)account.get(Account_.balance))));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testBetweenExpression() {
        String jpql = "select a from Account a where a.balance between 100 and 200";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root account = c.from(Account.class);
        c.select((Selection)account).where((Expression)this.cb.between((Expression)account.get(Account_.balance), (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testSimplePath() {
        String jpql = "select a from Account a where a.owner.name='Pinaki'";
        OpenJPACriteriaQuery c = this.cb.createQuery(Account.class);
        Root a = c.from(Account.class);
        c.where((Expression)this.cb.equal((Expression)a.get(Account_.owner).get(Person_.name), (Object)"Pinaki"));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testSimpleLeftJoin() {
        String jpql = "SELECT c FROM Customer c LEFT JOIN c.orders o ";
        OpenJPACriteriaQuery c = this.cb.createQuery(Customer.class);
        c.from(Customer.class).join(Customer_.orders, JoinType.LEFT);
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testMultipartNavigation() {
        String jpql = "select a from A a where a.b.age=22";
        OpenJPACriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        cq.where((Expression)this.cb.equal((Expression)a.get(A_.b).get(B_.age), (Object)22));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testMultiLevelJoins() {
        String jpql = "SELECT c FROM Customer c JOIN c.orders o JOIN o.lineItems i WHERE i.product.productType = 'printer'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(Customer.class);
        Root c = cq.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        ListJoin i = o.join(Order_.lineItems);
        cq.select((Selection)c).where((Expression)this.cb.equal((Expression)i.get(LineItem_.product).get(Product_.productType), (Object)"printer"));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testJoinsNotPresentInWhereClause() {
        String jpql = "SELECT c FROM Customer c LEFT JOIN c.orders o WHERE c.status = 1";
        OpenJPACriteriaQuery c = this.cb.createQuery(Customer.class);
        Root cust = c.from(Customer.class);
        SetJoin order = cust.join(Customer_.orders, JoinType.LEFT);
        c.where((Expression)this.cb.equal((Expression)cust.get(Customer_.status), (Object)1)).select((Selection)cust);
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testFetchJoins() {
        String jpql = "SELECT d FROM Department d LEFT JOIN FETCH d.employees WHERE d.deptNo = 1";
        OpenJPACriteriaQuery q = this.cb.createQuery(Department.class);
        Root d = q.from(Department.class);
        d.fetch(Department_.employees, JoinType.LEFT);
        q.where((Expression)this.cb.equal((Expression)d.get(Department_.deptNo), (Object)1)).select((Selection)d);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testJoinedPathInProjection() {
        String jpql = "SELECT p.vendor FROM Employee e JOIN e.contactInfo c JOIN c.phones p WHERE c.address.zipCode = '95054'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root e = cq.from(Employee.class);
        ListJoin p = e.join(Employee_.contactInfo).join(Contact_.phones);
        cq.where((Expression)this.cb.equal((Expression)e.get(Employee_.contactInfo).get(Contact_.address).get(Address_.zipCode), (Object)"95054"));
        cq.select((Selection)p.get(Phone_.vendor));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testKeyExpression() {
        String jpql = "select i.name, VALUE(p) from Item i join i.photos p where KEY(p) like 'egret'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo}).where((Expression)this.cb.like((Expression)photo.key(), "%egret%"));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testIndexExpression() {
        String jpql = "SELECT t FROM CreditCard c JOIN c.transactionHistory t WHERE c.customer.accountNum = 321987 AND INDEX(t) BETWEEN 0 AND 9";
        OpenJPACriteriaQuery q = this.cb.createQuery(TransactionHistory.class);
        Root c = q.from(CreditCard.class);
        ListJoin t = c.join(CreditCard_.transactionHistory);
        q.select((Selection)t).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)c.get(CreditCard_.customer).get(Customer_.accountNum), (Object)321987), (Expression)this.cb.between(t.index(), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testIsEmptyExpression() {
        String jpql = "SELECT o FROM Order o WHERE o.lineItems IS EMPTY";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root order = q.from(Order.class);
        q.where((Expression)this.cb.isEmpty(order.get(Order_.lineItems))).select((Selection)order);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExpressionInProjection() {
        String jpql = "SELECT o.quantity, o.totalCost*1.08, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara'";
        OpenJPACriteriaQuery cq = this.cb.createTupleQuery();
        Root c = cq.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        Join a = c.join(Customer_.address);
        cq.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)a.get(Address_.state), (Object)"CA"), (Expression)this.cb.equal((Expression)a.get(Address_.county), (Object)"Santa Clara")));
        cq.multiselect(new Selection[]{o.get(Order_.quantity), this.cb.prod((Expression)o.get(Order_.totalCost), (Number)1.08), a.get(Address_.zipCode)});
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testTypeExpression() {
        String jpql = "SELECT TYPE(e) FROM Employee e WHERE TYPE(e) <> Exempt";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root emp = q.from(Employee.class);
        q.multiselect(new Selection[]{emp.type()}).where((Expression)this.cb.notEqual(emp.type(), Exempt.class));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testIndexExpressionAndLietral() {
        String jpql = "SELECT w.name FROM Course c JOIN c.studentWaitList w WHERE c.name = 'Calculus' AND INDEX(w) = 0";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root course = q.from(Course.class);
        ListJoin w = course.join(Course_.studentWaitList);
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)course.get(Course_.name), (Object)"Calculus"), (Expression)this.cb.equal(w.index(), (Object)0))).select((Selection)w.get(Student_.name));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testAggregateInProjection() {
        String jpql = "SELECT SUM(i.price) FROM Order o JOIN o.lineItems i JOIN o.customer c WHERE c.lastName = 'Smith' AND c.firstName = 'John'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Double.class);
        Root o = q.from(Order.class);
        ListJoin i = o.join(Order_.lineItems);
        Join c = o.join(Order_.customer);
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)c.get(Customer_.lastName), (Object)"Smith"), (Expression)this.cb.equal((Expression)c.get(Customer_.firstName), (Object)"John")));
        q.select((Selection)this.cb.sum((Expression)i.get(LineItem_.price)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSizeExpression() {
        String jpql = "SELECT SIZE(d.employees) FROM Department d WHERE d.name = 'Sales'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root d = q.from(Department.class);
        q.where((Expression)this.cb.equal((Expression)d.get(Department_.name), (Object)"Sales"));
        q.select((Selection)this.cb.size(d.get(Department_.employees)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testCaseExpression() {
        String jpql = "SELECT e.name, CASE WHEN e.rating = 1 THEN e.salary * 1.1 WHEN e.rating = 2 THEN e.salary * 1.2 ELSE e.salary * 1.01 END FROM Employee e WHERE e.department.name = 'Engineering'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(Employee.class);
        q.where((Expression)this.cb.equal((Expression)e.get(Employee_.department).get(Department_.name), (Object)"Engineering"));
        q.multiselect(new Selection[]{e.get(Employee_.name), this.cb.selectCase().when((Expression)this.cb.equal((Expression)e.get(Employee_.rating), (Object)1), this.cb.prod((Expression)e.get(Employee_.salary), (Number)1.1)).when((Expression)this.cb.equal((Expression)e.get(Employee_.rating), (Object)2), this.cb.prod((Expression)e.get(Employee_.salary), (Number)1.2)).otherwise(this.cb.prod((Expression)e.get(Employee_.salary), (Number)1.01))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExpression1() {
        String jpql = "SELECT o.quantity, o.totalCost*1.08, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root cust = q.from(Customer.class);
        SetJoin order = cust.join(Customer_.orders);
        Join address = cust.join(Customer_.address);
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)address.get(Address_.state), (Object)"CA"), (Expression)this.cb.equal((Expression)address.get(Address_.county), (Object)"Santa Clara")));
        q.multiselect(new Selection[]{order.get(Order_.quantity), this.cb.prod((Expression)order.get(Order_.totalCost), (Number)1.08), address.get(Address_.zipCode)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExpression3() {
        String jpql = "SELECT w.name FROM Course c JOIN c.studentWaitList w WHERE c.name = 'Calculus' AND INDEX(w) = 0";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root course = q.from(Course.class);
        ListJoin w = course.join(Course_.studentWaitList);
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)course.get(Course_.name), (Object)"Calculus"), (Expression)this.cb.equal(w.index(), (Object)0))).select((Selection)w.get(Student_.name));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testGeneralCaseExpression() {
        String jpql = "SELECT e.name, CASE WHEN e.rating = 1 THEN e.salary * 1.1 WHEN e.rating = 2 THEN e.salary * 1.2 ELSE e.salary * 1.01 END FROM Employee e WHERE e.department.name = 'Engineering'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(Employee.class);
        q.where((Expression)this.cb.equal((Expression)e.get(Employee_.department).get(Department_.name), (Object)"Engineering"));
        q.multiselect(new Selection[]{e.get(Employee_.name), this.cb.selectCase().when((Expression)this.cb.equal((Expression)e.get(Employee_.rating), (Object)1), this.cb.prod((Expression)e.get(Employee_.salary), (Number)1.1)).when((Expression)this.cb.equal((Expression)e.get(Employee_.rating), (Object)2), this.cb.prod((Expression)e.get(Employee_.salary), (Number)1.2)).otherwise(this.cb.prod((Expression)e.get(Employee_.salary), (Number)1.01))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSimpleCaseExpression1() {
        String jpql = "SELECT e.name, CASE e.rating WHEN 1 THEN e.salary * 1.1 WHEN 2 THEN e.salary * 1.2 ELSE e.salary * 1.01 END FROM Employee e WHERE e.department.name = 'Engineering'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(Employee.class);
        q.where((Expression)this.cb.equal((Expression)e.get(Employee_.department).get(Department_.name), (Object)"Engineering"));
        Path salary = e.get(Employee_.salary);
        Path rating = e.get(Employee_.rating);
        q.multiselect(new Selection[]{e.get(Employee_.name), this.cb.selectCase((Expression)rating).when((Object)1, this.cb.prod((Expression)salary, (Number)1.1)).when((Object)2, this.cb.prod((Expression)salary, (Number)1.2)).otherwise(this.cb.prod((Expression)salary, (Number)1.01))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSimpleCaseExpression2() {
        String jpql = "SELECT e.name, CASE e.rating WHEN 1 THEN 10 WHEN 2 THEN 20 ELSE 30 END FROM Employee e WHERE e.department.name = 'Engineering'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(Employee.class);
        Path rating = e.get(Employee_.rating);
        q.where((Expression)this.cb.equal((Expression)e.get(Employee_.department).get(Department_.name), (Object)"Engineering"));
        q.multiselect(new Selection[]{e.get(Employee_.name), this.cb.selectCase((Expression)rating).when((Object)1, (Object)10).when((Object)2, (Object)20).otherwise((Object)30)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testLiterals() {
        String jpql = "SELECT p FROM Person p where 'Joe' MEMBER OF p.nickNames";
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        Root p = q.from(Person.class);
        q.select((Selection)p).where((Expression)this.cb.isMember(this.cb.literal((Object)"Joe"), p.get(Person_.nickNames)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testParameters1() {
        String jpql = "SELECT c FROM Customer c Where c.status = :stat";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        ParameterExpression param = this.cb.parameter(Integer.class, "stat");
        q.select((Selection)c).where((Expression)this.cb.equal((Expression)c.get(Customer_.status), (Object)param));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("stat", (Object)1);
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testParameters2() {
        String jpql = "SELECT c FROM Customer c Where c.status = :stat AND c.name = :name";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        ParameterExpression param1 = this.cb.parameter(Integer.class, "stat");
        ParameterExpression param2 = this.cb.parameter(String.class, "name");
        q.select((Selection)c).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)c.get(Customer_.status), (Object)param1), (Expression)this.cb.equal((Expression)c.get(Customer_.name), (Object)param2)));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("stat", (Object)1);
                q.setParameter("name", (Object)"test");
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testParameters_wo_paramName() {
        int rand = new Random().nextInt();
        String name = "testName_" + rand;
        String lastName = "lastName_" + rand;
        this.em.getTransaction().begin();
        Customer cNew = new Customer();
        cNew.setName(name);
        cNew.setLastName(lastName);
        cNew.setStatus(4711);
        this.em.persist((Object)cNew);
        this.em.getTransaction().commit();
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        ParameterExpression paramName = this.cb.parameter(String.class);
        ParameterExpression paramLastName = this.cb.parameter(String.class);
        q.select((Selection)c).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)c.get(Customer_.lastName), (Object)paramLastName), (Expression)this.cb.equal((Expression)c.get(Customer_.name), (Object)paramName)));
        TypedQuery query = this.em.createQuery((CriteriaQuery)q);
        query.setParameter((Parameter)paramName, (Object)name);
        query.setParameter((Parameter)paramLastName, (Object)lastName);
        System.err.println("CQ: " + query.toString());
        List customers = query.getResultList();
        TestTypesafeCriteria.assertNotNull((Object)customers);
        TestTypesafeCriteria.assertEquals((int)1, (int)customers.size());
    }

    public void testParameters3() {
        String jpql = "SELECT c FROM Customer c Where c.status = :stat";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        ParameterExpression param = this.cb.parameter(Integer.class, "stat");
        q.select((Selection)c).where((Expression)this.cb.equal((Expression)c.get(Customer_.status), (Object)param));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("stat", (Object)1);
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testParameters4() {
        String jpql = "SELECT c FROM Customer c Where c.status = :stat AND c.name = :name";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        ParameterExpression param1 = this.cb.parameter(Integer.class, "stat");
        ParameterExpression param2 = this.cb.parameter(String.class, "name");
        q.select((Selection)c).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)c.get(Customer_.status), (Object)param1), (Expression)this.cb.equal((Expression)c.get(Customer_.name), (Object)param2)));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("stat", (Object)1);
                q.setParameter("name", (Object)"test");
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testParameters5() {
        String jpql = "SELECT c FROM Customer c Where c.status IN :coll";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        ParameterExpression param1 = this.cb.parameter(List.class, "coll");
        q.where((Expression)c.get(Customer_.status).in(new Expression[]{param1}));
        q.select((Selection)c);
        final ArrayList<Integer> vals = new ArrayList<Integer>();
        vals.add(1);
        vals.add(2);
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("coll", (Object)vals);
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testSelectList1() {
        String jpql = "SELECT v.location.street, KEY(i).title, VALUE(i) FROM VideoStore v JOIN v.videoInventory i WHERE v.location.zipCode = '94301' AND VALUE(i) > 0";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root v = q.from(VideoStore.class);
        MapJoin i = v.join(VideoStore_.videoInventory);
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)v.get(VideoStore_.location).get(Address_.zipCode), (Object)"94301"), (Expression)this.cb.gt((Expression)i.value(), (Number)0)));
        q.multiselect(new Selection[]{v.get(VideoStore_.location).get(Address_.street), i.key().get(Movie_.title), i.value()});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testNewConstruct() {
        String jpql = "SELECT NEW CustomerDetails(c.id, c.status) FROM Customer c";
        OpenJPACriteriaQuery q = this.cb.createQuery(CustomerDetails.class);
        Root c = q.from(Customer.class);
        q.select((Selection)this.cb.construct(CustomerDetails.class, new Selection[]{c.get(Customer_.id), c.get(Customer_.status)}));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testConstructorInProjection() {
        String jpql = "SELECT NEW CustomerDetails(c.id, c.status, o.quantity) FROM Customer c JOIN c.orders o WHERE o.quantity > 100";
        OpenJPACriteriaQuery q = this.cb.createQuery(CustomerDetails.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Number)100));
        q.select((Selection)this.cb.construct(CustomerDetails.class, new Selection[]{c.get(Customer_.id), c.get(Customer_.status), o.get(Order_.quantity)}));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testMultipleConstructorInProjection() {
        String jpql = "SELECT NEW CustomerDetails(c.id, c.status), NEW CustomerFullName(c.firstName, c.lastName) FROM Customer c";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root c = q.from(Customer.class);
        q.multiselect(new Selection[]{this.cb.construct(CustomerDetails.class, new Selection[]{c.get(Customer_.id), c.get(Customer_.status)}), this.cb.construct(CustomerFullName.class, new Selection[]{c.get(Customer_.firstName), c.get(Customer_.lastName)})});
        this.em.createQuery((CriteriaQuery)q).getResultList();
    }

    public void testSubqueries1() {
        String jpql = "SELECT goodCustomer FROM Customer goodCustomer WHERE goodCustomer.balanceOwed < (SELECT AVG(c.balanceOwed)  FROM Customer c)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root goodCustomer = q.from(Customer.class);
        Subquery sq = q.subquery(Double.class);
        Root c = sq.from(Customer.class);
        q.where((Expression)this.cb.lt((Expression)goodCustomer.get(Customer_.balanceOwed), (Expression)sq.select(this.cb.avg((Expression)c.get(Customer_.balanceOwed)))));
        q.select((Selection)goodCustomer);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries2() {
        String jpql = "SELECT DISTINCT emp FROM Employee emp WHERE EXISTS (SELECT spouseEmp FROM Employee spouseEmp WHERE spouseEmp = emp.spouse)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        Subquery sq = q.subquery(Employee.class);
        Root spouseEmp = sq.from(Employee.class);
        sq.select((Expression)spouseEmp);
        sq.where((Expression)this.cb.equal((Expression)spouseEmp, (Expression)emp.get(Employee_.spouse)));
        q.where((Expression)this.cb.exists(sq));
        q.select((Selection)emp).distinct(true);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries3() {
        String jpql = "SELECT emp FROM Employee emp WHERE emp.salary > ALL (SELECT m.salary FROM Manager m WHERE m.department = emp.department)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        q.select((Selection)emp);
        Subquery sq = q.subquery(BigDecimal.class);
        Root m = sq.from(Manager.class);
        sq.select((Expression)m.get(Manager_.salary));
        sq.where((Expression)this.cb.equal((Expression)m.get(Manager_.department), (Expression)emp.get(Employee_.department)));
        q.where((Expression)this.cb.gt((Expression)emp.get(Employee_.salary), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries4() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM c.orders o) > 10";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c1 = q.from(Customer.class);
        q.select((Selection)c1);
        Subquery sq3 = q.subquery(Long.class);
        Root c2 = sq3.correlate(c1);
        SetJoin o = c2.join(Customer_.orders);
        q.where((Expression)this.cb.gt((Expression)sq3.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries5() {
        String jpql = "SELECT o FROM Order o WHERE 10000 < ALL (SELECT a.balance FROM o.customer c JOIN c.accounts a)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Root osq = sq.correlate(o);
        Join c = osq.join(Order_.customer);
        ListJoin a = c.join(Customer_.accounts);
        sq.select((Expression)a.get(Account_.balance));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE 10000 < ALL (SELECT a.balance FROM c.accounts a)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Join c = o.join(Order_.customer);
        Subquery sq = q.subquery(Integer.class);
        Join csq = sq.correlate(c);
        ListJoin a = csq.join(Customer_.accounts);
        sq.select((Expression)a.get(Account_.balance));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testGroupByAndHaving() {
        String jpql = "SELECT c.status, AVG(c.filledOrderCount), COUNT(c) FROM Customer c GROUP BY c.status HAVING c.status IN (1, 2)";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        q.groupBy(new Expression[]{c.get(Customer_.status)});
        q.having((Expression)this.cb.in((Expression)c.get(Customer_.status)).value((Object)1).value((Object)2));
        q.multiselect(new Selection[]{c.get(Customer_.status), this.cb.avg((Expression)c.get(Customer_.filledOrderCount)), this.cb.count((Expression)c)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering1() {
        String jpql = "SELECT o FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity DESC, o.totalCost";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        Join a = c.join(Customer_.address);
        q.where((Expression)this.cb.equal((Expression)a.get(Address_.state), (Object)"CA"));
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)o.get(Order_.quantity)), this.cb.asc((Expression)o.get(Order_.totalCost))});
        q.select((Selection)o);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering2() {
        String jpql = "SELECT o.quantity, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity, a.zipCode";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        Join a = c.join(Customer_.address);
        q.where((Expression)this.cb.equal((Expression)a.get(Address_.state), (Object)"CA"));
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc((Expression)o.get(Order_.quantity)), this.cb.asc((Expression)a.get(Address_.zipCode))});
        q.multiselect(new Selection[]{o.get(Order_.quantity), a.get(Address_.zipCode)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering3() {
        String jpql = "SELECT o.quantity, o.totalCost * 1.08 AS taxedCost, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara' ORDER BY o.quantity, taxedCost, a.zipCode";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        Join a = c.join(Customer_.address);
        Expression taxedCost = (Expression)this.cb.prod((Expression)o.get(Order_.totalCost), (Number)1.08).alias("taxedCost");
        q.where(new Predicate[]{this.cb.equal((Expression)a.get(Address_.state), (Object)"CA"), this.cb.equal((Expression)a.get(Address_.county), (Object)"Santa Clara")});
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc((Expression)o.get(Order_.quantity)), this.cb.asc(taxedCost), this.cb.asc((Expression)a.get(Address_.zipCode))});
        q.multiselect(new Selection[]{o.get(Order_.quantity), taxedCost, a.get(Address_.zipCode)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering4() {
        String jpql = "SELECT c FROM Customer c ORDER BY c.name DESC, c.status";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)c.get(Customer_.name)), this.cb.asc((Expression)c.get(Customer_.status))});
        q.select((Selection)c);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering5() {
        String jpql = "SELECT c.firstName, c.lastName, c.balanceOwed FROM Customer c ORDER BY c.name DESC, c.status";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)c.get(Customer_.name)), this.cb.asc((Expression)c.get(Customer_.status))});
        q.multiselect(new Selection[]{c.get(Customer_.firstName), c.get(Customer_.lastName), c.get(Customer_.balanceOwed)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    @AllowFailure(message="runs only on databases with CURRENT_USER() function e.g. MySQL but not Derby")
    public void testFunctionWithNoArgument() {
        String jpql = "SELECT c.balanceOwed FROM Customer c";
        String sql = "SELECT CURRENT_USER(), t0.balanceOwed FROM CR_CUST t0";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        q.multiselect(new Selection[]{this.cb.function("CURRENT_USER", String.class, (Expression[])null), c.get(Customer_.balanceOwed)});
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testFunctionWithOneArgument() {
        String jpql = "SELECT MAX(c.balanceOwed) FROM Customer c";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        q.multiselect(new Selection[]{this.cb.function("MAX", Integer.class, new Expression[]{c.get(Customer_.balanceOwed)})});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testFunctionWithTwoArgument() {
        String jpql = "SELECT MOD(c.balanceOwed,10) FROM Customer c";
        if (this.getDictionary().supportsModOperator) {
            this.getEntityManagerFactory().getConfiguration().getLog("test").warn((Object)"SKIPPING testFunctionWithTwoArgument() for SQLServer");
            return;
        }
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        q.multiselect(new Selection[]{this.cb.function("MOD", Integer.class, new Expression[]{c.get(Customer_.balanceOwed), this.cb.literal((Object)10)})});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testFunctionWithFunctionArgumentInOrderBy() {
        String jpql = "SELECT MOD(c.balanceOwed,10) FROM Customer c WHERE LENGTH(c.name)>3 ORDER BY LENGTH(c.name)";
        String sql = "SELECT MOD(t0.balanceOwed, ?), LENGTH(t0.name) FROM CR_CUST t0 WHERE (LENGTH(t0.name) > ?) ORDER BY LENGTH(t0.name) ASC";
        if (this.getDictionary().supportsModOperator) {
            this.getEntityManagerFactory().getConfiguration().getLog("test").warn((Object)"SKIPPING testFunctionWithFunctionArgumentInOrderBy() for SQLServer");
            return;
        }
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        Expression nameLength = this.cb.function("LENGTH", Integer.class, new Expression[]{c.get(Customer_.name)});
        q.multiselect(new Selection[]{this.cb.function("MOD", Integer.class, new Expression[]{c.get(Customer_.balanceOwed), this.cb.literal((Object)10)})});
        q.where((Expression)this.cb.greaterThan(nameLength, (Comparable)Integer.valueOf(3)));
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc(nameLength)});
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys1() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE ((t1.KEY0 = ? OR t1.KEY0 = ? OR t1.KEY0 = ? OR t1.KEY0 = ? OR t1.KEY0 = ?) AND 0 < (SELECT COUNT(*) FROM CR_ITEM_photos WHERE CR_ITEM_photos.ITEM_ID = t0.id))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)photo.key().in(new Expression[]{this.cb.keys(photo1)}));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys2() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (t1.KEY0 IN (?, ?, ?, ?, ?))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isMember((Expression)photo.key(), this.cb.keys(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys3() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (1 <> 1)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isEmpty(this.cb.keys(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys4() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (5 = 5)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.equal(this.cb.size(this.cb.keys(photo1)), (Object)5));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys5() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (NOT (t1.KEY0 = ? OR t1.KEY0 = ? OR t1.KEY0 = ? OR t1.KEY0 = ? OR t1.KEY0 = ?) AND 0 < (SELECT COUNT(*) FROM CR_ITEM_photos WHERE CR_ITEM_photos.ITEM_ID = t0.id))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)photo.key().in(new Expression[]{this.cb.keys(photo1)}).not());
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys6() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (NOT (t1.KEY0 IN (?, ?, ?, ?, ?)))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isNotMember((Expression)photo.key(), this.cb.keys(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys7() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (NOT (1 <> 1))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isNotEmpty(this.cb.keys(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testKeys8() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (5 = 4)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.equal(this.cb.size(this.cb.keys(photo1)), (Object)4));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValues1() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE ((t1.VALUE_ID = ? OR t1.VALUE_ID = ? OR t1.VALUE_ID = ? OR t1.VALUE_ID = ? OR t1.VALUE_ID = ?) AND 0 < (SELECT COUNT(*) FROM CR_ITEM_photos WHERE CR_ITEM_photos.ITEM_ID = t0.id))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)photo.value().in(new Expression[]{this.cb.values(photo1)}));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValues2() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (t1.VALUE_ID IN (?, ?, ?, ?, ?))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isMember((Expression)photo.value(), this.cb.values(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValues3() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (1 <> 1)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isEmpty(this.cb.values(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValue4() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (5 = 5)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.equal(this.cb.size(this.cb.values(photo1)), (Object)5));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValues5() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (0 = (SELECT COUNT(*) FROM CR_ITEM_photos t3 WHERE (t3.VALUE_ID = ? OR t3.VALUE_ID = ? OR t3.VALUE_ID = ? OR t3.VALUE_ID = ? OR t3.VALUE_ID = ?) AND t0.id = t1.ITEM_ID) AND 0 < (SELECT COUNT(*) FROM CR_ITEM_photos WHERE CR_ITEM_photos.ITEM_ID = t0.id))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)photo.value().in(new Expression[]{this.cb.values(photo1)}).not());
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValues6() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (NOT (t1.VALUE_ID IN (?, ?, ?, ?, ?)))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isNotMember((Expression)photo.value(), this.cb.values(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValues7() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (NOT (1 <> 1))";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.isNotEmpty(this.cb.values(photo1)));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testValue8() {
        String sql = "SELECT t0.name, t2.id, t2.label FROM CR_ITEM t0 INNER JOIN CR_ITEM_photos t1 ON t0.id = t1.ITEM_ID INNER JOIN CR_PHT t2 ON t1.VALUE_ID = t2.id WHERE (5 = 4)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root item = q.from(Item.class);
        MapJoin photo = item.join(Item_.photos);
        q.multiselect(new Selection[]{item.get(Item_.name), photo});
        HashMap<String, Photo> photo1 = new HashMap<String, Photo>();
        for (int i = 0; i < 5; ++i) {
            Photo p1 = new Photo();
            p1.setLabel("label" + i);
            photo1.put("photo" + i, p1);
        }
        q.where((Expression)this.cb.equal(this.cb.size(this.cb.values(photo1)), (Object)4));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, sql);
    }

    public void testJoinKey() {
        this.em.getTransaction().begin();
        this.em.createQuery("DELETE FROM Student s").executeUpdate();
        this.em.createQuery("DELETE FROM Course s").executeUpdate();
        this.em.createQuery("DELETE FROM Semester s").executeUpdate();
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        Student s1 = new Student();
        s1.setName("S1");
        Student s2 = new Student();
        s2.setName("S2");
        Student s3 = new Student();
        s3.setName("S3");
        Student s4 = new Student();
        s4.setName("S4");
        Semester sm1 = new Semester();
        sm1.setName("Summer");
        Semester sm2 = new Semester();
        sm2.setName("Fall");
        Course c1 = new Course();
        c1.setName("C1");
        Course c2 = new Course();
        c2.setName("C2");
        s1.addToEnrollment(c1, sm1);
        s1.addToEnrollment(c2, sm2);
        s2.addToEnrollment(c2, sm1);
        s2.addToEnrollment(c1, sm2);
        s3.addToEnrollment(c1, sm2);
        s4.addToEnrollment(c2, sm1);
        this.em.persist((Object)s1);
        this.em.persist((Object)s2);
        this.em.persist((Object)s3);
        this.em.persist((Object)s4);
        this.em.persist((Object)c1);
        this.em.persist((Object)c2);
        this.em.persist((Object)sm1);
        this.em.persist((Object)sm2);
        this.em.getTransaction().commit();
        String jpql = "select s from Student s JOIN s.enrollment e where KEY(e).name=:name";
        List jResult = this.em.createQuery(jpql).setParameter("name", (Object)"C1").getResultList();
        OpenJPACriteriaQuery q = this.cb.createQuery(Student.class);
        Root s = q.from(Student.class);
        Join c = ((Joins.Map)s.join(Student_.enrollment)).joinKey();
        q.where((Expression)this.cb.equal((Expression)c.get(Course_.name), (Expression)this.cb.parameter(String.class, "name")));
        List cResult = this.em.createQuery((CriteriaQuery)q).setParameter("name", (Object)"C1").getResultList();
        TestTypesafeCriteria.assertFalse((boolean)jResult.isEmpty());
        TestTypesafeCriteria.assertEquals((int)cResult.size(), (int)jResult.size());
        for (int i = 0; i < jResult.size(); ++i) {
            TestTypesafeCriteria.assertEquals((String)((Student)jResult.get(i)).getName(), (String)((Student)cResult.get(i)).getName());
        }
    }

    public void testAliasInOrderByClause() {
        String jpql = "SELECT AVG(a.balance) AS x FROM Account a ORDER BY x";
        OpenJPACriteriaQuery c = this.cb.createQuery(Double.class);
        Root account = c.from(Account.class);
        Expression original = this.cb.avg((Expression)account.get(Account_.balance));
        Expression aliased = (Expression)original.alias("x");
        c.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc(aliased)});
        TestTypesafeCriteria.assertSame((Object)original, (Object)aliased);
        TestTypesafeCriteria.assertEquals((String)"x", (String)aliased.getAlias());
        c.select((Selection)aliased);
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        TestTypesafeCriteria.assertEquals((String)jpql, (String)c.toCQL());
    }

    public void testRealiasNotAllowed() {
        OpenJPACriteriaQuery c = this.cb.createQuery(Double.class);
        Root account = c.from(Account.class);
        Expression term = this.cb.avg((Expression)account.get(Account_.balance));
        term.alias("firsttime");
        try {
            term.alias("secondtime");
            TestTypesafeCriteria.fail((String)"Expected to fail on re-aliasing");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInvalidAliasNotAllowed() {
        OpenJPACriteriaQuery c = this.cb.createQuery(Double.class);
        Root account = c.from(Account.class);
        Expression term = this.cb.avg((Expression)account.get(Account_.balance));
        try {
            term.alias("from");
            TestTypesafeCriteria.fail((String)"Expected to fail on reserved word as alias");
        }
        catch (IllegalArgumentException e) {
            TestTypesafeCriteria.assertNull((Object)term.getAlias());
        }
        try {
            term.alias(" with a space");
            TestTypesafeCriteria.fail((String)"Expected to fail on invalid alias");
        }
        catch (IllegalArgumentException e) {
            TestTypesafeCriteria.assertNull((Object)term.getAlias());
        }
        try {
            term.alias(" with?known_symbol");
            TestTypesafeCriteria.fail((String)"Expected to fail on invalid alias");
        }
        catch (IllegalArgumentException e) {
            TestTypesafeCriteria.assertNull((Object)term.getAlias());
        }
    }

    public void testInvalidParameterName() {
        try {
            this.cb.parameter(Integer.class, "from");
            TestTypesafeCriteria.fail((String)"Expected to fail on reserved word as alias");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.cb.parameter(Integer.class, ":name");
            TestTypesafeCriteria.fail((String)"Expected to fail on invalid alias");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.cb.parameter(Integer.class, "?3");
            TestTypesafeCriteria.fail((String)"Expected to fail on invalid alias");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGroupByOnMaxResult() {
        String jpql = "SELECT c.address.country, count(c) from Customer c GROUP BY c.address.country HAVING COUNT(c.address.country)>3";
        OpenJPACriteriaQuery c = this.cb.createQuery(Object[].class);
        Root customer = c.from(Customer.class);
        Path country = customer.get(Customer_.address).get(Address_.country);
        c.multiselect(new Selection[]{country, this.cb.count((Expression)customer)}).groupBy(new Expression[]{country}).having((Expression)this.cb.gt(this.cb.count((Expression)country), (Number)3));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setMaxResults(20);
            }
        }, (CriteriaQuery<?>)c, jpql);
    }

    public void testEmptyAnd() {
        OpenJPACriteriaQuery c = this.cb.createQuery(Order.class);
        Root order = c.from(Order.class);
        c.where((Expression)this.cb.and((Expression)this.cb.not((Expression)this.cb.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Robert E. Bissett")), (Expression)this.cb.isTrue((Expression)this.cb.conjunction())));
        this.em.createQuery((CriteriaQuery)c).getResultList();
    }

    public void testEmptyOr() {
        OpenJPACriteriaQuery c = this.cb.createQuery(Order.class);
        Root order = c.from(Order.class);
        c.where((Expression)this.cb.and((Expression)this.cb.not((Expression)this.cb.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Robert E. Bissett")), (Expression)this.cb.isTrue((Expression)this.cb.disjunction())));
        this.em.createQuery((CriteriaQuery)c).getResultList();
    }

    public void testDefaultProjectionWithUntypedResult() {
        OpenJPACriteriaQuery cquery = this.cb.createQuery();
        Root customer = cquery.from(Customer.class);
        EntityType Customer_2 = customer.getModel();
        cquery.where((Expression)this.cb.equal((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), this.cb.nullLiteral(String.class)));
        TypedQuery q = this.em.createQuery((CriteriaQuery)cquery);
    }

    public void testCountDistinct() {
        String jpql = "select COUNT(DISTINCT a.name) from Account a";
        OpenJPACriteriaQuery c = this.cb.createQuery(Long.class);
        Root a = c.from(Account.class);
        c.select((Selection)this.cb.countDistinct((Expression)a.get(Account_.name)));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testCountDistinctOnJoin() {
        String jpql = "select COUNT(DISTINCT a.b.age) from A a";
        OpenJPACriteriaQuery c = this.cb.createQuery(Long.class);
        Root a = c.from(A.class);
        c.select((Selection)this.cb.countDistinct((Expression)a.get(A_.b).get(B_.age)));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testSizeReturnsInteger() {
        String jpql = "select SIZE(c.accounts) from Customer c";
        OpenJPACriteriaQuery c = this.cb.createQuery(Integer.class);
        Root customer = c.from(Customer.class);
        c.select((Selection)this.cb.size(customer.get(Customer_.accounts)));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testDisjunctionAsFalse() {
        Metamodel mm = this.em.getMetamodel();
        OpenJPACriteriaQuery cquery = this.cb.createQuery(Order.class);
        Root order = cquery.from(Order.class);
        EntityType Order_2 = order.getModel();
        EntityType Customer_2 = mm.entity(Customer.class);
        cquery.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)this.cb.isFalse((Expression)this.cb.disjunction())));
        cquery.distinct(true);
        TypedQuery q = this.em.createQuery((CriteriaQuery)cquery);
        List result = q.getResultList();
    }

    public void testCurrentTimeReturnsSQLTypes() {
        if (this.getDictionary() instanceof OracleDictionary) {
            return;
        }
        this.em.getTransaction().begin();
        Product pc = new Product();
        this.em.persist((Object)pc);
        this.em.getTransaction().commit();
        int pid = pc.getPid();
        OpenJPACriteriaQuery cquery = this.cb.createQuery(Time.class);
        Root product = cquery.from(Product.class);
        cquery.select((Selection)this.cb.currentTime());
        cquery.where((Expression)this.cb.equal((Expression)product.get(Product_.pid), (Object)pid));
        TypedQuery tq = this.em.createQuery((CriteriaQuery)cquery);
        Object result = tq.getSingleResult();
        TestTypesafeCriteria.assertTrue((String)(result.getClass() + " not instance of Time"), (boolean)(result instanceof Time));
    }

    public void testCurrentDateReturnsSQLTypes() {
        this.em.getTransaction().begin();
        Order pc = new Order();
        this.em.persist((Object)pc);
        this.em.getTransaction().commit();
        int oid = pc.getId();
        OpenJPACriteriaQuery cquery = this.cb.createQuery(Date.class);
        Root order = cquery.from(Order.class);
        cquery.select((Selection)this.cb.currentDate());
        cquery.where((Expression)this.cb.equal((Expression)order.get(Order_.id), (Object)oid));
        TypedQuery tq = this.em.createQuery((CriteriaQuery)cquery);
        Object result = tq.getSingleResult();
        TestTypesafeCriteria.assertTrue((String)(result.getClass() + " not instance of Date"), (boolean)(result instanceof Date));
    }

    public void testCurrentTimestampReturnsSQLTypes() {
        this.em.getTransaction().begin();
        Order pc = new Order();
        this.em.persist((Object)pc);
        this.em.getTransaction().commit();
        int oid = pc.getId();
        OpenJPACriteriaQuery cquery = this.cb.createQuery(Timestamp.class);
        Root order = cquery.from(Order.class);
        cquery.select((Selection)this.cb.currentTimestamp());
        cquery.where((Expression)this.cb.equal((Expression)order.get(Order_.id), (Object)oid));
        TypedQuery tq = this.em.createQuery((CriteriaQuery)cquery);
        Object result = tq.getSingleResult();
        TestTypesafeCriteria.assertTrue((String)(result.getClass() + " not instance of Timestamp"), (boolean)(result instanceof Timestamp));
    }

    public void testLiteralInProjection() {
        String jpql = "select 'a' from Customer c where c.id=10";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root c = cq.from(Customer.class);
        cq.select((Selection)this.cb.toString(this.cb.literal((Object)Character.valueOf('a'))));
        cq.where((Expression)this.cb.equal((Expression)c.get(Customer_.id), (Object)10));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testBigDecimalConversion() {
        String jpql = "select c.accountNum*10.32597 from Customer c where c.id=10";
        long accountNumber = 1234516279L;
        if (this.getDictionary() instanceof AbstractSQLServerDictionary) {
            this.getEntityManagerFactory().getConfiguration().getLog("test").warn((Object)"SKIPPING testBigDecimalConversion() for SQLServer & Sybase");
            return;
        }
        this.em.getTransaction().begin();
        Customer customer = new Customer();
        customer.setAccountNum(accountNumber);
        this.em.persist((Object)customer);
        this.em.getTransaction().commit();
        long cid = customer.getId();
        OpenJPACriteriaQuery cq = this.cb.createQuery(BigDecimal.class);
        Root c = cq.from(Customer.class);
        cq.select((Selection)this.cb.toBigDecimal(this.cb.prod((Expression)c.get(Customer_.accountNum), (Number)new BigDecimal(10.32597))));
        cq.where((Expression)this.cb.equal((Expression)c.get(Customer_.id), (Object)cid));
        List result = this.em.createQuery((CriteriaQuery)cq).getResultList();
        TestTypesafeCriteria.assertFalse((boolean)result.isEmpty());
        TestTypesafeCriteria.assertTrue((boolean)(result.get(0) instanceof BigDecimal));
    }

    public void testIdClass() {
        String jpql = "select p from EntityWithIdClass p";
        OpenJPACriteriaQuery cq = this.cb.createQuery(EntityWithIdClass.class);
        Root c = cq.from(EntityWithIdClass.class);
        this.em.createQuery((CriteriaQuery)cq).getResultList();
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }
}

