/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.sql.Timestamp;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.Address_;
import org.apache.openjpa.persistence.criteria.CompUser;
import org.apache.openjpa.persistence.criteria.CompUser_;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Customer;
import org.apache.openjpa.persistence.criteria.Customer_;
import org.apache.openjpa.persistence.criteria.LineItem;
import org.apache.openjpa.persistence.criteria.LineItem_;
import org.apache.openjpa.persistence.criteria.Magazine;
import org.apache.openjpa.persistence.criteria.Magazine_;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Order;
import org.apache.openjpa.persistence.criteria.Order_;
import org.apache.openjpa.persistence.criteria.Publisher;
import org.apache.openjpa.persistence.criteria.Publisher_;

public class TestSubqueries
extends CriteriaTest {
    public void testExist() {
        String query = "SELECT DISTINCT o.name FROM CompUser o WHERE EXISTS (SELECT c FROM Address c WHERE c = o.address )";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root o = q.from(CompUser.class);
        Subquery sq = q.subquery(Address.class);
        Root c = sq.from(Address.class);
        sq.select((Expression)c);
        sq.where((Expression)this.cb.equal((Expression)c, (Expression)o.get(CompUser_.address)));
        q.where((Expression)this.cb.exists(sq));
        q.select((Selection)o.get(CompUser_.name)).distinct(true);
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testNotExist() {
        String query = "SELECT DISTINCT o.name FROM CompUser o WHERE NOT EXISTS (SELECT s FROM CompUser s WHERE s.address.country = o.address.country)";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root o = q.from(CompUser.class);
        Subquery sq = q.subquery(CompUser.class);
        Root s = sq.from(CompUser.class);
        sq.select((Expression)s);
        sq.where((Expression)this.cb.equal((Expression)s.get(CompUser_.address).get(Address_.country), (Expression)o.get(CompUser_.address).get(Address_.country)));
        q.where((Expression)this.cb.exists(sq).not());
        q.select((Selection)o.get(CompUser_.name)).distinct(true);
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testAny() {
        String query = "SELECT o.name FROM CompUser o WHERE o.address.zipCode =  ANY (SELECT s.computerName  FROM CompUser s WHERE s.address.country IS NOT NULL)";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root o = q.from(CompUser.class);
        q.select((Selection)o.get(CompUser_.name));
        Subquery sq = q.subquery(String.class);
        Root s = sq.from(CompUser.class);
        sq.select((Expression)s.get(CompUser_.computerName));
        sq.where((Expression)this.cb.notEqual((Expression)s.get(CompUser_.address).get(Address_.country), null));
        q.where((Expression)this.cb.equal((Expression)o.get(CompUser_.address).get(Address_.zipCode), this.cb.any(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery01() {
        String query = "select o1.id from Order o1 where o1.id in  (select distinct o.id from LineItem i, Order o where i.quantity > 10 and o.count > 1000 and i.id = o.id)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o1 = q.from(Order.class);
        q.select((Selection)o1.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root i = sq.from(LineItem.class);
        Root o = sq.from(Order.class);
        sq.where((Expression)this.cb.and((Expression)this.cb.and((Expression)this.cb.gt((Expression)i.get(LineItem_.quantity), (Number)10), (Expression)this.cb.gt((Expression)o.get(Order_.count), (Number)1000)), (Expression)this.cb.equal((Expression)i.get(LineItem_.id), (Expression)o.get(Order_.id))));
        sq.select((Expression)o.get(Order_.id)).distinct(true);
        q.where((Expression)this.cb.in((Expression)o1.get(Order_.id)).value((Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery02() {
        String query = "select o.id from Order o where o.customer.balanceOwed = (select max(o2.customer.balanceOwed) from Order o2 where o.customer.id = o2.customer.id)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.balanceOwed), (Expression)sq.select(this.cb.max((Expression)o2.get(Order_.customer).get(Customer_.balanceOwed)))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery03() {
        String query = "select o from Order o where o.customer.balanceOwed = (select max(o2.customer.balanceOwed) from Order o2 where o.customer.id = o2.customer.id)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.balanceOwed), (Expression)sq.select(this.cb.max((Expression)o2.get(Order_.customer).get(Customer_.balanceOwed)))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery04() {
        String query = "select o.id from Order o where o.quantity > (select count(i) from o.lineItems i)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Long.class);
        Root osq = sq.correlate(o);
        ListJoin i = osq.join(Order_.lineItems);
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq.select(this.cb.count((Expression)i))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery05() {
        String query = "select o.id from Order o where o.quantity > (select count(o.quantity) from Order o)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Long.class);
        Root o2 = sq.from(Order.class);
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq.select(this.cb.count((Expression)o2.get(Order_.quantity)))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery06() {
        String query = "select o.id from Order o where o.quantity > (select count(o.id) from Order o)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Long.class);
        Root o2 = sq.from(Order.class);
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq.select(this.cb.count((Expression)o2.get(Order_.id)))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery07() {
        String query = "select o.id from Order o where o.quantity > (select avg(o.quantity) from Order o)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Double.class);
        Root o2 = sq.from(Order.class);
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq.select(this.cb.avg((Expression)o2.get(Order_.quantity)))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery08() {
        String query = "select c.name from Customer c where exists(select o from c.orders o where o.id = 1) or exists(select o from c.orders o where o.id = 2)";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c.get(Customer_.name));
        Subquery sq1 = q.subquery(Order.class);
        Root c1 = sq1.correlate(c);
        SetJoin o1 = c1.join(Customer_.orders);
        sq1.where((Expression)this.cb.equal((Expression)o1.get(Order_.id), (Object)1)).select((Expression)o1);
        Subquery sq2 = q.subquery(Order.class);
        Root c2 = sq2.correlate(c);
        SetJoin o2 = c2.join(Customer_.orders);
        sq2.where((Expression)this.cb.equal((Expression)o2.get(Order_.id), (Object)2)).select((Expression)o2);
        q.where((Expression)this.cb.or((Expression)this.cb.exists(sq1), (Expression)this.cb.exists(sq2)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery09() {
        String query = "select c.name from Customer c, in(c.orders) o where o.quantity between (select max(o.quantity) from Order o) and (select avg(o.quantity) from Order o) ";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c.get(Customer_.name));
        Subquery sq1 = q.subquery(Integer.class);
        Root o1 = sq1.from(Order.class);
        sq1.select(this.cb.max((Expression)o1.get(Order_.quantity)));
        Subquery sq2 = q.subquery(Double.class);
        Root o2 = sq2.from(Order.class);
        sq2.select(this.cb.avg((Expression)o2.get(Order_.quantity)));
        SetJoin o = c.join(Customer_.orders);
        q.where((Expression)this.cb.between((Expression)o.get(Order_.quantity), (Expression)sq1, sq2.as(Integer.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery10() {
        String query = "select o.id from Order o where o.quantity > (select sum(o2.quantity) from Customer c, in(c.orders) o2) ";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root c = sq.from(Customer.class);
        SetJoin o2 = c.join(Customer_.orders);
        sq.select(this.cb.sum((Expression)o2.get(Order_.quantity)));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery11() {
        String query = "select o.id from Order o where o.quantity between (select avg(o2.quantity) from Customer c, in(c.orders) o2) and (select min(o2.quantity) from Customer c, in(c.orders) o2)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq1 = q.subquery(Double.class);
        Root c = sq1.from(Customer.class);
        SetJoin o2 = c.join(Customer_.orders);
        sq1.select(this.cb.avg((Expression)o2.get(Order_.quantity)));
        Subquery sq2 = q.subquery(Integer.class);
        Root c2 = sq2.from(Customer.class);
        SetJoin o3 = c2.join(Customer_.orders);
        sq2.select(this.cb.min((Expression)o3.get(Order_.quantity)));
        q.where((Expression)this.cb.between((Expression)o.get(Order_.quantity), sq1.as(Integer.class), (Expression)sq2));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery12() {
        String query = "select o.id from Customer c, in(c.orders)o where o.quantity > (select sum(o2.quantity) from c.orders o2)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root sqc = sq.correlate(c);
        SetJoin o2 = sqc.join(Customer_.orders);
        sq.select(this.cb.sum((Expression)o2.get(Order_.quantity)));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery13() {
        String query = "select o1.id, c.name from Order o1, Customer c where o1.quantity =  any(select o2.quantity from in(c.orders) o2)";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root o1 = q.from(Order.class);
        Root c = q.from(Customer.class);
        q.multiselect(new Selection[]{o1.get(Order_.id), c.get(Customer_.name)});
        Subquery sq = q.subquery(Integer.class);
        Root sqc = sq.correlate(c);
        SetJoin o2 = sqc.join(Customer_.orders);
        sq.select((Expression)o2.get(Order_.quantity));
        q.where((Expression)this.cb.equal((Expression)o1.get(Order_.quantity), this.cb.any(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery14() {
        String query = "SELECT p, m FROM Publisher p LEFT OUTER JOIN p.magazineCollection m WHERE m.id = (SELECT MAX(m2.id) FROM Magazine m2 WHERE m2.idPublisher.id = p.id AND m2.id = (SELECT MAX(m3.id) FROM Magazine m3 WHERE m3.idPublisher.id = p.id)) ";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root p = q.from(Publisher.class);
        SetJoin m = p.join(Publisher_.magazineCollection, JoinType.LEFT);
        q.multiselect(new Selection[]{p, m});
        Subquery sq = q.subquery(Integer.class);
        Root m2 = sq.from(Magazine.class);
        q.where((Expression)this.cb.equal((Expression)m.get(Magazine_.id), (Expression)sq.select(this.cb.max((Expression)m2.get(Magazine_.id)))));
        Subquery sq2 = q.subquery(Integer.class);
        Root m3 = sq2.from(Magazine.class);
        sq2.where((Expression)this.cb.equal((Expression)m3.get(Magazine_.idPublisher).get(Publisher_.id), (Expression)p.get(Publisher_.id)));
        sq.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)m2.get(Magazine_.idPublisher).get(Publisher_.id), (Expression)p.get(Publisher_.id)), (Expression)this.cb.equal((Expression)m2.get(Magazine_.id), (Expression)sq2.select(this.cb.max((Expression)m3.get(Magazine_.id))))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery15() {
        String query = "select o.id from Order o where o.delivered =(select    CASE WHEN o2.quantity > 10 THEN true     WHEN o2.quantity = 10 THEN false      ELSE false END from Order o2 where o.customer.id = o2.customer.id)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Object.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        sq.select(this.cb.selectCase().when((Expression)this.cb.gt((Expression)o2.get(Order_.quantity), (Number)10), (Object)true).when((Expression)this.cb.equal((Expression)o2.get(Order_.quantity), (Object)10), (Object)false).otherwise((Object)false));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.delivered), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery16() {
        String query = "select o1.id from Order o1 where o1.quantity >  (select o.quantity*2 from LineItem i, Order o where i.quantity > 10 and o.quantity > 1000 and i.id = o.id)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o1 = q.from(Order.class);
        q.select((Selection)o1.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root i = sq.from(LineItem.class);
        Root o = sq.from(Order.class);
        sq.where((Expression)this.cb.and((Expression)this.cb.and((Expression)this.cb.gt((Expression)i.get(LineItem_.quantity), (Number)10), (Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Number)1000)), (Expression)this.cb.equal((Expression)i.get(LineItem_.id), (Expression)o.get(Order_.id))));
        q.where((Expression)this.cb.gt((Expression)o1.get(Order_.quantity), (Expression)sq.select(this.cb.prod((Expression)o.get(Order_.quantity), (Number)2))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery17() {
        String query = "select o.id from Order o where o.customer.name = (select substring(o2.customer.name, 3) from Order o2 where o.customer.id = o2.customer.id)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(String.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.name), (Expression)sq.select(this.cb.substring((Expression)o2.get(Order_.customer).get(Customer_.name), 3))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery18() {
        String query = "select o.id from Order o where o.orderTs > (select CURRENT_TIMESTAMP from o.lineItems i)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Timestamp.class);
        Root o2 = sq.correlate(o);
        ListJoin i = o2.join(Order_.lineItems);
        q.where((Expression)this.cb.gt(o.get(Order_.orderTs).as(Long.class), sq.select(this.cb.currentTimestamp()).as(Long.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery19() {
        String query = "select o.id from Order o where o.quantity > (select SQRT(o.quantity) from Order o where o.delivered = true)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Double.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o2.get(Order_.delivered), (Object)true));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq.select(this.cb.sqrt((Expression)o2.get(Order_.quantity)))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery20() {
        String query = "select o.id from Order o where o.customer.name in (select CONCAT(o.customer.name, 'XX') from Order o where o.quantity > 10)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(String.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.gt((Expression)o2.get(Order_.quantity), (Number)10));
        q.where((Expression)this.cb.in((Expression)o.get(Order_.customer).get(Customer_.name)).value((Expression)sq.select(this.cb.concat((Expression)o2.get(Order_.customer).get(Customer_.name), "XX"))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery21() {
        String query = "select c from Customer c where c.creditRating = (select    CASE WHEN o2.quantity > 10 THEN org.apache.openjpa.persistence.criteria.Customer$CreditRating.POOR WHEN o2.quantity = 10 THEN org.apache.openjpa.persistence.criteria.Customer$CreditRating.GOOD      ELSE org.apache.openjpa.persistence.criteria.Customer$CreditRating.EXCELLENT      END from Order o2 where c.id = o2.customer.id)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Object.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)c.get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        Expression generalCase = this.cb.selectCase().when((Expression)this.cb.gt((Expression)o2.get(Order_.quantity), (Number)10), (Object)Customer.CreditRating.POOR).when((Expression)this.cb.equal((Expression)o2.get(Order_.quantity), (Object)10), (Object)Customer.CreditRating.GOOD).otherwise((Object)Customer.CreditRating.EXCELLENT);
        sq.select(generalCase);
        q.where((Expression)this.cb.equal((Expression)c.get(Customer_.creditRating), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery22() {
        String query = "select c from Customer c where c.creditRating = (select COALESCE (c1.creditRating, org.apache.openjpa.persistence.criteria.Customer$CreditRating.POOR) from Customer c1 where c1.name = 'Famzy') order by c.name DESC";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)c.get(Customer_.name))});
        Subquery sq = q.subquery(Customer.CreditRating.class);
        Root c1 = sq.from(Customer.class);
        sq.where((Expression)this.cb.equal((Expression)c1.get(Customer_.name), (Object)"Famzy"));
        Expression coalesce = this.cb.coalesce((Expression)c1.get(Customer_.creditRating), (Object)Customer.CreditRating.POOR);
        sq.select(coalesce);
        q.where((Expression)this.cb.equal((Expression)c.get(Customer_.creditRating), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery23() {
        String query = "select c from Customer c where c.creditRating = (select NULLIF (c1.creditRating, org.apache.openjpa.persistence.criteria.Customer$CreditRating.POOR) from Customer c1 where c1.name = 'Famzy') order by c.name DESC";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)c.get(Customer_.name))});
        Subquery sq = q.subquery(Customer.CreditRating.class);
        Root c1 = sq.from(Customer.class);
        sq.where((Expression)this.cb.equal((Expression)c1.get(Customer_.name), (Object)"Famzy"));
        q.where((Expression)this.cb.equal((Expression)c.get(Customer_.creditRating), (Expression)sq.select(this.cb.nullif((Expression)c1.get(Customer_.creditRating), (Object)Customer.CreditRating.POOR))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSubquery24() {
        this.em.getTransaction().begin();
        this.freshCustomerAndOrder();
        OpenJPACriteriaQuery q = this.cb.createQuery(Long.class);
        Root root = q.from(Customer.class);
        q.select((Selection)root.get(Customer_.accountNum));
        ParameterExpression testParam = this.cb.parameter(String.class, "param1");
        Subquery sq = q.subquery(Customer.class);
        Root sqRoot = sq.from(Order.class);
        sq.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)this.cb.parameter(String.class, "param2"), (Expression)sqRoot.get(Order_.customer).get(Customer_.lastName)), (Expression)this.cb.equal((Expression)testParam, (Expression)sqRoot.get(Order_.customer).get(Customer_.name))));
        sq.select((Expression)sqRoot.get(Order_.customer));
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)testParam, (Expression)root.get(Customer_.name)), (Expression)this.cb.in((Expression)root).value((Expression)sq)));
        TypedQuery tq = this.em.createQuery((CriteriaQuery)q);
        tq.setParameter("param1", (Object)"Capricorn");
        tq.setParameter("param2", (Object)"Doe");
        TestSubqueries.assertEquals((int)1, (int)tq.getResultList().size());
        this.em.getTransaction().rollback();
        this.cleanCustomerAndOrder();
    }

    public void testSubquery25() {
        this.em.getTransaction().begin();
        this.freshCustomerAndOrder();
        OpenJPACriteriaQuery q = this.cb.createQuery(Long.class);
        Root root = q.from(Customer.class);
        q.select((Selection)root.get(Customer_.accountNum));
        ParameterExpression testParam = this.cb.parameter(String.class, "param1");
        ParameterExpression testParam2 = this.cb.parameter(String.class, "param1");
        Subquery sq = q.subquery(Customer.class);
        Root sqRoot = sq.from(Order.class);
        sq.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)this.cb.parameter(String.class, "param2"), (Expression)sqRoot.get(Order_.customer).get(Customer_.lastName)), (Expression)this.cb.equal((Expression)testParam, (Expression)sqRoot.get(Order_.customer).get(Customer_.name))));
        sq.select((Expression)sqRoot.get(Order_.customer));
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)testParam2, (Expression)root.get(Customer_.name)), (Expression)this.cb.in((Expression)root).value((Expression)sq)));
        TypedQuery tq = this.em.createQuery((CriteriaQuery)q);
        tq.setParameter("param1", (Object)"Capricorn");
        tq.setParameter("param2", (Object)"Doe");
        TestSubqueries.assertEquals((int)1, (int)tq.getResultList().size());
        this.em.getTransaction().rollback();
        this.cleanCustomerAndOrder();
    }

    private void freshCustomerAndOrder() {
        this.cleanCustomerAndOrder();
        Customer c1 = new Customer();
        c1.setAccountNum(156L);
        c1.setFirstName("John");
        c1.setLastName("Doe");
        c1.setName("Capricorn");
        this.em.persist((Object)c1);
        Order o1 = new Order();
        o1.setCustomer(c1);
        this.em.persist((Object)o1);
        o1 = new Order();
        o1.setCustomer(c1);
        this.em.persist((Object)o1);
        this.em.flush();
    }

    private void cleanCustomerAndOrder() {
        boolean txActive = this.em.getTransaction().isActive();
        if (!txActive) {
            this.em.getTransaction().begin();
        }
        this.em.createQuery("delete from Order o where o.customer.name = 'Capricorn'").executeUpdate();
        this.em.createQuery("delete from Order o").executeUpdate();
        this.em.createQuery("delete from Customer c where c.name = 'Capricorn'").executeUpdate();
        this.em.flush();
        if (!txActive) {
            this.em.getTransaction().commit();
        }
    }
}

