/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.metamodel.Attribute;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.ComparisonStyle;
import org.apache.openjpa.persistence.criteria.Contact;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Department;
import org.apache.openjpa.persistence.criteria.Employee;
import org.apache.openjpa.persistence.criteria.Employee_;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;

public class TestQueryByExample
extends CriteriaTest {
    DBDictionary dict = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        OpenJPAEntityManagerSPI ojem = (OpenJPAEntityManagerSPI)this.em;
        this.dict = ((JDBCConfiguration)ojem.getConfiguration()).getDBDictionaryInstance();
        if (this.dict instanceof OracleDictionary) {
            this.dict.setJoinSyntax("sql92");
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.dict = null;
        super.tearDown();
    }

    public void testBasicFieldsWithNonDefaultValue() {
        String jpql = "SELECT e FROM Employee e WHERE e.rating=1 AND e.salary=1100";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Employee example = new Employee();
        example.setSalary(1100L);
        example.setRating(1);
        ComparisonStyle style = null;
        Attribute[] excludes = null;
        q.where((Expression)this.cb.qbe((From)q.from(Employee.class), (Object)example, style, excludes));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExcludeBasicFieldWithNonDefaultValue() {
        String jpql = "SELECT e FROM Employee e WHERE e.salary=1100";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Employee example = new Employee();
        example.setSalary(1100L);
        example.setRating(1);
        ComparisonStyle style = null;
        Attribute[] excludes = new Attribute[]{Employee_.rating};
        q.where((Expression)this.cb.qbe((From)q.from(Employee.class), (Object)example, style, excludes));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testBasicFieldWithDefaultValueExcludedByDefaultStyle() {
        String jpql = "SELECT e FROM Employee e WHERE e.rating=1";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Employee example = new Employee();
        example.setRating(1);
        ComparisonStyle style = null;
        Attribute[] excludes = null;
        q.where((Expression)this.cb.qbe((From)q.from(Employee.class), (Object)example, style, excludes));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, "WHERE (t0.rating = ?)");
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testBasicFieldWithDefaultValueCanBeIncludedByStyle() {
        String jpql = "SELECT e FROM Employee e WHERE e.rating=1 AND e.salary=1100";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Employee example = new Employee();
        example.setRating(1);
        ComparisonStyle style = this.cb.qbeStyle();
        Attribute[] excludes = null;
        q.where((Expression)this.cb.qbe((From)q.from(Employee.class), (Object)example, style.setExcludeDefault(false), excludes));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, "WHERE (t0.rating = ? AND t0.salary = ?)");
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testRelationFieldWithNonDefaultValue() {
        String jpql = "SELECT e FROM Employee e WHERE e.rating=1 AND e.salary=1100 AND e.department.name='ExampleDept'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Employee example = new Employee();
        example.setSalary(1100L);
        example.setRating(1);
        Department dept = new Department();
        dept.setName("ExampleDept");
        example.setDepartment(dept);
        ComparisonStyle style = this.cb.qbeStyle();
        Attribute[] excludes = null;
        q.where((Expression)this.cb.qbe((From)q.from(Employee.class), (Object)example, style, excludes));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, "WHERE (t1.name = ? AND t0.rating = ? AND t0.salary = ?)");
    }

    public void testRelationFieldWithNullValueIncluded() {
        String jpql = "SELECT e FROM Employee e WHERE e.rating=1 AND e.salary=1100 AND e.department IS NULL";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Employee example = new Employee();
        example.setName("ExampleEmployee");
        example.setSalary(1100L);
        example.setRating(1);
        example.setDepartment(null);
        ComparisonStyle style = this.cb.qbeStyle();
        Attribute[] excludes = new Attribute[]{Employee_.frequentFlierPlan, Employee_.manager, Employee_.spouse};
        q.where((Expression)this.cb.qbe((From)q.from(Employee.class), (Object)example, style.setExcludeNull(false).setExcludeDefault(false), excludes));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, "WHERE (1 <> 1 AND t0.DEPARTMENT_DEPTNO IS NULL AND t0.name = ? AND t0.rating = ? AND t0.salary = ?)");
    }

    public void testEmbeddedField() {
        String jpql = "SELECT e FROM Employee e WHERE e.rating=1 AND e.salary=1100 AND e.department IS NULL";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Employee example = new Employee();
        example.setName("ExampleEmployee");
        example.setSalary(1100L);
        example.setRating(1);
        Contact contact = new Contact();
        Address address = new Address();
        address.setCity("Plano");
        address.setState("TX");
        address.setCountry("USA");
        contact.setAddress(address);
        example.setContactInfo(contact);
        ComparisonStyle style = this.cb.qbeStyle();
        Attribute[] excludes = new Attribute[]{Employee_.department, Employee_.frequentFlierPlan, Employee_.manager, Employee_.spouse};
        q.where((Expression)this.cb.qbe((From)q.from(Employee.class), (Object)example, style, excludes));
        this.executeAndCompareSQL((CriteriaQuery<?>)q, "WHERE (t1.city = ? AND t1.country = ? AND t1.state = ? AND t0.name = ? AND t0.rating = ? AND t0.salary = ?)");
    }

    @Override
    void executeAndCompareSQL(CriteriaQuery<?> q, String expected) {
        auditor.clear();
        this.em.createQuery(q).getResultList();
        TestQueryByExample.assertEquals((int)1, (int)auditor.getSQLs().size());
        String actual = this.extract("WHERE", auditor.getSQLs().get(0));
        if (this.dict instanceof DB2Dictionary) {
            return;
        }
        TestQueryByExample.assertEquals((String)expected, (String)actual);
    }

    String extract(String key, String s) {
        int index = s.indexOf(key);
        return index == -1 ? "" : s.substring(index);
    }
}

