/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Employee;
import org.apache.openjpa.persistence.criteria.Employee_;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;

public class TestFetchJoin
extends CriteriaTest {
    public void testFetchJoin() {
        String jpql = "SELECT e FROM Employee e INNER JOIN FETCH e.department";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root e = q.from(Employee.class);
        q.select((Selection)e);
        e.fetch(Employee_.department);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestFetchJoin.assertEquals((String)jpql, (String)q.toCQL());
    }

    public void testLeftFetchJoin() {
        String jpql = "SELECT e FROM Employee e LEFT JOIN FETCH e.department";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root e = q.from(Employee.class);
        q.select((Selection)e);
        e.fetch(Employee_.department, JoinType.LEFT);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestFetchJoin.assertEquals((String)jpql, (String)q.toCQL());
    }
}

