/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.EmbeddableDomainTestCase;
import org.apache.openjpa.persistence.embed.Company1;
import org.apache.openjpa.persistence.embed.Company1_;
import org.apache.openjpa.persistence.embed.Company2;
import org.apache.openjpa.persistence.embed.Company2_;
import org.apache.openjpa.persistence.embed.Department1;
import org.apache.openjpa.persistence.embed.Department1_;
import org.apache.openjpa.persistence.embed.Department2;
import org.apache.openjpa.persistence.embed.Department3;
import org.apache.openjpa.persistence.embed.Division;
import org.apache.openjpa.persistence.embed.Embed;
import org.apache.openjpa.persistence.embed.Embed_;
import org.apache.openjpa.persistence.embed.Embed_Coll_Embed_;
import org.apache.openjpa.persistence.embed.Embed_Coll_Integer_;
import org.apache.openjpa.persistence.embed.Embed_Embed;
import org.apache.openjpa.persistence.embed.Embed_Embed_;
import org.apache.openjpa.persistence.embed.Embed_Embed_ToMany;
import org.apache.openjpa.persistence.embed.Embed_Embed_ToMany_;
import org.apache.openjpa.persistence.embed.Embed_MappedToOne;
import org.apache.openjpa.persistence.embed.Embed_MappedToOne_;
import org.apache.openjpa.persistence.embed.Embed_ToMany;
import org.apache.openjpa.persistence.embed.Embed_ToMany_;
import org.apache.openjpa.persistence.embed.Embed_ToOne;
import org.apache.openjpa.persistence.embed.Embed_ToOne_;
import org.apache.openjpa.persistence.embed.Employee1;
import org.apache.openjpa.persistence.embed.Employee2;
import org.apache.openjpa.persistence.embed.Employee3;
import org.apache.openjpa.persistence.embed.EntityA_Coll_Embed_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Coll_Embed_Embed_;
import org.apache.openjpa.persistence.embed.EntityA_Coll_Embed_ToOne;
import org.apache.openjpa.persistence.embed.EntityA_Coll_Embed_ToOne_;
import org.apache.openjpa.persistence.embed.EntityA_Coll_String;
import org.apache.openjpa.persistence.embed.EntityA_Coll_String_;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Coll_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Coll_Embed_;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Coll_Integer;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Coll_Integer_;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Embed_;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Embed_ToMany;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Embed_ToMany_;
import org.apache.openjpa.persistence.embed.EntityA_Embed_MappedToOne;
import org.apache.openjpa.persistence.embed.EntityA_Embed_MappedToOne_;
import org.apache.openjpa.persistence.embed.EntityA_Embed_ToMany;
import org.apache.openjpa.persistence.embed.EntityA_Embed_ToMany_;
import org.apache.openjpa.persistence.embed.EntityA_Embed_ToOne;
import org.apache.openjpa.persistence.embed.EntityA_Embed_ToOne_;
import org.apache.openjpa.persistence.embed.EntityB1;
import org.apache.openjpa.persistence.embed.EntityB1_;
import org.apache.openjpa.persistence.embed.Item1;
import org.apache.openjpa.persistence.embed.Item1_;
import org.apache.openjpa.persistence.embed.Item2;
import org.apache.openjpa.persistence.embed.Item2_;
import org.apache.openjpa.persistence.embed.Item3;
import org.apache.openjpa.persistence.embed.Item3_;
import org.apache.openjpa.persistence.embed.VicePresident;
import org.apache.openjpa.persistence.embed.VicePresident_;
import org.apache.openjpa.persistence.test.AllowFailure;

public class TestEmbeddableCriteria
extends EmbeddableDomainTestCase {
    private static int TEST_COUNT = 0;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ++TEST_COUNT;
    }

    @Override
    public void tearDown() throws Exception {
        if (TEST_COUNT >= 123) {
            super.tearDown();
        }
    }

    public void testEmbeddableQuery1() {
        String jpql = "select e from EntityA_Coll_String a, in (a.nickNames) e order by a.id";
        CriteriaQuery q = this.cb.createQuery(String.class);
        Root a = q.from(EntityA_Coll_String.class);
        SetJoin e = a.join(EntityA_Coll_String_.nickNames);
        q.select((Selection)e);
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Coll_String_.id))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery3() {
        String jpql = "select e from EntityA_Coll_String a, in (a.nickNames) e order by e";
        CriteriaQuery q = this.cb.createQuery(String.class);
        Root a = q.from(EntityA_Coll_String.class);
        SetJoin e = a.join(EntityA_Coll_String_.nickNames);
        q.select((Selection)e);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery4() {
        String jpql = "select a from EntityA_Coll_String a WHERE a.nickNames IS EMPTY order by a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Coll_String.class);
        Root a = q.from(EntityA_Coll_String.class);
        q.select((Selection)a);
        q.where((Expression)this.cb.isEmpty(a.get(EntityA_Coll_String_.nickNames)));
        q.orderBy(new Order[]{this.cb.asc((Expression)a)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery5() {
        String jpql = "select a from EntityA_Coll_String a WHERE exists (select n from EntityA_Coll_String a,  in (a.nickNames) n where n like '%1') order by a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Coll_String.class);
        Root a = q.from(EntityA_Coll_String.class);
        q.select((Selection)a);
        Subquery sq = q.subquery(Set.class);
        Root a1 = sq.from(EntityA_Coll_String.class);
        Expression n = a1.get(EntityA_Coll_String_.nickNames);
        n.alias("n");
        sq.where((Expression)this.cb.like(n, "%1"));
        sq.select(n);
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)a)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery6() {
        String jpql = "select a from EntityA_Coll_String a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Coll_String.class);
        Root a = q.from(EntityA_Coll_String.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery7() {
        String jpql = "select a.embed from EntityA_Embed_ToOne a ";
        CriteriaQuery q = this.cb.createQuery(Embed_ToOne.class);
        Root a = q.from(EntityA_Embed_ToOne.class);
        q.select((Selection)a.get(EntityA_Embed_ToOne_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery9() {
        String jpql = "select e from EntityA_Embed_ToOne a  join a.embed e join e.b b where e.b.id > 0 order by a.id";
        CriteriaQuery q = this.cb.createQuery(Embed_ToOne.class);
        Root a = q.from(EntityA_Embed_ToOne.class);
        Join e = a.join(EntityA_Embed_ToOne_.embed);
        Join b = e.join(Embed_ToOne_.b);
        q.where((Expression)this.cb.gt((Expression)b.get(EntityB1_.id), (Number)0));
        q.select((Selection)e);
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_ToOne_.id))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery11() {
        String jpql = "select a.embed from EntityA_Embed_ToOne a ORDER BY a.embed";
        CriteriaQuery q = this.cb.createQuery(Embed_ToOne.class);
        Root a = q.from(EntityA_Embed_ToOne.class);
        q.select((Selection)a.get(EntityA_Embed_ToOne_.embed));
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_ToOne_.embed))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery12() {
        String jpql = "select a.embed from EntityA_Embed_ToOne a WHERE a.embed.b IS NOT NULL  ORDER BY a.embed";
        CriteriaQuery q = this.cb.createQuery(Embed_ToOne.class);
        Root a = q.from(EntityA_Embed_ToOne.class);
        q.select((Selection)a.get(EntityA_Embed_ToOne_.embed));
        q.where((Expression)this.cb.isNotNull((Expression)a.get(EntityA_Embed_ToOne_.embed).get(Embed_ToOne_.b)));
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_ToOne_.embed))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery13() {
        String jpql = "select a.embed from EntityA_Embed_ToOne a WHERE exists  (select a from EntityA_Embed_ToOne a where a.embed.b IS NOT NULL)  ORDER BY a.embed";
        CriteriaQuery q = this.cb.createQuery(Embed_ToOne.class);
        Root a = q.from(EntityA_Embed_ToOne.class);
        q.select((Selection)a.get(EntityA_Embed_ToOne_.embed));
        Subquery sq = q.subquery(EntityA_Embed_ToOne.class);
        Root a1 = sq.from(EntityA_Embed_ToOne.class);
        Path n = a1.get(EntityA_Embed_ToOne_.embed).get(Embed_ToOne_.b);
        sq.where((Expression)this.cb.isNotNull((Expression)n));
        sq.select((Expression)a1);
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_ToOne_.embed))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery14() {
        String jpql = "select a.embed from EntityA_Embed_MappedToOne a ";
        CriteriaQuery q = this.cb.createQuery(Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        q.select((Selection)a.get(EntityA_Embed_MappedToOne_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery15() {
        String jpql = "select e from EntityA_Embed_MappedToOne a  join a.embed e join e.bm bm where e.bm.id > 0 order by a.id";
        CriteriaQuery q = this.cb.createQuery(Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        Join e = a.join(EntityA_Embed_MappedToOne_.embed);
        Join bm = e.join(Embed_MappedToOne_.bm);
        q.where((Expression)this.cb.gt((Expression)e.get(Embed_MappedToOne_.bm).get(EntityB1_.id), (Number)0));
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_MappedToOne_.id))});
        q.select((Selection)e);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery16() {
        String jpql = "select a.embed as e from EntityA_Embed_MappedToOne a ORDER BY e";
        CriteriaQuery q = this.cb.createQuery(Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        Path e = a.get(EntityA_Embed_MappedToOne_.embed);
        e.alias("e");
        q.select((Selection)e);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery17() {
        String jpql = "select a.embed from EntityA_Embed_MappedToOne a WHERE a.embed.bm IS NOT NULL";
        CriteriaQuery q = this.cb.createQuery(Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        q.where((Expression)this.cb.isNotNull((Expression)a.get(EntityA_Embed_MappedToOne_.embed).get(Embed_MappedToOne_.bm)));
        q.select((Selection)a.get(EntityA_Embed_MappedToOne_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery18() {
        String jpql = "select a.embed from EntityA_Embed_MappedToOne a  WHERE exists (select a from EntityA_Embed_MappedToOne a  where a.embed.bm IS NOT NULL)";
        CriteriaQuery q = this.cb.createQuery(Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        Subquery sq = q.subquery(EntityA_Embed_MappedToOne.class);
        Root a1 = sq.from(EntityA_Embed_MappedToOne.class);
        sq.select((Expression)a1);
        sq.where((Expression)this.cb.isNotNull((Expression)a1.get(EntityA_Embed_MappedToOne_.embed).get(Embed_MappedToOne_.bm)));
        q.where((Expression)this.cb.exists(sq));
        q.select((Selection)a.get(EntityA_Embed_MappedToOne_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery19() {
        String jpql = "select a.embed from EntityA_Embed_MappedToOne a  WHERE exists (select e from EntityA_Embed_MappedToOne a join a.embed e where e.bm IS NOT NULL)";
        CriteriaQuery q = this.cb.createQuery(Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        Subquery sq = q.subquery(Embed_MappedToOne.class);
        Root a1 = sq.from(EntityA_Embed_MappedToOne.class);
        Join e = a1.join(EntityA_Embed_MappedToOne_.embed);
        sq.select((Expression)e);
        sq.where((Expression)this.cb.isNotNull((Expression)e.get(Embed_MappedToOne_.bm)));
        q.where((Expression)this.cb.exists(sq));
        q.select((Selection)a.get(EntityA_Embed_MappedToOne_.embed));
        this.executeExpectFail(jpql);
        this.executeExpectFail(q, jpql);
    }

    public void testEmbeddableQuery20() {
        String jpql = "select a.embed from EntityA_Embed_MappedToOne a  WHERE exists (select a.embed from EntityA_Embed_MappedToOne a  where a.embed.bm IS NOT NULL)";
        CriteriaQuery q = this.cb.createQuery(Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        Subquery sq = q.subquery(Embed_MappedToOne.class);
        Root a1 = sq.from(EntityA_Embed_MappedToOne.class);
        sq.select((Expression)a1.get(EntityA_Embed_MappedToOne_.embed));
        sq.where((Expression)this.cb.isNotNull((Expression)a1.get(EntityA_Embed_MappedToOne_.embed).get(Embed_MappedToOne_.bm)));
        q.where((Expression)this.cb.exists(sq));
        q.select((Selection)a.get(EntityA_Embed_MappedToOne_.embed));
        this.executeExpectFail(q, jpql);
        this.executeExpectFail(jpql);
    }

    public void testEmbeddableQuery21() {
        String jpql = "select a from EntityA_Embed_MappedToOne a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_MappedToOne.class);
        Root a = q.from(EntityA_Embed_MappedToOne.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery22() {
        String jpql = "select e, e.b from EntityA_Coll_Embed_ToOne a, in (a.embed1s) e order by e.name1";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_ToOne.class);
        SetJoin e = a.join(EntityA_Coll_Embed_ToOne_.embed1s);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_ToOne_.name1))});
        q.multiselect(new Selection[]{e, e.get(Embed_ToOne_.b)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery23() {
        String jpql = "select e, a.id from EntityA_Coll_Embed_ToOne a, in (a.embed1s) e where e.b.id > 0 order by a.id";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_ToOne.class);
        SetJoin e = a.join(EntityA_Coll_Embed_ToOne_.embed1s);
        q.where((Expression)this.cb.gt((Expression)e.get(Embed_ToOne_.b).get(EntityB1_.id), (Number)0));
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Coll_Embed_ToOne_.id))});
        q.multiselect(new Selection[]{e, a.get(EntityA_Coll_Embed_ToOne_.id)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery24() {
        String jpql = "select e, e.b.id from EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e where e.name1 like '%1' order by e.name3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_ToOne.class);
        SetJoin e = a.join(EntityA_Coll_Embed_ToOne_.embed1s);
        q.where((Expression)this.cb.like((Expression)e.get(Embed_ToOne_.name1), "%1"));
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_ToOne_.name3))});
        q.multiselect(new Selection[]{e, e.get(Embed_ToOne_.b).get(EntityB1_.id)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery25() {
        String jpql = "select e, e.b.id  from EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e where e.name1 like '%1' order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_ToOne.class);
        SetJoin e = a.join(EntityA_Coll_Embed_ToOne_.embed1s);
        q.where((Expression)this.cb.like((Expression)e.get(Embed_ToOne_.name1), "%1"));
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, e.get(Embed_ToOne_.b).get(EntityB1_.id)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery26() {
        String jpql = "select e, e.b.id  from EntityA_Coll_Embed_ToOne a, in (a.embed1s) e where e.name1 like '%1' and a.embed1s IS NOT EMPTY and  e.b IS NOT NULL order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_ToOne.class);
        SetJoin e = a.join(EntityA_Coll_Embed_ToOne_.embed1s);
        Predicate p1 = this.cb.like((Expression)e.get(Embed_ToOne_.name1), "%1");
        Predicate p2 = this.cb.isEmpty(a.get(EntityA_Coll_Embed_ToOne_.embed1s)).not();
        Predicate p3 = this.cb.isNotNull((Expression)e.get(Embed_ToOne_.b));
        q.where((Expression)this.cb.and((Expression)this.cb.and((Expression)p1, (Expression)p2), (Expression)p3));
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, e.get(Embed_ToOne_.b).get(EntityB1_.id)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery27() {
        String jpql = "select e, e.b.id from EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e where exists (select a.embed1s from  EntityA_Coll_Embed_ToOne a) and exists (select e.b from a.embed1s e)  order by e";
        CriteriaQuery q = this.cb.createQuery(Integer.class);
        Root a = q.from(EntityA_Coll_Embed_ToOne.class);
        SetJoin e = a.join(EntityA_Coll_Embed_ToOne_.embed1s);
        Subquery sq1 = q.subquery(Set.class);
        Root a1 = sq1.from(EntityA_Coll_Embed_ToOne.class);
        Expression e1 = a1.get(EntityA_Coll_Embed_ToOne_.embed1s);
        sq1.select(e1);
        Subquery sq2 = q.subquery(EntityB1.class);
        Root a2 = sq2.correlate(a);
        SetJoin e2 = a2.join(EntityA_Coll_Embed_ToOne_.embed1s);
        sq2.select((Expression)e2.get(Embed_ToOne_.b));
        Predicate p1 = this.cb.exists(sq1);
        Predicate p2 = this.cb.exists(sq2);
        q.where((Expression)this.cb.and((Expression)p1, (Expression)p2));
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, e.get(Embed_ToOne_.b).get(EntityB1_.id)});
        this.executeExpectFail(q, jpql);
        this.executeExpectFail(jpql);
    }

    public void testEmbeddableQuery28() {
        String jpql = "select a.embed from EntityA_Embed_ToMany a";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        q.select((Selection)a.get(EntityA_Embed_ToMany_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery29() {
        String jpql = "select e from EntityA_Embed_ToMany a join a.embed e";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        Join e = a.join(EntityA_Embed_ToMany_.embed);
        q.select((Selection)e);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery30() {
        String jpql = "select b from EntityA_Embed_ToMany a join a.embed.bs b";
        CriteriaQuery q = this.cb.createQuery(EntityB1.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        ListJoin b = a.join(EntityA_Embed_ToMany_.embed).join(Embed_ToMany_.bs);
        q.select((Selection)b);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery31() {
        String jpql = "select e from EntityA_Embed_ToMany a join a.embed e where e.name1 like '%1'";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        Join e = a.join(EntityA_Embed_ToMany_.embed);
        q.select((Selection)e);
        q.where((Expression)this.cb.like((Expression)e.get(Embed_ToMany_.name1), "%1"));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery32() {
        String jpql = "select a.embed from EntityA_Embed_ToMany a ORDER BY a.embed";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        q.select((Selection)a.get(EntityA_Embed_ToMany_.embed));
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_ToMany_.embed))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery33() {
        String jpql = "select e from EntityA_Embed_ToMany a join a.embed e ORDER BY e";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        Join e = a.join(EntityA_Embed_ToMany_.embed);
        e.alias("e");
        q.select((Selection)e);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery34() {
        String jpql = "select b from EntityA_Embed_ToMany a join a.embed.bs b ORDER BY b";
        CriteriaQuery q = this.cb.createQuery(EntityB1.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        ListJoin b = a.join(EntityA_Embed_ToMany_.embed).join(Embed_ToMany_.bs);
        b.alias("b");
        q.select((Selection)b);
        q.orderBy(new Order[]{this.cb.asc((Expression)b)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery35() {
        String jpql = "select e from EntityA_Embed_ToMany a join a.embed e WHERE e.bs IS NOT EMPTY ORDER BY e";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        Join e = a.join(EntityA_Embed_ToMany_.embed);
        e.alias("e");
        q.select((Selection)e);
        q.where((Expression)this.cb.isEmpty(e.get(Embed_ToMany_.bs)).not());
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery36() {
        String jpql = "select a from EntityA_Embed_ToMany a WHERE exists (select a from EntityA_Embed_ToMany a where a.embed.bs IS NOT EMPTY) ORDER BY a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        q.select((Selection)a);
        Subquery sq = q.subquery(EntityA_Embed_ToMany.class);
        Root a1 = sq.from(EntityA_Embed_ToMany.class);
        sq.select((Expression)a1);
        sq.where((Expression)this.cb.isEmpty(a1.get(EntityA_Embed_ToMany_.embed).get(Embed_ToMany_.bs)).not());
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)a)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery38() {
        String jpql = "select a from EntityA_Embed_ToMany a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_ToMany.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery39() {
        String jpql = "select a.embed from EntityA_Embed_Embed_ToMany a";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_ToMany_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery40() {
        String jpql = "select a.embed from EntityA_Embed_Embed_ToMany a where a.embed.embed.name1 like '%1' ";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_ToMany_.embed));
        q.where((Expression)this.cb.like((Expression)a.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed).get(Embed_ToMany_.name1), "%1"));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery41() {
        String jpql = "select a.embed.embed from EntityA_Embed_Embed_ToMany a";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery42() {
        String jpql = "select b from EntityA_Embed_Embed_ToMany a join a.embed.embed.bs b";
        CriteriaQuery q = this.cb.createQuery(EntityB1.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        ListJoin b = a.join(EntityA_Embed_Embed_ToMany_.embed).join(Embed_Embed_ToMany_.embed).join(Embed_ToMany_.bs);
        b.alias("b");
        q.select((Selection)b);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery43() {
        String jpql = "select a.embed.embed from EntityA_Embed_Embed_ToMany a where a.embed.embed.name1 like '%1'";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed));
        q.where((Expression)this.cb.like((Expression)a.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed).get(Embed_ToMany_.name1), "%1"));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery44() {
        String jpql = "select e2 from EntityA_Embed_Embed_ToMany a left join a.embed e1 left join e1.embed e2";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        Join e1 = a.join(EntityA_Embed_Embed_ToMany_.embed, JoinType.LEFT);
        Join e2 = e1.join(Embed_Embed_ToMany_.embed, JoinType.LEFT);
        q.select((Selection)e2);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery45() {
        String jpql = "select e2 from EntityA_Embed_Embed_ToMany a join a.embed e1 join e1.embed e2";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        Join e1 = a.join(EntityA_Embed_Embed_ToMany_.embed);
        Join e2 = e1.join(Embed_Embed_ToMany_.embed);
        q.select((Selection)e2);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery46() {
        String jpql = "select a.embed as e from EntityA_Embed_Embed_ToMany a ORDER BY e";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        Path e = a.get(EntityA_Embed_Embed_ToMany_.embed);
        e.alias("e");
        q.select((Selection)e);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery47() {
        String jpql = "select a.embed.embed as e from EntityA_Embed_Embed_ToMany a where a.embed.embed.name1 like '%1' ORDER BY e";
        CriteriaQuery q = this.cb.createQuery(Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        Path e = a.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed);
        e.alias("e");
        q.select((Selection)e);
        q.where((Expression)this.cb.like((Expression)a.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed).get(Embed_ToMany_.name1), "%1"));
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery48() {
        String jpql = "select a.embed from EntityA_Embed_Embed_ToMany a  where a.embed.embed.bs IS NOT EMPTY";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        Path e = a.get(EntityA_Embed_Embed_ToMany_.embed);
        q.select((Selection)e);
        q.where((Expression)this.cb.isEmpty(a.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed).get(Embed_ToMany_.bs)).not());
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery49() {
        String jpql = "select a.embed from EntityA_Embed_Embed_ToMany a  where exists (select a.embed.embed.bs from EntityA_Embed_Embed_ToMany a)";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        Path e = a.get(EntityA_Embed_Embed_ToMany_.embed);
        q.select((Selection)e);
        Subquery sq = q.subquery(List.class);
        Root a1 = sq.from(EntityA_Embed_Embed_ToMany.class);
        Expression bs = a1.get(EntityA_Embed_Embed_ToMany_.embed).get(Embed_Embed_ToMany_.embed).get(Embed_ToMany_.bs);
        sq.select(bs);
        q.where((Expression)this.cb.exists(sq));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery50() {
        String jpql = "select b from EntityA_Embed_Embed_ToMany a join a.embed.embed.bs b";
        CriteriaQuery q = this.cb.createQuery(EntityB1.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        ListJoin b = a.join(EntityA_Embed_Embed_ToMany_.embed).join(Embed_Embed_ToMany_.embed).join(Embed_ToMany_.bs);
        b.alias("b");
        q.select((Selection)b);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery51() {
        String jpql = "select a from EntityA_Embed_Embed_ToMany a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_Embed_ToMany.class);
        Root a = q.from(EntityA_Embed_Embed_ToMany.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery52() {
        String jpql = "select e, a.id from EntityA_Embed_Coll_Integer a, in (a.embed.otherIntVals) e order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Integer.class);
        SetJoin e = a.join(EntityA_Embed_Coll_Integer_.embed).join(Embed_Coll_Integer_.otherIntVals);
        e.alias("e");
        q.multiselect(new Selection[]{e, a.get(EntityA_Embed_Coll_Integer_.id)});
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery54() {
        String jpql = "select e, a.id from EntityA_Embed_Coll_Integer a, in (a.embed.otherIntVals) e order by a.id";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Integer.class);
        SetJoin e = a.join(EntityA_Embed_Coll_Integer_.embed).join(Embed_Coll_Integer_.otherIntVals);
        e.alias("e");
        q.multiselect(new Selection[]{e, a.get(EntityA_Embed_Coll_Integer_.id)});
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_Coll_Integer_.id))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery55() {
        String jpql = "select e, a.embed.intVal1 from EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e order by a.id";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Integer.class);
        SetJoin e = a.join(EntityA_Embed_Coll_Integer_.embed).join(Embed_Coll_Integer_.otherIntVals);
        e.alias("e");
        q.multiselect(new Selection[]{e, a.get(EntityA_Embed_Coll_Integer_.embed).get(Embed_Coll_Integer_.intVal1)});
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_Coll_Integer_.id))});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery56() {
        String jpql = "select e, a.embed.intVal2 from EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Integer.class);
        SetJoin e = a.join(EntityA_Embed_Coll_Integer_.embed).join(Embed_Coll_Integer_.otherIntVals);
        e.alias("e");
        q.multiselect(new Selection[]{e, a.get(EntityA_Embed_Coll_Integer_.embed).get(Embed_Coll_Integer_.intVal2)});
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery57() {
        String jpql1 = "select e, a.embed.intVal2 from EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e WHERE a.embed.otherIntVals IS NOT EMPTY order by e";
        String jpql = "select e1, a.embed.intVal2 from EntityA_Embed_Coll_Integer a JOIN a.embed e JOIN e.otherIntVals e1 WHERE a.embed.otherIntVals IS NOT EMPTY order by e1";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Integer.class);
        SetJoin e = a.join(EntityA_Embed_Coll_Integer_.embed).join(Embed_Coll_Integer_.otherIntVals);
        e.alias("e");
        q.multiselect(new Selection[]{e, a.get(EntityA_Embed_Coll_Integer_.embed).get(Embed_Coll_Integer_.intVal2)});
        q.where((Expression)this.cb.isEmpty(a.get(EntityA_Embed_Coll_Integer_.embed).get(Embed_Coll_Integer_.otherIntVals)).not());
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery58() {
        String jpql = "select e, a0.intVal2 from EntityA_Embed_Coll_Integer a JOIN a.embed a0 JOIN a0.otherIntVals e WHERE exists (select a from  EntityA_Embed_Coll_Integer a JOIN a.embed a0 JOIN a0.otherIntVals e  where e > 0) order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Integer.class);
        SetJoin e = a.join(EntityA_Embed_Coll_Integer_.embed).join(Embed_Coll_Integer_.otherIntVals);
        e.alias("e");
        q.multiselect(new Selection[]{e, a.get(EntityA_Embed_Coll_Integer_.embed).get(Embed_Coll_Integer_.intVal2)});
        Subquery sq = q.subquery(EntityA_Embed_Coll_Integer.class);
        Root a1 = sq.from(EntityA_Embed_Coll_Integer.class);
        SetJoin e1 = a1.join(EntityA_Embed_Coll_Integer_.embed).join(Embed_Coll_Integer_.otherIntVals);
        sq.where((Expression)this.cb.gt((Expression)e1, (Number)0));
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery59() {
        String jpql = "select a from EntityA_Embed_Coll_Integer a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_Coll_Integer.class);
        Root a = q.from(EntityA_Embed_Coll_Integer.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery60() {
        String jpql = "select a.embed from EntityA_Embed_Embed a";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed.class);
        Root a = q.from(EntityA_Embed_Embed.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery61() {
        String jpql = "select a.embed.embed from EntityA_Embed_Embed a";
        CriteriaQuery q = this.cb.createQuery(Embed.class);
        Root a = q.from(EntityA_Embed_Embed.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_.embed).get(Embed_Embed_.embed));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery62() {
        String jpql = "select a.embed as e from EntityA_Embed_Embed a ORDER BY e";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed.class);
        Root a = q.from(EntityA_Embed_Embed.class);
        Path e = a.get(EntityA_Embed_Embed_.embed);
        e.alias("e");
        q.select((Selection)e);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        this.assertEquivalence(q, jpql);
    }

    @AllowFailure(message="")
    public void testEmbeddableQuery63() {
        String jpql = "select a.embed from EntityA_Embed_Embed a WHERE a.embed.embed IS NOT NULL";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed.class);
        Root a = q.from(EntityA_Embed_Embed.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_.embed));
        q.where((Expression)this.cb.isNotNull((Expression)a.get(EntityA_Embed_Embed_.embed).get(Embed_Embed_.embed)));
        this.executeExpectFail(q, jpql);
        this.executeExpectFail(jpql);
    }

    public void testEmbeddableQuery64() {
        String jpql = "select a.embed from EntityA_Embed_Embed a WHERE exists  (select a.embed.embed from EntityA_Embed_Embed a where a.embed IS NOT NULL) ";
        CriteriaQuery q = this.cb.createQuery(Embed_Embed.class);
        Root a = q.from(EntityA_Embed_Embed.class);
        q.select((Selection)a.get(EntityA_Embed_Embed_.embed));
        Subquery sq = q.subquery(Embed.class);
        Root a1 = sq.from(EntityA_Embed_Embed.class);
        sq.where((Expression)this.cb.isNotNull((Expression)a1.get(EntityA_Embed_Embed_.embed)));
        sq.select((Expression)a1.get(EntityA_Embed_Embed_.embed).get(Embed_Embed_.embed));
        q.where((Expression)this.cb.exists(sq));
        this.executeExpectFail(q, jpql);
        this.executeExpectFail(jpql);
    }

    public void testEmbeddableQuery65() {
        String jpql = "select a from EntityA_Embed_Embed a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_Embed.class);
        Root a = q.from(EntityA_Embed_Embed.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery66() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal2), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery68() {
        String jpql = "select e, a.id from EntityA_Coll_Embed_Embed a, in (a.embeds) e order by a.id";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Coll_Embed_Embed_.id))});
        q.multiselect(new Selection[]{e, a.get(EntityA_Coll_Embed_Embed_.id)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery69() {
        String jpql = "select e, a.id from EntityA_Coll_Embed_Embed a, in (a.embeds) e order by e desc";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        e.alias("e");
        q.orderBy(new Order[]{this.cb.desc((Expression)e)});
        q.multiselect(new Selection[]{e, a.get(EntityA_Coll_Embed_Embed_.id)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery70() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e WHERE a.embeds IS NOT EMPTY  order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        q.where((Expression)this.cb.isEmpty(a.get(EntityA_Coll_Embed_Embed_.embeds)).not());
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery71() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e WHERE exists (select a.embeds  from EntityA_Coll_Embed_Embed a) order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(List.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        Expression e2 = a1.get(EntityA_Coll_Embed_Embed_.embeds);
        sq.select(e2);
        q.where((Expression)this.cb.exists(sq));
        this.executeExpectFail(q, jpql);
        this.executeExpectFail(jpql);
    }

    public void testEmbeddableQuery72() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e WHERE e.intVal1 < ANY (select e2.intVal2  from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2)  order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.lt((Expression)e.get(Embed_Embed_.intVal1), this.cb.any(sq)));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery73() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e WHERE e.intVal1 < ALL (select e2.intVal2  from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2)  order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.lt((Expression)e.get(Embed_Embed_.intVal1), this.cb.all(sq)));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery74() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e WHERE e.intVal1 <= SOME  (select e2.intVal2 from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2)  order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.le((Expression)e.get(Embed_Embed_.intVal1), this.cb.some(sq)));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery75() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e WHERE e.intVal1 > ALL (select e2.intVal2  from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2) order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.gt((Expression)e.get(Embed_Embed_.intVal1), this.cb.all(sq)));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery76() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ANY (select e.intVal2  from EntityA_Coll_Embed_Embed a, in (a.embeds) e) order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 < ANY (SELECT t3.intVal2 FROM TBL1A t2 INNER JOIN TBL1A_embeds t3 ON t2.id = t3.ENTITYA_COLL_EMBED_EMBED_ID)) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.lt((Expression)e.get(Embed_Embed_.intVal1), this.cb.any(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    public void testEmbeddableQuery77() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ALL (select e.intVal2  from EntityA_Coll_Embed_Embed a, in (a.embeds) e) order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 < ALL (SELECT t3.intVal2 FROM TBL1A t2 INNER JOIN TBL1A_embeds t3 ON t2.id = t3.ENTITYA_COLL_EMBED_EMBED_ID)) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.lt((Expression)e.get(Embed_Embed_.intVal1), this.cb.all(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    public void testEmbeddableQuery78() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a, in (a.embeds) e WHERE e.intVal1 <= SOME  (select e.intVal2 from EntityA_Coll_Embed_Embed a, in (a.embeds) e)  order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 <= ANY (SELECT t3.intVal2 FROM TBL1A t2 INNER JOIN TBL1A_embeds t3 ON t2.id = t3.ENTITYA_COLL_EMBED_EMBED_ID)) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.le((Expression)e.get(Embed_Embed_.intVal1), this.cb.some(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    public void testEmbeddableQuery79() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 > ALL (select e.intVal2  from EntityA_Coll_Embed_Embed a, in (a.embeds) e) order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 > ALL (SELECT t3.intVal2 FROM TBL1A t2 INNER JOIN TBL1A_embeds t3 ON t2.id = t3.ENTITYA_COLL_EMBED_EMBED_ID)) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.gt((Expression)e.get(Embed_Embed_.intVal1), this.cb.all(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    public void testEmbeddableQuery80() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ANY (select e2.intVal2  from in(a.embeds) e2) order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 < ANY (SELECT t2.intVal2 FROM TBL1A_embeds t2 WHERE (t0.id = t2.ENTITYA_COLL_EMBED_EMBED_ID))) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.correlate(a);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.lt((Expression)e.get(Embed_Embed_.intVal1), this.cb.any(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    public void testEmbeddableQuery81() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ALL (select e2.intVal2  from a.embeds e2) order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 < ALL (SELECT t2.intVal2 FROM TBL1A_embeds t2 WHERE (t0.id = t2.ENTITYA_COLL_EMBED_EMBED_ID))) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.correlate(a);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.lt((Expression)e.get(Embed_Embed_.intVal1), this.cb.all(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    public void testEmbeddableQuery82() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 <= SOME (select e2.intVal2  from in(a.embeds) e2) order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 <= ANY (SELECT t2.intVal2 FROM TBL1A_embeds t2 WHERE (t0.id = t2.ENTITYA_COLL_EMBED_EMBED_ID))) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.correlate(a);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.le((Expression)e.get(Embed_Embed_.intVal1), this.cb.some(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    public void testEmbeddableQuery83() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 > ALL (select e2.intVal2  from a.embeds e2) order by e.intVal3";
        String expectedSQL = "SELECT t1.IntVal1x, t1.IntVal2x, t1.IntVal3x, t1.intVal1, t1.intVal2, t1.intVal3 FROM TBL1A t0 INNER JOIN TBL1A_embeds t1 ON t0.id = t1.ENTITYA_COLL_EMBED_EMBED_ID WHERE (t1.intVal1 > ALL (SELECT t2.intVal2 FROM TBL1A_embeds t2 WHERE (t0.id = t2.ENTITYA_COLL_EMBED_EMBED_ID))) ORDER BY t1.intVal3 ASC";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.correlate(a);
        ListJoin e2 = a1.join(EntityA_Coll_Embed_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_Embed_.intVal2));
        q.where((Expression)this.cb.gt((Expression)e.get(Embed_Embed_.intVal1), this.cb.all(sq)));
        this.assertEquivalence(q, jpql, expectedSQL);
    }

    @AllowFailure(message="JPQL parse error")
    public void testEmbeddableQuery84() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a,  in (a.embeds) e WHERE :embed2 MEMBER OF a.embeds order by e.intVal3";
        CriteriaQuery q = this.cb.createTupleQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        ParameterExpression param1 = this.cb.parameter(Embed_Embed.class, "embed2");
        q.where((Expression)this.cb.isMember((Expression)param1, a.get(EntityA_Coll_Embed_Embed_.embeds)));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("embed2", (Object)new Embed_Embed());
            }
        }, q, jpql);
    }

    @AllowFailure(message="JPQL parse error")
    public void testEmbeddableQuery85() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  left join a.embeds e WHERE :embed2 MEMBER OF a.embeds order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds, JoinType.LEFT);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        ParameterExpression param1 = this.cb.parameter(Embed_Embed.class, "embed2");
        q.where((Expression)this.cb.isMember((Expression)param1, a.get(EntityA_Coll_Embed_Embed_.embeds)));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("embed2", (Object)new Embed_Embed());
            }
        }, q, jpql);
    }

    @AllowFailure(message="JPQL parse error")
    public void testEmbeddableQuery86() {
        String jpql = "select e, e.intVal1, e.embed.intVal2 from EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE ?1 = e order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        ListJoin e = a.join(EntityA_Coll_Embed_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_Embed_.intVal1), e.get(Embed_Embed_.embed).get(Embed_.intVal2)});
        ParameterExpression param1 = this.cb.parameter(Embed_Embed.class);
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("embed2", (Object)new Embed_Embed());
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery87() {
        String jpql = "select a from EntityA_Coll_Embed_Embed a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Coll_Embed_Embed.class);
        Root a = q.from(EntityA_Coll_Embed_Embed.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery88() {
        String jpql = "select e, e.intVal1, e.intVal2 from EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, e.get(Embed_.intVal1), e.get(Embed_.intVal2)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery89() {
        String jpql = "select e, e.intVal1 from EntityA_Embed_Coll_Embed a, in (a.embed.embeds) e order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_.intVal1)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery90() {
        String jpql = "select e, a.id from EntityA_Embed_Coll_Embed a, in (a.embed.embeds) e order by a.id";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)a.get(EntityA_Embed_Coll_Embed_.id))});
        q.multiselect(new Selection[]{e, e.get(Embed_.intVal1), a.get(EntityA_Embed_Coll_Embed_.id)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery91() {
        String jpql = "select e, e.intVal1, e.intVal2 from EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e order by e.intVal3";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(Embed_.intVal3))});
        q.multiselect(new Selection[]{e, e.get(Embed_.intVal1), e.get(Embed_.intVal2)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery92() {
        String jpql1 = "select e, e.intVal1, e.intVal2 from EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e where a.embed.embeds IS NOT EMPTY order by e";
        String jpql = "select e1, e1.intVal1, e1.intVal2 from EntityA_Embed_Coll_Embed a JOIN a.embed e JOIN e.embeds e1 where e.embeds IS NOT EMPTY order by e1";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, e.get(Embed_.intVal1), e.get(Embed_.intVal2)});
        q.where((Expression)this.cb.isEmpty(a.get(EntityA_Embed_Coll_Embed_.embed).get(Embed_Coll_Embed_.embeds)).not());
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery93() {
        String jpql1 = "select e, e.intVal1, e.intVal2 from EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e where exists (select e.intVal1  from EntityA_Embed_Coll_Embed a, in (a.embed.embeds) e  where e.intVal2 = 105) order by e";
        String jpql = "select e, e.intVal1, e.intVal2 from EntityA_Embed_Coll_Embed a  JOIN a.embed ae JOIN ae.embeds e where exists (select e.intVal1  from EntityA_Embed_Coll_Embed a JOIN a.embed ae JOIN ae.embeds e  where e.intVal2 = 105) order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, e.get(Embed_.intVal1), e.get(Embed_.intVal2)});
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e1 = a1.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        sq.where((Expression)this.cb.equal((Expression)e1.get(Embed_.intVal2), (Object)105));
        sq.select((Expression)e1.get(Embed_.intVal1));
        q.where((Expression)this.cb.exists(sq));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery94() {
        String jpql1 = "select e, a from EntityA_Embed_Coll_Embed a, in (a.embed.embeds) e  where e.intVal1 = SOME (select e2.intVal1 from EntityA_Embed_Coll_Embed a2  , in (a2.embed.embeds) e2) order by e";
        String jpql = "select e, a1 from EntityA_Embed_Coll_Embed a1 JOIN a1.embed a0 JOIN a0.embeds e  where e.intVal1 = SOME (select e2.intVal1 from EntityA_Embed_Coll_Embed a2 JOIN a2.embed e0 JOIN e0.embeds e2) order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, a});
        Subquery sq = q.subquery(Integer.class);
        Root a2 = sq.from(EntityA_Embed_Coll_Embed.class);
        Join e0 = a2.join(EntityA_Embed_Coll_Embed_.embed);
        ListJoin e2 = e0.join(Embed_Coll_Embed_.embeds);
        sq.select((Expression)e2.get(Embed_.intVal1));
        q.where((Expression)this.cb.equal((Expression)e.get(Embed_.intVal1), this.cb.some(sq)));
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery95() {
        String jpql = "select e, a from EntityA_Embed_Coll_Embed a, in (a.embed.embeds) e  where e = :p order by e";
        CriteriaQuery q = this.cb.createQuery();
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        ListJoin e = a.join(EntityA_Embed_Coll_Embed_.embed).join(Embed_Coll_Embed_.embeds);
        q.orderBy(new Order[]{this.cb.asc((Expression)e)});
        q.multiselect(new Selection[]{e, a});
        ParameterExpression param1 = this.cb.parameter(Embed.class, "p");
        q.where((Expression)this.cb.equal((Expression)e, (Object)param1));
        this.executeExpectFail(jpql, new String[]{"p1"}, new Object[]{new Embed()});
        this.executeExpectFail(q, jpql, new String[]{"p1"}, new Object[]{new Embed()});
    }

    public void testEmbeddableQuery96() {
        String jpql = "select a from EntityA_Embed_Coll_Embed a where a.embed = :p order by a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_Coll_Embed.class);
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        q.orderBy(new Order[]{this.cb.asc((Expression)a)});
        q.select((Selection)a);
        ParameterExpression param1 = this.cb.parameter(Embed.class, "p");
        q.where((Expression)this.cb.equal((Expression)a.get(EntityA_Embed_Coll_Embed_.embed), (Object)param1));
        this.executeExpectFail(jpql, new String[]{"p1"}, new Object[]{new Embed()});
        this.executeExpectFail(q, jpql, new String[]{"p1"}, new Object[]{new Embed()});
    }

    public void testEmbeddableQuery97() {
        String jpql = "select a from EntityA_Embed_Coll_Embed a";
        CriteriaQuery q = this.cb.createQuery(EntityA_Embed_Coll_Embed.class);
        Root a = q.from(EntityA_Embed_Coll_Embed.class);
        q.select((Selection)a);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery98() {
        String jpql = "select d from Department1 d";
        CriteriaQuery q = this.cb.createQuery(Department1.class);
        Root d = q.from(Department1.class);
        q.select((Selection)d);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery99() {
        String jpql = "select d from Department2 d";
        CriteriaQuery q = this.cb.createQuery(Department2.class);
        Root d = q.from(Department2.class);
        q.select((Selection)d);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery100() {
        String jpql = "select d from Department3 d";
        CriteriaQuery q = this.cb.createQuery(Department3.class);
        Root d = q.from(Department3.class);
        q.select((Selection)d);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery101() {
        String jpql = "select d from Department1 d join d.empMap e where KEY(e) > 1 order by d";
        CriteriaQuery q = this.cb.createQuery(Department1.class);
        Root d = q.from(Department1.class);
        MapJoin empMap = d.join(Department1_.empMap);
        q.select((Selection)d);
        q.where((Expression)this.cb.gt((Expression)empMap.key(), (Number)1));
        q.orderBy(new Order[]{this.cb.asc((Expression)d)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery102() {
        String jpql = "select d from Department1 d join d.empMap e where d.deptId = KEY(e) order by d";
        CriteriaQuery q = this.cb.createQuery(Department1.class);
        Root d = q.from(Department1.class);
        MapJoin empMap = d.join(Department1_.empMap);
        q.select((Selection)d);
        q.where((Expression)this.cb.equal((Expression)d.get(Department1_.deptId), (Expression)empMap.key()));
        q.orderBy(new Order[]{this.cb.asc((Expression)d)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery103() {
        String jpql = "select d from Department1 d where d.deptId < ANY  (select KEY(e) from in(d.empMap) e) order by d";
        CriteriaQuery q = this.cb.createQuery(Department1.class);
        Root d = q.from(Department1.class);
        Subquery sq = q.subquery(Integer.class);
        Root d1 = sq.correlate(d);
        MapJoin empMap = d1.join(Department1_.empMap);
        sq.select((Expression)empMap.key());
        q.select((Selection)d);
        q.where((Expression)this.cb.lt((Expression)d.get(Department1_.deptId), this.cb.any(sq)));
        q.orderBy(new Order[]{this.cb.asc((Expression)d)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery103a() {
        String jpql = "select KEY(e) from Department1 d, in(d.empMap) e order by d";
        CriteriaQuery q = this.cb.createQuery(Integer.class);
        Root d = q.from(Department1.class);
        MapJoin empMap = d.join(Department1_.empMap);
        q.select((Selection)empMap.key());
        q.orderBy(new Order[]{this.cb.asc((Expression)d)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery103b() {
        String jpql = "select ENTRY(e) from Department1 d, in(d.empMap) e order by d";
        CriteriaQuery q = this.cb.createQuery(Map.Entry.class);
        Root d = q.from(Department1.class);
        MapJoin empMap = d.join(Department1_.empMap);
        q.select((Selection)empMap.entry());
        q.orderBy(new Order[]{this.cb.asc((Expression)d)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery104() {
        String jpql = "select d from Department1 d where d.deptId < SOME  (select KEY(e) from Department1 d1, in(d1.empMap) e) order by d";
        CriteriaQuery q = this.cb.createQuery(Department1.class);
        Root d = q.from(Department1.class);
        Subquery sq = q.subquery(Integer.class);
        Root d1 = sq.from(Department1.class);
        MapJoin empMap = d1.join(Department1_.empMap);
        sq.select((Expression)empMap.key());
        q.select((Selection)d);
        q.where((Expression)this.cb.lt((Expression)d.get(Department1_.deptId), this.cb.some(sq)));
        q.orderBy(new Order[]{this.cb.asc((Expression)d)});
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery105() {
        String jpql = "select e from Employee1 e";
        CriteriaQuery q = this.cb.createQuery(Employee1.class);
        Root e = q.from(Employee1.class);
        q.select((Selection)e);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery106() {
        String jpql = "select e from Employee2 e";
        CriteriaQuery q = this.cb.createQuery(Employee2.class);
        Root e = q.from(Employee2.class);
        q.select((Selection)e);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery107() {
        String jpql = "select e from Employee3 e";
        CriteriaQuery q = this.cb.createQuery(Employee3.class);
        Root e = q.from(Employee3.class);
        q.select((Selection)e);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery108() {
        String jpql = "select i from Item1 i";
        CriteriaQuery q = this.cb.createQuery(Item1.class);
        Root i = q.from(Item1.class);
        q.select((Selection)i);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery109() {
        String jpql = "select i from Item2 i";
        CriteriaQuery q = this.cb.createQuery(Item2.class);
        Root i = q.from(Item2.class);
        q.select((Selection)i);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery110() {
        String jpql = "select i from Item3 i";
        CriteriaQuery q = this.cb.createQuery(Item3.class);
        Root i = q.from(Item3.class);
        q.select((Selection)i);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery111() {
        String jpql = "select i from Item1 i where :image = any(select KEY(e) from i.images e) order by i";
        CriteriaQuery q = this.cb.createQuery(Item1.class);
        Root i = q.from(Item1.class);
        Subquery sq = q.subquery(String.class);
        Root i1 = sq.correlate(i);
        MapJoin e = i1.join(Item1_.images);
        sq.select((Expression)e.key());
        q.select((Selection)i);
        ParameterExpression param1 = this.cb.parameter(String.class, "image");
        q.where((Expression)this.cb.equal((Expression)param1, this.cb.any(sq)));
        q.orderBy(new Order[]{this.cb.asc((Expression)i)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("image", (Object)"my photo");
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery112() {
        String jpql = "select i from Item1 i where :image = any (select KEY(e) from Item1 i, in(i.images) e)  order by i";
        CriteriaQuery q = this.cb.createQuery(Item1.class);
        Root i = q.from(Item1.class);
        Subquery sq = q.subquery(String.class);
        Root i1 = sq.from(Item1.class);
        MapJoin e = i1.join(Item1_.images);
        sq.select((Expression)e.key());
        q.select((Selection)i);
        ParameterExpression param1 = this.cb.parameter(String.class, "image");
        q.where((Expression)this.cb.equal((Expression)param1, this.cb.any(sq)));
        q.orderBy(new Order[]{this.cb.asc((Expression)i)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("image", (Object)"my photo");
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery113() {
        String jpql = "select i from Item1 i where exists (select e from Item1 i, in(i.images) e where :image = KEY(e)) order by i";
        CriteriaQuery q = this.cb.createQuery(Item1.class);
        Root i = q.from(Item1.class);
        Subquery sq = q.subquery(String.class);
        Root i1 = sq.from(Item1.class);
        MapJoin e = i1.join(Item1_.images);
        sq.select((Expression)e);
        q.select((Selection)i);
        ParameterExpression param1 = this.cb.parameter(String.class, "image");
        sq.where((Expression)this.cb.equal((Expression)param1, (Expression)e.key()));
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)i)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("image", (Object)"my photo");
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery114() {
        String jpql = "select i from Item2 i where :image = any (select KEY(e) from Item2 i, in(i.images) e)  order by i";
        CriteriaQuery q = this.cb.createQuery(Item2.class);
        Root i = q.from(Item2.class);
        Subquery sq = q.subquery(String.class);
        Root i1 = sq.from(Item2.class);
        MapJoin e = i1.join(Item2_.images);
        sq.select((Expression)e.key());
        q.select((Selection)i);
        ParameterExpression param1 = this.cb.parameter(String.class, "image");
        q.where((Expression)this.cb.equal((Expression)param1, this.cb.any(sq)));
        q.orderBy(new Order[]{this.cb.asc((Expression)i)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("image", (Object)"my photo");
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery115() {
        String jpql = "select i from Item2 i where exists (select e from Item2 i, in(i.images) e   where :image = KEY(e)) order by i";
        CriteriaQuery q = this.cb.createQuery(Item2.class);
        Root i = q.from(Item2.class);
        Subquery sq = q.subquery(String.class);
        Root i1 = sq.from(Item2.class);
        MapJoin e = i1.join(Item2_.images);
        sq.select((Expression)e);
        q.select((Selection)i);
        ParameterExpression param1 = this.cb.parameter(String.class, "image");
        sq.where((Expression)this.cb.equal((Expression)param1, (Expression)e.key()));
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)i)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("image", (Object)"my photo");
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery116() {
        String jpql = "select i from Item3 i where :image = any (select KEY(e) from Item3 i, in(i.images) e) order by i";
        CriteriaQuery q = this.cb.createQuery(Item3.class);
        Root i = q.from(Item3.class);
        Subquery sq = q.subquery(String.class);
        Root i1 = sq.from(Item3.class);
        MapJoin e = i1.join(Item3_.images);
        sq.select((Expression)e.key());
        q.select((Selection)i);
        ParameterExpression param1 = this.cb.parameter(String.class, "image");
        q.where((Expression)this.cb.equal((Expression)param1, this.cb.any(sq)));
        q.orderBy(new Order[]{this.cb.asc((Expression)i)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("image", (Object)"my photo");
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery117() {
        String jpql = "select i from Item3 i where exists (select e from Item3 i, in(i.images) e where :image = KEY(e)) order by i";
        CriteriaQuery q = this.cb.createQuery(Item3.class);
        Root i = q.from(Item3.class);
        Subquery sq = q.subquery(String.class);
        Root i1 = sq.from(Item3.class);
        MapJoin e = i1.join(Item3_.images);
        sq.select((Expression)e);
        q.select((Selection)i);
        ParameterExpression param1 = this.cb.parameter(String.class, "image");
        sq.where((Expression)this.cb.equal((Expression)param1, (Expression)e.key()));
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)i)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("image", (Object)"my photo");
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery118() {
        String jpql = "select c from Company1 c";
        CriteriaQuery q = this.cb.createQuery(Company1.class);
        Root c = q.from(Company1.class);
        q.select((Selection)c);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery119() {
        String jpql = "select c from Company2 c";
        CriteriaQuery q = this.cb.createQuery(Company2.class);
        Root c = q.from(Company2.class);
        q.select((Selection)c);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery121() {
        String jpql = "select c from Company1 c where :division =  (select KEY(d) from Company1 c, in(c.organization) d where d.id = 1) order by c ";
        CriteriaQuery q = this.cb.createQuery(Company1.class);
        Root c = q.from(Company1.class);
        Subquery sq = q.subquery(Division.class);
        Root c1 = sq.from(Company1.class);
        MapJoin d = c1.join(Company1_.organization);
        sq.select((Expression)d.key());
        q.select((Selection)c);
        ParameterExpression param1 = this.cb.parameter(Division.class, "division");
        sq.where((Expression)this.cb.equal((Expression)d.value().get(VicePresident_.id), (Object)1));
        q.where((Expression)this.cb.equal((Expression)param1, (Expression)sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)c)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("division", (Object)new Division());
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery122() {
        String jpql = "select c from Company1 c where exists (select KEY(d) from in(c.organization) d  where KEY(d) = :division) order by c ";
        CriteriaQuery q = this.cb.createQuery(Company1.class);
        Root c = q.from(Company1.class);
        Subquery sq = q.subquery(Division.class);
        Root c1 = sq.correlate(c);
        MapJoin d = c1.join(Company1_.organization);
        q.select((Selection)c);
        ParameterExpression param1 = this.cb.parameter(Division.class, "division");
        sq.where((Expression)this.cb.equal((Expression)d.key(), (Object)param1));
        sq.select((Expression)d.key());
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)c)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("division", (Object)new Division());
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery123() {
        String jpql = "select c from Company1 c where exists (select KEY(d) from c.organization d  where KEY(d) = :division) order by c ";
        CriteriaQuery q = this.cb.createQuery(Company1.class);
        Root c = q.from(Company1.class);
        Subquery sq = q.subquery(Division.class);
        Root c1 = sq.correlate(c);
        MapJoin d = c1.join(Company1_.organization);
        sq.select((Expression)d.key());
        q.select((Selection)c);
        ParameterExpression param1 = this.cb.parameter(Division.class, "division");
        sq.where((Expression)this.cb.equal((Expression)d.key(), (Object)param1));
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)c)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("division", (Object)new Division());
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery124() {
        String jpql = "select c from Company2 c where :division = (select KEY(d) from Company2 c, in(c.organization) d where d.id = 3) order by c ";
        CriteriaQuery q = this.cb.createQuery(Company2.class);
        Root c = q.from(Company2.class);
        Subquery sq = q.subquery(Division.class);
        Root c1 = sq.from(Company2.class);
        MapJoin d = c1.join(Company2_.organization);
        sq.select((Expression)d.key());
        q.select((Selection)c);
        ParameterExpression param1 = this.cb.parameter(Division.class, "division");
        sq.where((Expression)this.cb.equal((Expression)d.value().get(VicePresident_.id), (Object)3));
        q.where((Expression)this.cb.equal((Expression)param1, (Expression)sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)c)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("division", (Object)new Division());
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery125() {
        String jpql = "select c from Company2 c where exists (select KEY(d) from in(c.organization) d  where KEY(d) = :k) order by c ";
        CriteriaQuery q = this.cb.createQuery(Company2.class);
        Root c = q.from(Company2.class);
        Subquery sq = q.subquery(Division.class);
        Root c1 = sq.correlate(c);
        MapJoin d = c1.join(Company2_.organization);
        q.select((Selection)c);
        ParameterExpression param1 = this.cb.parameter(Division.class, "k");
        sq.where((Expression)this.cb.equal((Expression)d.key(), (Object)param1));
        sq.select((Expression)d.key());
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)c)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("k", (Object)new Division());
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery126() {
        String jpql = "select c from Company2 c where exists (select VALUE(d) from c.organization d where KEY(d) = :k) order by c ";
        CriteriaQuery q = this.cb.createQuery(Company2.class);
        Root c = q.from(Company2.class);
        Subquery sq = q.subquery(VicePresident.class);
        Root c1 = sq.correlate(c);
        MapJoin d = c1.join(Company2_.organization);
        q.select((Selection)c);
        ParameterExpression param1 = this.cb.parameter(Division.class, "k");
        sq.where((Expression)this.cb.equal((Expression)d.key(), (Object)param1));
        sq.select((Expression)d.value());
        q.where((Expression)this.cb.exists(sq));
        q.orderBy(new Order[]{this.cb.asc((Expression)c)});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("k", (Object)new Division());
            }
        }, q, jpql);
    }

    public void testEmbeddableQuery127() {
        String jpql = "select d from Division d";
        CriteriaQuery q = this.cb.createQuery(Division.class);
        Root d = q.from(Division.class);
        q.select((Selection)d);
        this.assertEquivalence(q, jpql);
    }

    public void testEmbeddableQuery128() {
        String jpql = "select vp from VicePresident vp";
        CriteriaQuery q = this.cb.createQuery(VicePresident.class);
        Root vp = q.from(VicePresident.class);
        q.select((Selection)vp);
        this.assertEquivalence(q, jpql);
    }
}

