/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.Collection;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.Person_;

public class TestEdit
extends CriteriaTest {
    public void testWhereConditionEditedToAddOr() {
        String jpql = "select p from Person p where p.name='XYZ'";
        String editedjpql = "select p from Person p where p.name='XYZ' or p.name='ABC'";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.where((Expression)this.cb.equal((Expression)p.get(Person_.name), (Object)"XYZ"));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        Predicate where = c.getRestriction();
        c.where((Expression)this.cb.or((Expression)where, (Expression)this.cb.equal((Expression)p.get(Person_.name), (Object)"ABC")));
        this.assertEquivalence((CriteriaQuery<?>)c, editedjpql);
    }

    public void testWhereConditionEditedToAddAnd() {
        String jpql = "select p from Person p where p.name='XYZ'";
        String editedjpql = "select p from Person p where p.name='XYZ' and p.name='ABC'";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.where((Expression)this.cb.equal((Expression)p.get(Person_.name), (Object)"XYZ"));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        Predicate where = c.getRestriction();
        c.where((Expression)this.cb.and((Expression)where, (Expression)this.cb.equal((Expression)p.get(Person_.name), (Object)"ABC")));
        this.assertEquivalence((CriteriaQuery<?>)c, editedjpql);
    }

    public void testWhereConditionEditedToRemoveAnd() {
        String jpql = "select p from Person p where p.name='XYZ' and p.name='ABC'";
        String editedjpql = "select p from Person p where p.name='XYZ'";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        Predicate p1 = this.cb.equal((Expression)p.get(Person_.name), (Object)"XYZ");
        Predicate p2 = this.cb.equal((Expression)p.get(Person_.name), (Object)"ABC");
        c.where(new Predicate[]{p1, p2});
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        Predicate where = c.getRestriction();
        List exprs = where.getExpressions();
        TestEdit.assertEquals((int)2, (int)exprs.size());
        TestEdit.assertTrue((boolean)exprs.contains(p1));
        TestEdit.assertTrue((boolean)exprs.contains(p2));
        exprs.remove(p1);
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        c.where((Expression)p1);
        this.assertEquivalence((CriteriaQuery<?>)c, editedjpql);
    }

    public void testEditOrderBy() {
        String jpql = "select p from Person p ORDER BY p.name";
        String editedjpql = "select p from Person p ORDER BY p.name, p.id DESC";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.orderBy(new Order[]{this.cb.asc((Expression)p.get(Person_.name))});
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        List orders = c.getOrderList();
        TestEdit.assertEquals((int)1, (int)orders.size());
        orders.add(this.cb.desc((Expression)p.get(Person_.id)));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        c.orderBy(orders.toArray(new Order[orders.size()]));
        this.assertEquivalence((CriteriaQuery<?>)c, editedjpql);
    }

    public void testEditedToAddMultiselectionTerm() {
        String jpql = "select p from Person p";
        String editedjpql = "select p,p.name from Person p";
        OpenJPACriteriaQuery c = this.cb.createTupleQuery();
        Root p = c.from(Person.class);
        c.multiselect(new Selection[]{p});
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        List terms = c.getSelection().getCompoundSelectionItems();
        terms.add(p.get(Person_.name));
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
        c.multiselect(new Selection[]{p, p.get(Person_.name)});
        this.assertEquivalence((CriteriaQuery<?>)c, editedjpql);
    }

    public void testSingleSelectionHasNoCompoundItems() {
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.select((Selection)p);
        try {
            Selection term = c.getSelection();
            term.getCompoundSelectionItems();
            TestEdit.fail((String)"Expected to fail because primary selection has no compound terms");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCandidateClassIsImplicitlySelectedForEntityQuery() {
        String jpql = "select p from Person p";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        Selection term = c.getSelection();
        TestEdit.assertNull((Object)term);
        this.assertEquivalence((CriteriaQuery<?>)c, jpql);
    }

    public void testCandidateClassIsNotImplicitlySelectedForNonEntityQuery() {
        String jpql = "select p from Person p";
        OpenJPACriteriaQuery c = this.cb.createTupleQuery();
        Root p = c.from(Person.class);
        Selection term = c.getSelection();
        TestEdit.assertNull((Object)term);
        this.assertFails("Expected to fail without a projection term", (CriteriaQuery<?>)c);
    }

    public void testRootIsNotImplicitlyDefined() {
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Selection term = c.getSelection();
        TestEdit.assertNull((Object)term);
        this.assertFails("Expected to fail without a defined root", (CriteriaQuery<?>)c);
    }

    public void testEditParameterizedPredicate() {
        String jpql = "select p from Person p where p.name=:p1";
        String editedjpql = "select p from Person p where p.name=:p1 and p.name=:p2";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.where((Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p1")));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("p1", (Object)"XYZ");
            }
        }, (CriteriaQuery<?>)c, jpql);
        Predicate where = c.getRestriction();
        c.where((Expression)this.cb.and((Expression)where, (Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p2"))));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("p1", (Object)"MNO");
                q.setParameter("p2", (Object)"ABC");
            }
        }, (CriteriaQuery<?>)c, editedjpql);
    }

    public void testEditParameterizedPredicateReplaced() {
        String jpql = "select p from Person p where p.name=:p1 and p.name=:p2";
        String editedjpql = "select p from Person p where p.name=:p3";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p1")), (Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p2"))));
        TestEdit.assertEquals((int)2, (int)c.getParameters().size());
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("p1", (Object)"XYZ");
                q.setParameter("p2", (Object)"ABC");
            }
        }, (CriteriaQuery<?>)c, jpql);
        c.where((Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p3")));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("p3", (Object)"MNO");
            }
        }, (CriteriaQuery<?>)c, editedjpql);
    }

    public void testEditParameterizedPredicateRemoved() {
        String jpql = "select p from Person p where p.name=:p1 and p.name=:p2";
        String editedjpql = "select p from Person p where p.name=:p1";
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p1")), (Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p2"))));
        TestEdit.assertEquals((int)2, (int)c.getParameters().size());
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("p1", (Object)"XYZ");
                q.setParameter("p2", (Object)"ABC");
            }
        }, (CriteriaQuery<?>)c, jpql);
        c.where((Expression)this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "p1")));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("p1", (Object)"MNO");
            }
        }, (CriteriaQuery<?>)c, editedjpql);
    }

    public void testSerachWithinResult() {
        this.em.getTransaction().begin();
        this.em.createQuery("DELETE FROM Person p").executeUpdate();
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        Person p1 = new Person();
        p1.setName("Pinaki");
        Person p2 = new Person();
        p2.setName("Pacino");
        Person p3 = new Person();
        p3.setName("Tom");
        Person p4 = new Person();
        p4.setName("Dick");
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        this.em.persist((Object)p4);
        this.em.getTransaction().commit();
        OpenJPACriteriaQuery c = this.cb.createQuery(Person.class);
        Root p = c.from(Person.class);
        c.select((Selection)p);
        Predicate like = this.cb.like((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "pattern"));
        c.where((Expression)like);
        TypedQuery q1 = this.em.createQuery((CriteriaQuery)c).setParameter("pattern", (Object)"P%");
        List r1 = q1.getResultList();
        TestEdit.assertEquals((int)2, (int)r1.size());
        Predicate exact = this.cb.equal((Expression)p.get(Person_.name), (Expression)this.cb.parameter(String.class, "exact"));
        c.where(new Predicate[]{like, exact});
        TypedQuery q2 = this.em.createQuery((CriteriaQuery)c).setParameter("pattern", (Object)"P%").setParameter("exact", (Object)"Pinaki");
        OpenJPAPersistence.cast((Query)q2).setCandidateCollection((Collection)r1);
        auditor.clear();
        List r2 = q2.getResultList();
        TestEdit.assertTrue((boolean)auditor.getSQLs().isEmpty());
        TestEdit.assertEquals((int)1, (int)r2.size());
    }

    void assertFails(String message, CriteriaQuery<?> c) {
        try {
            this.em.createQuery(c);
            TestEdit.fail((String)message);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

