/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.HashSet;
import java.util.List;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Customer;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Order;

public class TestDistinctCriteria
extends CriteriaTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.deleteDataForTestDistinct();
            this.createDataForTestDistinct();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.deleteDataForTestDistinct();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    void createDataForTestDistinct() {
        this.em.getTransaction().begin();
        Address a1 = new Address();
        a1.setState("NY");
        Address a2 = new Address();
        a2.setState("RI");
        Customer c1 = new Customer();
        c1.setAddress(a1);
        Customer c2 = new Customer();
        c2.setAddress(a2);
        Order o1 = new Order();
        o1.setCustomer(c1);
        Order o2 = new Order();
        o2.setCustomer(c1);
        Order o3 = new Order();
        o3.setCustomer(c2);
        HashSet<Order> orders = new HashSet<Order>();
        orders.add(o1);
        orders.add(o2);
        c1.setOrders(orders);
        orders.clear();
        orders.add(o3);
        c2.setOrders(orders);
        this.em.persist((Object)c1);
        this.em.persist((Object)c2);
        this.em.persist((Object)a1);
        this.em.persist((Object)a2);
        this.em.persist((Object)o1);
        this.em.persist((Object)o2);
        this.em.persist((Object)o3);
        this.em.getTransaction().commit();
    }

    void deleteDataForTestDistinct() {
        this.em.getTransaction().begin();
        this.em.createQuery("delete from Customer o").executeUpdate();
        this.em.createQuery("delete from Address o").executeUpdate();
        this.em.createQuery("delete from Order o").executeUpdate();
        this.em.getTransaction().commit();
    }

    public void testDistinct() {
        OpenJPACriteriaQuery cq = this.cb.createQuery(Customer.class);
        Root customer = cq.from(Customer.class);
        Fetch o = customer.fetch("orders", JoinType.LEFT);
        cq.where((Expression)customer.get("address").get("state").in(new Object[]{"NY", "RI"}));
        cq.select((Selection)customer).distinct(true);
        TypedQuery distinctQuery = this.em.createQuery((CriteriaQuery)cq);
        distinctQuery.setMaxResults(20);
        List distinctResult = distinctQuery.getResultList();
        TestDistinctCriteria.assertEquals((int)2, (int)distinctResult.size());
        cq.distinct(false);
        TypedQuery indistinctQuery = this.em.createQuery((CriteriaQuery)cq);
        indistinctQuery.setMaxResults(20);
        List indistinctResult = indistinctQuery.getResultList();
        TestDistinctCriteria.assertEquals((int)3, (int)indistinctResult.size());
    }
}

