/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.criteria.A;
import org.apache.openjpa.persistence.criteria.Account;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.B;
import org.apache.openjpa.persistence.criteria.C;
import org.apache.openjpa.persistence.criteria.CompUser;
import org.apache.openjpa.persistence.criteria.Contact;
import org.apache.openjpa.persistence.criteria.Contractor;
import org.apache.openjpa.persistence.criteria.Course;
import org.apache.openjpa.persistence.criteria.CreditCard;
import org.apache.openjpa.persistence.criteria.Customer;
import org.apache.openjpa.persistence.criteria.D;
import org.apache.openjpa.persistence.criteria.Department;
import org.apache.openjpa.persistence.criteria.Dependent;
import org.apache.openjpa.persistence.criteria.DependentId;
import org.apache.openjpa.persistence.criteria.Employee;
import org.apache.openjpa.persistence.criteria.Exempt;
import org.apache.openjpa.persistence.criteria.FemaleUser;
import org.apache.openjpa.persistence.criteria.FrequentFlierPlan;
import org.apache.openjpa.persistence.criteria.Item;
import org.apache.openjpa.persistence.criteria.LineItem;
import org.apache.openjpa.persistence.criteria.Magazine;
import org.apache.openjpa.persistence.criteria.MaleUser;
import org.apache.openjpa.persistence.criteria.Manager;
import org.apache.openjpa.persistence.criteria.Movie;
import org.apache.openjpa.persistence.criteria.Order;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.Phone;
import org.apache.openjpa.persistence.criteria.Photo;
import org.apache.openjpa.persistence.criteria.Product;
import org.apache.openjpa.persistence.criteria.Publisher;
import org.apache.openjpa.persistence.criteria.Semester;
import org.apache.openjpa.persistence.criteria.StringComparison;
import org.apache.openjpa.persistence.criteria.Student;
import org.apache.openjpa.persistence.criteria.Transaction;
import org.apache.openjpa.persistence.criteria.TransactionHistory;
import org.apache.openjpa.persistence.criteria.VideoStore;
import org.apache.openjpa.persistence.query.DomainObject;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.OpenJPAQueryBuilder;
import org.apache.openjpa.persistence.query.OrderByItem;
import org.apache.openjpa.persistence.query.PathExpression;
import org.apache.openjpa.persistence.query.Predicate;
import org.apache.openjpa.persistence.query.PredicateOperand;
import org.apache.openjpa.persistence.query.QueryBuilderImpl;
import org.apache.openjpa.persistence.query.QueryDefinition;
import org.apache.openjpa.persistence.query.SelectItem;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCriteria
extends SingleEMFTestCase {
    protected OpenJPAQueryBuilder qb;
    protected StringComparison comparator = new StringComparison();

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, "openjpa.DynamicEnhancementAgent", "false", "openjpa.DataCache", "true", "openjpa.QueryCache", "true", Account.class, Address.class, A.class, B.class, CompUser.class, Contact.class, Contractor.class, Course.class, CreditCard.class, Customer.class, C.class, Department.class, DependentId.class, Dependent.class, D.class, Employee.class, Exempt.class, FemaleUser.class, FrequentFlierPlan.class, Item.class, LineItem.class, Magazine.class, MaleUser.class, Manager.class, Movie.class, Order.class, Person.class, Phone.class, Photo.class, Product.class, Publisher.class, Semester.class, Student.class, TransactionHistory.class, Transaction.class, VideoStore.class);
        this.qb = (QueryBuilderImpl)this.emf.getDynamicQueryBuilder();
        this.emf.createEntityManager();
    }

    public void testLogicalPredicateAssociativity() {
        DomainObject e = this.qb.createQueryDefinition(Employee.class);
        Predicate p1 = e.get("salary").greaterThan((Number)100);
        Predicate p2 = e.get("rating").equal((Number)5);
        Predicate p3 = e.get("name").like("John");
        Predicate w1 = p1.and(p2.or(p3));
        Predicate w2 = p1.and(p2).or(p3);
        QueryDefinition q1 = e.select(new SelectItem[]{e}).where(w1);
        String jpql1 = this.qb.toJPQL(q1);
        this.emf.createEntityManager().createDynamicQuery(q1).getResultList();
        QueryDefinition q2 = e.select(new SelectItem[]{e}).where(w2);
        String jpql2 = this.qb.toJPQL(q2);
        System.err.println(jpql1);
        System.err.println(jpql2);
        TestCriteria.assertNotEquals(jpql1, jpql2);
        this.emf.createEntityManager().createDynamicQuery(q2).getResultList();
    }

    public void testMultipleDomainOfSameClass() {
        DomainObject o1 = this.qb.createQueryDefinition(Order.class);
        DomainObject o2 = o1.addRoot(Order.class);
        o1.select(new SelectItem[]{o1}).where(o1.get("quantity").greaterThan((PredicateOperand)o2.get("quantity")).and(o2.get("customer").get("lastName").equal("Smith")).and(o2.get("customer").get("firstName").equal("John")));
        String jpql = "select o from Order o, Order o2 where o.quantity > o2.quantity and o2.customer.lastName = 'Smith' and o2.customer.firstName = 'John'";
        this.compare(jpql, (QueryDefinition)o1);
    }

    public void testFetchJoin() {
        DomainObject d = this.qb.createQueryDefinition(Department.class);
        d.leftJoinFetch("employees");
        d.where(d.get("deptNo").equal((Number)1));
        String jpql = "select d from Department d LEFT JOIN FETCH d.employees where d.deptNo = 1";
        this.compare(jpql, (QueryDefinition)d);
    }

    public void testMultipartNavigation() {
        DomainObject e = this.qb.createQueryDefinition(Employee.class);
        DomainObject p = e.join("contactInfo").join("phones");
        e.where(e.get("contactInfo").get("address").get("zipCode").equal("95094")).select(new SelectItem[]{p.get("vendor")});
        String jpql = "select p.vendor from Employee e JOIN e.contactInfo c JOIN c.phones p where e.contactInfo.address.zipCode = '95094'";
        this.compare(jpql, (QueryDefinition)e);
    }

    public void testOperatorPath() {
        QueryDefinition qdef = this.qb.createQueryDefinition();
        DomainObject item = qdef.addRoot(Item.class);
        DomainObject photo = item.join("photos");
        qdef.select(new SelectItem[]{item.get("name"), photo.value()}).where(photo.key().like("egret"));
        String jpql = "select i.name, VALUE(p) from Item i join i.photos p where KEY(p) like 'egret'";
        this.compare(jpql, qdef);
    }

    public void testLiteral() {
        DomainObject c = this.qb.createQueryDefinition(Customer.class);
        DomainObject o = c.join("orders");
        DomainObject a = c.join("address");
        o.where(a.get("state").equal("CA").and(a.get("county").equal("Santa Clara")));
        o.select(new SelectItem[]{o.get("quantity"), o.get("cost").times((Number)1.08), a.get("zipCode")});
        String jpql = "select o.quantity, o.cost*1.08, a.zipCode from Customer c join c.orders o join c.address a where a.state = 'CA' and a.county = 'Santa Clara'";
        this.compare(jpql, (QueryDefinition)c);
    }

    public void testTypeExpression() {
        DomainObject e = this.qb.createQueryDefinition(Employee.class);
        e.select(new SelectItem[]{e.type()}).where(e.type().equal(Exempt.class).not());
        String jpql = "select TYPE(e) from Employee e where TYPE(e) <> Exempt";
        this.compare(jpql, (QueryDefinition)e);
    }

    public void testIndex() {
        DomainObject c = this.qb.createQueryDefinition(Course.class);
        DomainObject w = c.join("studentWaitList");
        c.where(c.get("name").equal("Calculus").and(w.index().equal((Number)0))).select(new SelectItem[]{w.get("name")});
        String jpql = "select s.name from Course c join c.studentWaitList s where c.name = 'Calculus' and INDEX(s) = 0";
        this.compare(jpql, (QueryDefinition)c);
    }

    public void testSum() {
        DomainObject o = this.qb.createQueryDefinition(Order.class);
        DomainObject l = o.join("lineItems");
        DomainObject c = o.join("customer");
        c.where(c.get("lastName").equal("Smith").and(c.get("firstName").equal("John"))).select(new SelectItem[]{l.get("price").sum()});
        String jpql = "select SUM(l.price) from Order o join o.lineItems l JOIN o.customer c where c.lastName = 'Smith' and c.firstName = 'John'";
        this.compare(jpql, (QueryDefinition)c);
    }

    public void testSize() {
        DomainObject d = this.qb.createQueryDefinition(Department.class);
        d.where(d.get("name").equal("Sales")).select(new SelectItem[]{d.get("employees").size()});
        String jpql = "select SIZE(d.employees) from Department d  where d.name = 'Sales'";
        this.compare(jpql, (QueryDefinition)d);
    }

    public void testCount() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < 50; ++i) {
            em.persist((Object)new Department());
        }
        em.getTransaction().commit();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Department.class);
        Root book = q.from(Department.class);
        TypedQuery dept = em.createQuery(q);
        int size = dept.getResultList().size();
        CriteriaQuery c = cb.createQuery(Long.class);
        Root from = c.from(Department.class);
        c.select((Selection)cb.count((javax.persistence.criteria.Expression)from));
        TypedQuery query = em.createQuery(c);
        long count = (Long)query.getSingleResult();
        TestCriteria.assertEquals((long)size, (long)count);
    }

    public void testGeneralCase() {
        DomainObject e = this.qb.createQueryDefinition(Employee.class);
        e.where(e.get("department").get("name").equal("Engineering"));
        e.select(new SelectItem[]{e.get("name"), e.generalCase().when(e.get("rating").equal((Number)1)).then(e.get("salary").times((Number)1.1)).when(e.get("rating").equal((Number)2)).then(e.get("salary").times((Number)1.2)).elseCase(e.get("salary").times((Number)1.01))});
        String jpql = "SELECT e.name, CASE WHEN e.rating = 1 THEN e.salary * 1.1 WHEN e.rating = 2 THEN e.salary * 1.2 ELSE e.salary * 1.01 END FROM Employee e WHERE e.department.name = 'Engineering'";
        this.compare(jpql, (QueryDefinition)e);
    }

    public void testMemberOf() {
        DomainObject p = this.qb.createQueryDefinition(Person.class);
        p.where(p.literal("Joe").member(p.get("nicknames")));
        String jpql = "select p from Person p  where 'Joe' MEMBER OF p.nicknames";
        this.compare(jpql, (QueryDefinition)p);
    }

    public void testParamater() {
        QueryDefinition qdef = this.qb.createQueryDefinition();
        DomainObject customer = qdef.addRoot(Customer.class);
        qdef.where(customer.get("status").equal((PredicateOperand)qdef.param("status")));
        String jpql = "select c from Customer c  where c.status = :status";
        this.compare(jpql, qdef, "status", 1);
    }

    public void testBetween() {
        DomainObject c = this.qb.createQueryDefinition(CreditCard.class);
        DomainObject t = c.join("transactionHistory");
        c.select(new SelectItem[]{t}).where(c.get("holder").get("name").equal("John Doe").and(t.index().between((Number)0, (Number)9)));
        String jpql = "select t from CreditCard c JOIN c.transactionHistory t where c.holder.name = 'John Doe' AND INDEX(t)  BETWEEN 0 AND 9";
        this.compare(jpql, (QueryDefinition)c);
    }

    public void testIsEmpty() {
        DomainObject o = this.qb.createQueryDefinition(Order.class);
        o.where(o.get("lineItems").isEmpty());
        String jpql = "select o from Order o  where o.lineItems IS EMPTY";
        this.compare(jpql, (QueryDefinition)o);
    }

    public void testNonCorrelatedSubQuery() {
        QueryDefinition q1 = this.qb.createQueryDefinition();
        DomainObject goodCustomer = q1.addRoot(Customer.class);
        QueryDefinition q2 = this.qb.createQueryDefinition();
        DomainObject customer = q2.addRoot(Customer.class);
        q1.where(goodCustomer.get("balanceOwned").lessThan((PredicateOperand)q2.select(new SelectItem[]{customer.get("balanceOwned").avg()})));
        String jpql = "select c from Customer c  where c.balanceOwned < (select AVG(c2.balanceOwned) from Customer c2)";
        this.compare(jpql, q1);
    }

    public void testNew() {
        QueryDefinition q = this.qb.createQueryDefinition();
        DomainObject customer = q.addRoot(Customer.class);
        DomainObject order = customer.join("orders");
        q.where(order.get("count").greaterThan((Number)100)).select(new SelectItem[]{q.newInstance(Customer.class, new SelectItem[]{customer.get("id"), customer.get("status"), order.get("count")})});
        String jpql = "SELECT NEW org.apache.openjpa.persistence.criteria.Customer(c.id, c.status, o.count) FROM Customer c JOIN c.orders o WHERE o.count > 100";
        this.compare(jpql, q);
    }

    public void testKeyValueOperatorPath() {
        QueryDefinition q = this.qb.createQueryDefinition();
        DomainObject v = q.addRoot(VideoStore.class);
        DomainObject i = v.join("videoInventory");
        q.where(v.get("location").get("zipCode").equal("94301").and(i.value().greaterThan((Number)0)));
        q.select(new SelectItem[]{v.get("location").get("street"), i.key().get("title"), i.value()});
        String jpql = "SELECT v.location.street, KEY(v2).title, VALUE(v2) FROM VideoStore v JOIN v.videoInventory v2 WHERE v.location.zipCode = '94301' AND VALUE(v2) > 0";
        this.compare(jpql, q);
    }

    public void testGroupByHaving() {
        QueryDefinition q = this.qb.createQueryDefinition();
        DomainObject customer = q.addRoot(Customer.class);
        q.select(new SelectItem[]{customer.get("status"), customer.get("filledOrderCount").avg(), customer.count()}).groupBy(new PathExpression[]{customer.get("status")}).having(customer.get("status").in(new Number[]{1, 2}));
        String jpql = "SELECT c.status, AVG(c.filledOrderCount), COUNT(c) FROM Customer c GROUP BY c.status HAVING c.status IN (1, 2)";
        this.compare(jpql, q);
    }

    public void testGroupByHaving2() {
        QueryDefinition q = this.qb.createQueryDefinition();
        DomainObject customer = q.addRoot(Customer.class);
        q.select(new SelectItem[]{customer.get("country"), customer.count()}).groupBy(new PathExpression[]{customer.get("country")}).having(customer.count().greaterThan((Number)30));
        String jpql = "SELECT c.country, COUNT(c) FROM Customer c GROUP BY c.country HAVING COUNT(c) > 30";
        this.compare(jpql, q);
    }

    public void testOrderBy() {
        QueryDefinition q = this.qb.createQueryDefinition();
        DomainObject customer = q.addRoot(Customer.class);
        DomainObject order = customer.join("orders");
        DomainObject address = customer.join("address");
        q.where(address.get("state").equal("CA")).select(new SelectItem[]{order}).orderBy(new OrderByItem[]{order.get("quantity").desc(), order.get("totalcost")});
        String jpql = "SELECT o FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity DESC, o.totalcost";
        this.compare(jpql, q);
    }

    public void testOrderBy2() {
        QueryDefinition q = this.qb.createQueryDefinition();
        DomainObject customer = q.addRoot(Customer.class);
        DomainObject order = customer.join("orders");
        DomainObject address = customer.join("address");
        q.where(address.get("state").equal("CA")).select(new SelectItem[]{order.get("quantity"), address.get("zipCode")}).orderBy(new OrderByItem[]{order.get("quantity").desc(), address.get("zipCode")});
        String jpql = "SELECT o.quantity, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity DESC, a.zipCode";
        this.compare(jpql, q);
    }

    public void testOrderByExpression() {
        DomainObject o = this.qb.createQueryDefinition(Order.class);
        DomainObject a = o.join("customer").join("address");
        Expression taxedCost = o.get("cost").times((Number)1.08);
        o.select(new SelectItem[]{o.get("quantity"), taxedCost, a.get("zipCode")}).where(a.get("state").equal("CA").and(a.get("county").equal("Santa Clara"))).orderBy(new OrderByItem[]{o.get("quantity"), taxedCost, a.get("zipCode")});
        String jpql = "SELECT o.quantity, o.cost*1.08 as o2, a.zipCode FROM Order o JOIN o.customer c JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara' ORDER BY o.quantity, o2, a.zipCode";
        this.compare(jpql, (QueryDefinition)o);
    }

    public void testCorrelatedSubquery() {
        QueryDefinition q1 = this.qb.createQueryDefinition();
        DomainObject emp = q1.addRoot(Employee.class);
        QueryDefinition q2 = this.qb.createQueryDefinition();
        DomainObject spouseEmp = q2.addRoot(Employee.class);
        q2.where(spouseEmp.equal((PredicateOperand)emp.get("spouse"))).select(new SelectItem[]{spouseEmp});
        q1.selectDistinct(new SelectItem[]{emp}).where(q2.exists());
        String jpql = "SELECT DISTINCT e  FROM Employee e WHERE EXISTS ( SELECT e2  FROM Employee e2 WHERE e2 = e.spouse)";
        this.compare(jpql, q1);
    }

    public void testCreateSubquery() {
        DomainObject customer = this.qb.createQueryDefinition(Customer.class);
        DomainObject order = this.qb.createSubqueryDefinition(customer.get("orders"));
        customer.where(order.select(new SelectItem[]{order.get("cost").avg()}).greaterThan((Number)100));
        String jpql = "SELECT c  FROM Customer c WHERE (SELECT AVG(o.cost) FROM c.orders o) > 100";
        this.compare(jpql, (QueryDefinition)customer);
    }

    public void testTypeList() {
        DomainObject q = this.qb.createQueryDefinition(Employee.class);
        q.where(q.type().in(new Class[]{Exempt.class, Contractor.class}));
        String jpql = "SELECT e  FROM Employee e WHERE TYPE(e) IN (Exempt, Contractor)";
        this.compare(jpql, (QueryDefinition)q);
    }

    public void testStringList() {
        DomainObject q = this.qb.createQueryDefinition(Customer.class);
        q.where(q.get("country").in(new String[]{"USA", "UK", "France"}));
        String jpql = "SELECT c  FROM Customer c WHERE c.country IN ('USA', 'UK', 'France')";
        this.compare(jpql, (QueryDefinition)q);
    }

    public void testConcat() {
        DomainObject e = this.qb.createQueryDefinition(Employee.class);
        DomainObject f = e.join("frequentFlierPlan");
        Expression c = e.generalCase().when(f.get("annualMiles").greaterThan((Number)50000)).then("Platinum").when(f.get("annualMiles").greaterThan((Number)25000)).then("Gold").elseCase("XYZ");
        e.select(new SelectItem[]{e.get("name"), f.get("name"), e.concat(new Expression[]{c, e.literal("Frequent Flyer")})});
        String jpql = "SELECT e.name, f.name, CONCAT( CASE WHEN f.annualMiles > 50000 THEN 'Platinum' WHEN f.annualMiles > 25000 THEN 'Gold' ELSE 'XYZ' END, 'Frequent Flyer') FROM Employee e JOIN e.frequentFlierPlan f";
        this.compare(jpql, (QueryDefinition)e);
    }

    public void testCorrelatedSubquerySpecialCase1() {
        DomainObject o = this.qb.createQueryDefinition(Order.class);
        DomainObject a = this.qb.createSubqueryDefinition(o.get("customer").get("accounts"));
        o.select(new SelectItem[]{o}).where(o.literal((Number)10000).lessThan((PredicateOperand)a.select(new SelectItem[]{a.get("balance")}).all()));
        String jpql = "select o from Order o where 10000 < ALL  (select a.balance from o.customer c join o.customer.accounts a)";
        this.compare(jpql, (QueryDefinition)o);
    }

    public void testCorrelatedSubquerySpecialCase2() {
        DomainObject o = this.qb.createQueryDefinition(Order.class);
        DomainObject c = o.join("customer");
        DomainObject a = this.qb.createSubqueryDefinition(c.get("accounts"));
        o.select(new SelectItem[]{o}).where(o.literal((Number)10000).lessThan((PredicateOperand)a.select(new SelectItem[]{a.get("balance")}).all()));
        String jpql = "select o from Order o JOIN o.customer c where 10000 < ALL  (select a.balance from c.accounts a)";
        this.compare(jpql, (QueryDefinition)o);
    }

    public void testRecursiveDefinitionIsNotAllowed() {
        DomainObject q = this.qb.createQueryDefinition(Customer.class);
        q.where(q.exists().and(q.get("name").equal("wrong")));
        try {
            this.qb.toJPQL((QueryDefinition)q);
            TestCriteria.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void compare(String jpql, QueryDefinition q) {
        this.compare(jpql, q, null);
    }

    void compare(String jpql, QueryDefinition q, Object ... p) {
        this.executeActually(jpql, q, p);
    }

    private void compareLiterally(String jpql, QueryDefinition q) {
        String actual = this.qb.toJPQL(q);
        if (!this.comparator.compare(jpql, actual)) {
            TestCriteria.fail((String)("\r\nExpected: [" + jpql + "]\r\nActual  : [" + actual + "]"));
        }
    }

    private void executeActually(String jpql, QueryDefinition q, Object ... p) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List criteriaResult = null;
        List jpqlResult = null;
        Exception criteriaError = null;
        Exception jpqlError = null;
        try {
            OpenJPAQuery cq = em.createDynamicQuery(q);
            this.setParameters((Query)cq, p);
            criteriaResult = cq.getResultList();
        }
        catch (Exception e) {
            criteriaError = e;
        }
        try {
            OpenJPAQuery nq = em.createQuery(jpql);
            this.setParameters((Query)nq, p);
            jpqlResult = nq.getResultList();
        }
        catch (Exception e) {
            jpqlError = e;
        }
        if (criteriaError == null && jpqlError == null) {
            TestCriteria.assertEquals((int)criteriaResult.size(), (int)jpqlResult.size());
        } else if (criteriaError != null && jpqlError == null) {
            TestCriteria.fail((String)("QueryDefinition generated invalid JPQL\r\nCriteria [" + this.qb.toJPQL(q) + "]\r\nerror : " + criteriaError.getMessage()));
        } else if (criteriaError == null && jpqlError != null) {
            TestCriteria.fail((String)("Handcrafted JPQL is invalid \r\nJPQL [" + jpql + "]\r\nerror : " + jpqlError.getMessage()));
        } else {
            this.compareLiterally(jpql, q);
        }
    }

    void setParameters(Query q, Object ... p) {
        if (p == null) {
            return;
        }
        for (int i = 0; i < p.length; i += 2) {
            q.setParameter(p[i].toString(), p[i + 1]);
        }
    }
}

