/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import junit.framework.TestCase;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.lib.jdbc.ReportingSQLException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.FilteringJDBCListener;

public abstract class AbstractCriteriaTestCase
extends TestCase {
    private DBDictionary dict = null;

    protected abstract SQLAuditor getAuditor();

    protected abstract OpenJPAEntityManagerFactorySPI getEntityManagerFactory();

    protected abstract EntityManager getEntityManager();

    public DBDictionary getDictionary() {
        return this.dict;
    }

    public void tearDown() throws Exception {
        this.dict = null;
        super.tearDown();
    }

    protected OpenJPAEntityManagerFactorySPI createNamedEMF(Class<?> ... types) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='add')");
        map.put("openjpa.jdbc.QuerySQLCache", "false");
        map.put("openjpa.DynamicEnhancementAgent", "false");
        map.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
        map.put("openjpa.Compatibility", "QuotedNumbersInQueries=true");
        map.put("openjpa.jdbc.JDBCListeners", new JDBCListener[]{this.getAuditor()});
        StringBuilder buf = new StringBuilder();
        for (Class<?> c : types) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(c.getName());
        }
        map.put("openjpa.MetaDataFactory", "jpa(Types=" + buf.toString() + ")");
        HashMap<Object, Object> config = new HashMap<Object, Object>(System.getProperties());
        config.putAll(map);
        return (OpenJPAEntityManagerFactorySPI)Persistence.createEntityManagerFactory((String)"test", config);
    }

    void setDictionary() {
        JDBCConfiguration conf = (JDBCConfiguration)this.getEntityManagerFactory().getConfiguration();
        this.dict = conf.getDBDictionaryInstance();
        if (this.dict instanceof DerbyDictionary || this.dict instanceof HSQLDictionary) {
            this.dict.requiresCastForComparisons = false;
            this.dict.requiresCastForMathFunctions = false;
        } else if (this.dict instanceof OracleDictionary) {
            this.dict.setJoinSyntax("sql92");
        }
    }

    void assertEquivalence(CriteriaQuery<?> c, String jpql) {
        this.assertEquivalence(null, c, jpql, null);
    }

    void assertEquivalence(CriteriaQuery<?> c, String jpql, String expectedSQL) {
        this.assertEquivalence(null, c, jpql, expectedSQL);
    }

    void assertEquivalence(QueryDecorator decorator, CriteriaQuery<?> c, String jpql) {
        this.assertEquivalence(decorator, c, jpql, null);
    }

    void assertEquivalence(QueryDecorator decorator, CriteriaQuery<?> c, String jpql, String expectedSQL) {
        System.err.println("JPQL:[" + jpql + "]");
        System.err.println("CQL :[" + ((OpenJPACriteriaQuery)c).toCQL());
        TypedQuery cQ = this.getEntityManager().createQuery(c);
        Query jQ = this.getEntityManager().createQuery(jpql);
        if (decorator != null) {
            decorator.decorate((Query)cQ);
            decorator.decorate(jQ);
        }
        this.executeAndCompareSQL(jpql, (Query)cQ, jQ, expectedSQL);
    }

    void executeAndCompareSQL(String jpql, Query cQ, Query jQ, String expectedSQL) {
        StringWriter w;
        List<String> jSQL = null;
        List<String> cSQL = null;
        try {
            jSQL = this.executeQueryAndCollectSQL(jQ);
        }
        catch (Exception e) {
            w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            AbstractCriteriaTestCase.fail((String)("JPQL " + jpql + " failed to execute\r\n" + w));
        }
        this.getEntityManager().clear();
        try {
            cSQL = this.executeQueryAndCollectSQL(cQ);
        }
        catch (Exception e) {
            w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            AbstractCriteriaTestCase.fail((String)("CriteriaQuery corresponding to " + jpql + " failed to execute\r\n" + w));
        }
        if (jSQL.size() != cSQL.size()) {
            this.printSQL("Target SQL for JPQL", jSQL);
            this.printSQL("Target SQL for CriteriaQuery", cSQL);
            AbstractCriteriaTestCase.assertEquals((String)("No. of SQL generated for JPQL and CriteriaQuery for " + jpql + " is different"), (int)jSQL.size(), (int)cSQL.size());
        }
        if (!(this.dict instanceof DerbyDictionary || this.dict instanceof MySQLDictionary || this.dict instanceof MariaDBDictionary)) {
            return;
        }
        for (int i = 0; i < jSQL.size(); ++i) {
            if (jSQL.get(i).equalsIgnoreCase(cSQL.get(i))) continue;
            this.printSQL("Target SQL for JPQL", jSQL);
            this.printSQL("Target SQL for CriteriaQuery", cSQL);
            AbstractCriteriaTestCase.assertTrue((String)(i + "-th SQL for JPQL and CriteriaQuery for " + jpql + " is different\r\nJPQL = [" + jSQL.get(i) + "]\r\nCSQL = [" + cSQL.get(i) + "]\r\n"), (boolean)jSQL.get(i).equalsIgnoreCase(cSQL.get(i)));
        }
        if (expectedSQL != null) {
            AbstractCriteriaTestCase.assertTrue((String)("SQL for JPQL " + jpql + " is different than expecetd " + expectedSQL), (boolean)jSQL.get(0).equalsIgnoreCase(expectedSQL));
        }
    }

    void executeAndCompareSQL(String jpql, String expectedSQL) {
        Query jQ = this.getEntityManager().createQuery(jpql);
        List<String> jSQL = null;
        try {
            jSQL = this.executeQueryAndCollectSQL(jQ);
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            AbstractCriteriaTestCase.fail((String)("JPQL " + jpql + " failed to execute\r\n" + w));
        }
        if (!(this.dict instanceof DerbyDictionary || this.dict instanceof MySQLDictionary || this.dict instanceof MariaDBDictionary)) {
            return;
        }
        for (int i = 0; i < jSQL.size(); ++i) {
            if (jSQL.get(i).equalsIgnoreCase(expectedSQL)) continue;
            this.printSQL("SQL for JPQL", jSQL.get(i));
            this.printSQL("Expected SQL", expectedSQL);
            AbstractCriteriaTestCase.assertTrue((String)(i + "-th SQL for JPQL: " + jSQL.get(i) + " are different than Expected SQL " + expectedSQL), (boolean)expectedSQL.equalsIgnoreCase(jSQL.get(i)));
        }
    }

    void executeAndCompareSQL(Query jQ, String expectedSQL) {
        List<String> jSQL = null;
        try {
            jSQL = this.executeQueryAndCollectSQL(jQ);
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            AbstractCriteriaTestCase.fail((String)w.toString());
        }
        if (!(this.dict instanceof DerbyDictionary || this.dict instanceof MySQLDictionary || this.dict instanceof MariaDBDictionary)) {
            return;
        }
        String jSql = jSQL.get(0).trim();
        if (jSql.indexOf("optimize for 1 row") != -1) {
            jSql = jSql.substring(0, jSql.indexOf("optimize for 1 row")).trim();
        }
        if (!jSql.equalsIgnoreCase(expectedSQL)) {
            this.printSQL("SQL for JPQL", jSql);
            AbstractCriteriaTestCase.assertTrue((String)("SQL for JPQL " + jSql + " is different than expecetd " + expectedSQL), (boolean)expectedSQL.equalsIgnoreCase(jSql));
        }
    }

    void executeExpectFail(CriteriaQuery<?> c, String jpql) {
        try {
            TypedQuery cQ = this.getEntityManager().createQuery(c);
            this.executeQueryAndCollectSQL((Query)cQ);
            AbstractCriteriaTestCase.fail((String)("CriteriaQuery corresponding to " + jpql + " is expected to fail\r\n"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void executeExpectFail(CriteriaQuery<?> c, String jpql, String[] paramNames, Object[] params) {
        try {
            TypedQuery cQ = this.getEntityManager().createQuery(c);
            for (int i = 0; i < params.length; ++i) {
                cQ.setParameter(paramNames[i], params[i]);
            }
            this.executeQueryAndCollectSQL((Query)cQ);
            AbstractCriteriaTestCase.fail((String)("CriteriaQuery corresponding to " + jpql + " is expected to fail\r\n"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void executeExpectFail(String jpql) {
        try {
            Query jQ = this.getEntityManager().createQuery(jpql);
            this.executeQueryAndCollectSQL(jQ);
            AbstractCriteriaTestCase.fail((String)("JPQL " + jpql + " is expected to Failed to execute\r\n"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void executeExpectFail(String jpql, String[] paramNames, Object[] params) {
        try {
            Query jQ = this.getEntityManager().createQuery(jpql);
            for (int i = 0; i < params.length; ++i) {
                jQ.setParameter(paramNames[i], params[i]);
            }
            this.executeQueryAndCollectSQL(jQ);
            AbstractCriteriaTestCase.fail((String)("JPQL " + jpql + " is expected to Failed to execute\r\n"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void printSQL(String header, String sql) {
        System.err.println(header);
        System.err.println(sql);
    }

    void printSQL(String header, List<String> sqls) {
        System.err.println(header);
        for (int i = 0; sqls != null && i < sqls.size(); ++i) {
            System.err.println(i + ":" + sqls.get(i));
        }
    }

    List<String> executeQueryAndCollectSQL(Query q) {
        this.getAuditor().clear();
        try {
            q.getResultList();
        }
        catch (Exception e) {
            throw new RuntimeException(this.extractSQL(e), e);
        }
        AbstractCriteriaTestCase.assertFalse((boolean)this.getAuditor().getSQLs().isEmpty());
        return this.getAuditor().getSQLs();
    }

    void executeAndCompareSQL(CriteriaQuery<?> q, String expectedSQL) {
        this.executeAndCompareSQL((Query)this.getEntityManager().createQuery(q), expectedSQL);
    }

    String extractSQL(Exception e) {
        Throwable t = e.getCause();
        if (t instanceof ReportingSQLException) {
            return ((ReportingSQLException)t).getSQL();
        }
        return "Can not extract SQL from exception " + e;
    }

    public void runBare() throws Throwable {
        try {
            super.runBare();
        }
        catch (Throwable t) {
            AllowFailure allowFailure = this.getAllowFailure();
            if (allowFailure != null && allowFailure.value()) {
                System.err.println("*** FAILED (but ignored): " + (Object)((Object)this));
                System.err.println("***              Reason : " + allowFailure.message());
                System.err.println("Stacktrace of failure");
                t.printStackTrace();
            }
            throw t;
        }
    }

    protected AllowFailure getAllowFailure() {
        if (Boolean.getBoolean("IgnoreAllowFailure")) {
            return null;
        }
        try {
            Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), null);
            AllowFailure anno = runMethod.getAnnotation(AllowFailure.class);
            if (anno != null) {
                return anno;
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return ((Object)((Object)this)).getClass().getAnnotation(AllowFailure.class);
    }

    public static interface QueryDecorator {
        public void decorate(Query var1);
    }

    public class SQLAuditor
    extends FilteringJDBCListener {
        public SQLAuditor() {
            super(new ArrayList<String>());
        }

        List<String> getSQLs() {
            return this.getCopy();
        }
    }
}

