/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.compat;

import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.compat.Department;
import org.apache.openjpa.persistence.compat.Employee;
import org.apache.openjpa.persistence.compat.FullTimeEmployee;
import org.apache.openjpa.persistence.compat.Invoice;
import org.apache.openjpa.persistence.compat.LineItem;
import org.apache.openjpa.persistence.compat.PartTimeEmployee;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNonPrimaryKeyQueryParameters
extends SQLListenerTestCase {
    private static final int FULLTIME_EMPLOYEE_COUNT = 3;
    private static final int PARTTIME_EMPLOYEE_COUNT = 2;
    private static final int LINEITEM_PER_INVOICE = 1;
    private static final String DEPT_NAME = "ENGINEERING";

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Department.class, Employee.class, FullTimeEmployee.class, PartTimeEmployee.class, Invoice.class, LineItem.class, "openjpa.jdbc.QuerySQLCache", "true");
        this.createDepartment(DEPT_NAME);
        this.createInvoice();
        this.sql.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectQueryWithNoParameter() {
        block11: {
            try (OpenJPAEntityManagerSPI em = this.emf.createEntityManager();){
                Query query = em.createQuery("SELECT d from Department d");
                query.setParameter(1, (Object)DEPT_NAME);
                Department dept = (Department)query.getSingleResult();
                if (OpenJPAVersion.MAJOR_RELEASE == 1 && OpenJPAVersion.MINOR_RELEASE >= 3 || OpenJPAVersion.MAJOR_RELEASE >= 2) {
                    TestNonPrimaryKeyQueryParameters.fail((String)"Test should have failed on OpenJPA 1.3 or above.");
                } else {
                    TestNonPrimaryKeyQueryParameters.assertEquals((int)3, (int)dept.getFullTimeEmployees().size());
                    TestNonPrimaryKeyQueryParameters.assertEquals((int)2, (int)dept.getPartTimeEmployees().size());
                    this.assertSQL(".* AND t0.TYPE = .*");
                }
            }
        }
    }

    private void createDepartment(String deptName) {
        Employee e;
        int i;
        if (this.count(Department.class) > 0) {
            return;
        }
        Department dept = new Department();
        dept.setName(deptName);
        for (i = 1; i <= 3; ++i) {
            e = new FullTimeEmployee();
            e.setSsn("888-PP-001" + i);
            ((FullTimeEmployee)e).setSalary(100000.0);
            dept.addEmployee((FullTimeEmployee)e);
        }
        for (i = 1; i <= 2; ++i) {
            e = new PartTimeEmployee();
            e.setSsn("999-PP-001" + i);
            ((PartTimeEmployee)e).setHourlyWage(20.0);
            dept.addEmployee((PartTimeEmployee)e);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)dept);
        em.getTransaction().commit();
        em.close();
    }

    private void createInvoice() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Invoice invoice = new Invoice(1, "Red", 1.3);
        for (int i = 1; i <= 1; ++i) {
            LineItem item = new LineItem(String.valueOf(i), 10);
            item.setInvoice(invoice);
            invoice.getLineItems().add(item);
        }
        em.persist((Object)invoice);
        tran.commit();
        em.close();
    }
}

