/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.common.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.AssertionFailedError;

public class Bug
extends AssertionFailedError {
    private static final long serialVersionUID = 1L;
    public static final String BUG_TOKEN = "SOLARBUG";
    public static final String BUG_DELIMITER = "|";
    private Throwable error = null;
    private int trackingId;

    private Bug(int trackingId, Throwable t, String message) {
        super("|SOLARBUG|" + trackingId + BUG_DELIMITER + message);
        this.trackingId = trackingId;
        this.error = t;
        this.printStackTrace(System.err);
    }

    public static Bug bug(int trackingId, Throwable t, String message) {
        return new Bug(trackingId, t, message);
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this.error != null) {
            pw.println("Embedded error message:");
            this.error.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (this.error != null) {
            ps.println("Embedded error message:");
            this.error.printStackTrace(ps);
        }
    }

    public String getMessage() {
        return super.getMessage() + " [reported bug #" + this.trackingId + "]";
    }

    public int getTrackingId() {
        return this.trackingId;
    }
}

