/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cascade.pudefault;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.cascade.pudefault.AnEmbeddable;
import org.apache.openjpa.persistence.cascade.pudefault.EmbeddableWithRelationships;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityA01;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityA02;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityAE01;
import org.apache.openjpa.persistence.cascade.pudefault.PUDEntityB;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNoPUDefaultCascadePersist
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(PUDEntityA01.class, PUDEntityA02.class, PUDEntityAE01.class, PUDEntityB.class, AnEmbeddable.class, EmbeddableWithRelationships.class, CLEAR_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2M() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColM2M().add(b);
            }
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2M() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColO2M().add(b);
            }
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2O() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setO2o(b);
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2O() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityA01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityA01();
            entity.setStrData("PUDEntityA01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setM2o(b);
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2MWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColM2M().add(b);
            }
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2MWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            for (int i = 0; i < 10; ++i) {
                PUDEntityB b = new PUDEntityB();
                b.setStrData("B");
                entity.getColO2M().add(b);
            }
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverO2OWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setO2o(b);
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPUDefaultCascadePersistOverM2OWithEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PUDEntityAE01 entity = null;
        try {
            em.getTransaction().begin();
            entity = new PUDEntityAE01();
            entity.setStrData("PUDEntityAE01");
            PUDEntityB b = new PUDEntityB();
            b.setStrData("B");
            entity.setM2o(b);
            em.persist((Object)entity);
            try {
                em.getTransaction().commit();
                TestNoPUDefaultCascadePersist.fail((String)"No Exception thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

