/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cascade;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.cascade.Edge;
import org.apache.openjpa.persistence.cascade.VertexType;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity
@NamedQueries(value={@NamedQuery(name="Vertex.findByName", query="SELECT n FROM Vertex n where n.type.name=?1"), @NamedQuery(name="Vertex.findAll", query="SELECT n FROM Vertex n")})
public class Vertex
implements PersistenceCapable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long oid;
    @OneToMany(mappedBy="source", cascade={CascadeType.ALL})
    private List<Edge> outgoing;
    @OneToMany(mappedBy="target", cascade={CascadeType.ALL})
    private List<Edge> incoming = new ArrayList<Edge>();
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="TYPE_OID")
    private VertexType type;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$cascade$VertexType;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$cascade$Vertex;
    private transient Object pcDetachedState;

    protected Vertex() {
        this.outgoing = new ArrayList<Edge>();
    }

    public Vertex(VertexType type) {
        this();
        this.type = type;
        type.instances.add(this);
    }

    public Edge newEdge(Vertex target) {
        Edge t = new Edge(this);
        Vertex.pcGetoutgoing(this).add(t);
        t.setTarget(target);
        return t;
    }

    public long getOid() {
        return Vertex.pcGetoid(this);
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"incoming", "oid", "outgoing", "type"};
        Class[] classArray = new Class[4];
        Class clazz = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Vertex.class$("java.util.List"));
        classArray[0] = clazz;
        classArray[1] = Long.TYPE;
        classArray[2] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Vertex.class$("java.util.List"));
        Class clazz2 = class$Lorg$apache$openjpa$persistence$cascade$VertexType != null ? class$Lorg$apache$openjpa$persistence$cascade$VertexType : (class$Lorg$apache$openjpa$persistence$cascade$VertexType = Vertex.class$("org.apache.openjpa.persistence.cascade.VertexType"));
        classArray[3] = clazz2;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 26, 5, 10};
        Class clazz3 = class$Lorg$apache$openjpa$persistence$cascade$Vertex != null ? class$Lorg$apache$openjpa$persistence$cascade$Vertex : (class$Lorg$apache$openjpa$persistence$cascade$Vertex = Vertex.class$("org.apache.openjpa.persistence.cascade.Vertex"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Vertex", (PersistenceCapable)new Vertex());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.incoming = null;
        this.oid = 0L;
        this.outgoing = null;
        this.type = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Vertex vertex = new Vertex();
        if (bl) {
            vertex.pcClearFields();
        }
        vertex.pcStateManager = stateManager;
        vertex.pcCopyKeyFieldsFromObjectId(object);
        return vertex;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Vertex vertex = new Vertex();
        if (bl) {
            vertex.pcClearFields();
        }
        vertex.pcStateManager = stateManager;
        return vertex;
    }

    protected static int pcGetManagedFieldCount() {
        return 4;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.incoming = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.oid = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.outgoing = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.type = (VertexType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.incoming);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.oid);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.outgoing);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Vertex vertex, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.incoming = vertex.incoming;
                return;
            }
            case 1: {
                this.oid = vertex.oid;
                return;
            }
            case 2: {
                this.outgoing = vertex.outgoing;
                return;
            }
            case 3: {
                this.type = vertex.type;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        Vertex vertex = (Vertex)object;
        if (vertex.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(vertex, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(1 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.oid = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$cascade$Vertex != null ? class$Lorg$apache$openjpa$persistence$cascade$Vertex : (class$Lorg$apache$openjpa$persistence$cascade$Vertex = Vertex.class$("org.apache.openjpa.persistence.cascade.Vertex"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$cascade$Vertex != null ? class$Lorg$apache$openjpa$persistence$cascade$Vertex : (class$Lorg$apache$openjpa$persistence$cascade$Vertex = Vertex.class$("org.apache.openjpa.persistence.cascade.Vertex"));
        return new LongId(clazz, this.oid);
    }

    private static final List pcGetincoming(Vertex vertex) {
        if (vertex.pcStateManager == null) {
            return vertex.incoming;
        }
        int n = pcInheritedFieldCount + 0;
        vertex.pcStateManager.accessingField(n);
        return vertex.incoming;
    }

    private static final void pcSetincoming(Vertex vertex, List list) {
        if (vertex.pcStateManager == null) {
            vertex.incoming = list;
            return;
        }
        vertex.pcStateManager.settingObjectField((PersistenceCapable)vertex, pcInheritedFieldCount + 0, vertex.incoming, (Object)list, 0);
    }

    private static final long pcGetoid(Vertex vertex) {
        if (vertex.pcStateManager == null) {
            return vertex.oid;
        }
        int n = pcInheritedFieldCount + 1;
        vertex.pcStateManager.accessingField(n);
        return vertex.oid;
    }

    private static final void pcSetoid(Vertex vertex, long l) {
        if (vertex.pcStateManager == null) {
            vertex.oid = l;
            return;
        }
        vertex.pcStateManager.settingLongField((PersistenceCapable)vertex, pcInheritedFieldCount + 1, vertex.oid, l, 0);
    }

    private static final List pcGetoutgoing(Vertex vertex) {
        if (vertex.pcStateManager == null) {
            return vertex.outgoing;
        }
        int n = pcInheritedFieldCount + 2;
        vertex.pcStateManager.accessingField(n);
        return vertex.outgoing;
    }

    private static final void pcSetoutgoing(Vertex vertex, List list) {
        if (vertex.pcStateManager == null) {
            vertex.outgoing = list;
            return;
        }
        vertex.pcStateManager.settingObjectField((PersistenceCapable)vertex, pcInheritedFieldCount + 2, vertex.outgoing, (Object)list, 0);
    }

    private static final VertexType pcGettype(Vertex vertex) {
        if (vertex.pcStateManager == null) {
            return vertex.type;
        }
        int n = pcInheritedFieldCount + 3;
        vertex.pcStateManager.accessingField(n);
        return vertex.type;
    }

    private static final void pcSettype(Vertex vertex, VertexType vertexType) {
        if (vertex.pcStateManager == null) {
            vertex.type = vertexType;
            return;
        }
        vertex.pcStateManager.settingObjectField((PersistenceCapable)vertex, pcInheritedFieldCount + 3, (Object)vertex.type, (Object)vertexType, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.oid != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

