/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.callbacks.ListenerImpl;
import org.apache.openjpa.persistence.callbacks.ListenerTestEntity;
import org.apache.openjpa.persistence.callbacks.MSCListenerEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMSCEntityListeners
extends SingleEMFTestCase {
    private static final int MSC_LISTENER_ENTITY = 4;

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES);
        ListenerImpl.prePersistCount = 0;
        ListenerImpl.postPersistCount = 0;
        ListenerImpl.preUpdateCount = 0;
        ListenerImpl.postUpdateCount = 0;
        ListenerImpl.preRemoveCount = 0;
        ListenerImpl.postRemoveCount = 0;
        ListenerImpl.postLoadCount = 0;
    }

    @Override
    protected String getPersistenceUnitName() {
        return "msclistener-pu";
    }

    public void testMSCEntityListeners() {
        this.helper(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helper(int entityListeners) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            ListenerTestEntity o = null;
            switch (entityListeners) {
                case 4: {
                    o = new MSCListenerEntity();
                }
            }
            em.persist(o);
            this.assertStatus(1, 0, 0, 0, 0, 0, 0);
            em.getTransaction().commit();
            long id = o.getId();
            em.close();
            this.assertStatus(1, 1, 0, 0, 0, 0, 0);
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            switch (entityListeners) {
                case 4: {
                    o = (ListenerTestEntity)em.find(MSCListenerEntity.class, (Object)id);
                }
            }
            TestMSCEntityListeners.assertNotNull((Object)o);
            this.assertStatus(1, 1, 0, 0, 0, 0, 1);
            o.setValue(o.getValue() + 1);
            em.flush();
            this.assertStatus(1, 1, 1, 1, 0, 0, 1);
            em.remove((Object)o);
            this.assertStatus(1, 1, 1, 1, 1, 0, 1);
            em.getTransaction().commit();
            this.assertStatus(1, 1, 1, 1, 1, 1, 1);
            em.close();
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private void assertStatus(int prePersist, int postPersist, int preUpdate, int postUpdate, int preRemove, int postRemove, int postLoad) {
        TestMSCEntityListeners.assertEquals((int)prePersist, (int)ListenerImpl.prePersistCount);
        TestMSCEntityListeners.assertEquals((int)postPersist, (int)ListenerImpl.postPersistCount);
        TestMSCEntityListeners.assertEquals((int)preUpdate, (int)ListenerImpl.preUpdateCount);
        TestMSCEntityListeners.assertEquals((int)postUpdate, (int)ListenerImpl.postUpdateCount);
        TestMSCEntityListeners.assertEquals((int)preRemove, (int)ListenerImpl.preRemoveCount);
        TestMSCEntityListeners.assertEquals((int)postRemove, (int)ListenerImpl.postRemoveCount);
        TestMSCEntityListeners.assertEquals((int)postLoad, (int)ListenerImpl.postLoadCount);
    }
}

