/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.callbacks.DuplicateListenerEntity;
import org.apache.openjpa.persistence.callbacks.EntityListenerEntity;
import org.apache.openjpa.persistence.callbacks.GlobalListenerEntity;
import org.apache.openjpa.persistence.callbacks.ListenerImpl;
import org.apache.openjpa.persistence.callbacks.ListenerTestEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEntityListeners
extends SingleEMFTestCase {
    private static final int ENTITY_LISTENER_ENTITY = 1;
    private static final int GLOBAL_LISTENER_ENTITY = 2;
    private static final int DUPLICATE_LISTENER_ENTITY = 3;

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES);
        ListenerImpl.prePersistCount = 0;
        ListenerImpl.postPersistCount = 0;
        ListenerImpl.preUpdateCount = 0;
        ListenerImpl.postUpdateCount = 0;
        ListenerImpl.preRemoveCount = 0;
        ListenerImpl.postRemoveCount = 0;
        ListenerImpl.postLoadCount = 0;
    }

    @Override
    protected String getPersistenceUnitName() {
        return "listener-pu";
    }

    public void testEntityListeners() {
        this.helper(1);
    }

    public void testGlobalListeners() {
        this.helper(2);
    }

    public void testDuplicateListeners() {
        super.setUp(CLEAR_TABLES, DuplicateListenerEntity.class, "openjpa.Callbacks", "AllowsDuplicateListener=false");
        TestEntityListeners.assertFalse((boolean)this.emf.getConfiguration().getCallbackOptionsInstance().getAllowsDuplicateListener());
        this.helper(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helper(int entityListeners) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            ListenerTestEntity o = null;
            switch (entityListeners) {
                case 1: {
                    o = new EntityListenerEntity();
                    break;
                }
                case 2: {
                    o = new GlobalListenerEntity();
                    break;
                }
                case 3: {
                    o = new DuplicateListenerEntity();
                }
            }
            em.persist(o);
            this.assertStatus(1, 0, 0, 0, 0, 0, 0);
            em.getTransaction().commit();
            long id = o.getId();
            em.close();
            this.assertStatus(1, 1, 0, 0, 0, 0, 0);
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            switch (entityListeners) {
                case 1: {
                    o = (ListenerTestEntity)em.find(EntityListenerEntity.class, (Object)id);
                    break;
                }
                case 2: {
                    o = (ListenerTestEntity)em.find(GlobalListenerEntity.class, (Object)id);
                    break;
                }
                case 3: {
                    o = (ListenerTestEntity)em.find(DuplicateListenerEntity.class, (Object)id);
                }
            }
            TestEntityListeners.assertNotNull((Object)o);
            this.assertStatus(1, 1, 0, 0, 0, 0, 1);
            o.setValue(o.getValue() + 1);
            em.flush();
            this.assertStatus(1, 1, 1, 1, 0, 0, 1);
            em.remove((Object)o);
            this.assertStatus(1, 1, 1, 1, 1, 0, 1);
            em.getTransaction().commit();
            this.assertStatus(1, 1, 1, 1, 1, 1, 1);
            em.close();
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private void assertStatus(int prePersist, int postPersist, int preUpdate, int postUpdate, int preRemove, int postRemove, int postLoad) {
        TestEntityListeners.assertEquals((int)prePersist, (int)ListenerImpl.prePersistCount);
        TestEntityListeners.assertEquals((int)postPersist, (int)ListenerImpl.postPersistCount);
        TestEntityListeners.assertEquals((int)preUpdate, (int)ListenerImpl.preUpdateCount);
        TestEntityListeners.assertEquals((int)postUpdate, (int)ListenerImpl.postUpdateCount);
        TestEntityListeners.assertEquals((int)preRemove, (int)ListenerImpl.preRemoveCount);
        TestEntityListeners.assertEquals((int)postRemove, (int)ListenerImpl.postRemoveCount);
        TestEntityListeners.assertEquals((int)postLoad, (int)ListenerImpl.postLoadCount);
    }
}

