/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.callbacks.PostLoadListenerEntity;
import org.apache.openjpa.persistence.callbacks.PostLoadListenerImpl;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class EntityListenerPostLoadTest
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "listener-pu";
    }

    public void testPostLoadValues() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            PostLoadListenerEntity entity = null;
            entity = new PostLoadListenerEntity();
            entity.setValue("val1");
            em.persist((Object)entity);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            EntityListenerPostLoadTest.assertTrue((boolean)em.isDetached((Object)entity));
            em.getTransaction().begin();
            entity = (PostLoadListenerEntity)em.find(PostLoadListenerEntity.class, (Object)entity.getId());
            EntityListenerPostLoadTest.assertNotNull((Object)entity);
            EntityListenerPostLoadTest.assertEquals((String)"val1", (String)PostLoadListenerImpl.postLoadValue);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            EntityListenerPostLoadTest.assertTrue((boolean)em.isDetached((Object)entity));
            entity.setValue("val2");
            entity = (PostLoadListenerEntity)em.merge((Object)entity);
            EntityListenerPostLoadTest.assertEquals((String)"val1", (String)PostLoadListenerImpl.postLoadValue);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            entity.setValue("val3");
            entity = (PostLoadListenerEntity)em.merge((Object)entity);
            EntityListenerPostLoadTest.assertEquals((String)"val2", (String)PostLoadListenerImpl.postLoadValue);
            em.getTransaction().commit();
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }
}

