/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.util.HashMap;
import java.util.Random;
import javax.persistence.Cache;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockModeType;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.cache.jpa.model.CacheableEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultiEMFCacheModes
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, CacheableEntity.class, "openjpa.ConnectionFactoryProperties", "PrintParameters=true", "openjpa.DataCache", "true");
    }

    public void testCacheRefreshModeRefresh() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CacheableEntity ce = this.createEntity((EntityManager)em);
        int ceid = ce.getId();
        em.clear();
        Cache cache = this.emf.getCache();
        cache.evictAll();
        TestMultiEMFCacheModes.assertFalse((boolean)cache.contains(CacheableEntity.class, (Object)ceid));
        em.getTransaction().begin();
        ce = (CacheableEntity)em.find(CacheableEntity.class, (Object)ceid);
        TestMultiEMFCacheModes.assertTrue((boolean)em.contains((Object)ce));
        TestMultiEMFCacheModes.assertTrue((boolean)cache.contains(CacheableEntity.class, (Object)ceid));
        TestMultiEMFCacheModes.assertTrue((em.getLockMode((Object)ce) == LockModeType.NONE ? 1 : 0) != 0);
        TestMultiEMFCacheModes.assertEquals((String)ce.getName(), (String)"Cached Entity");
        TestMultiEMFCacheModes.assertEquals((int)ce.getVersion(), (int)1);
        em.getTransaction().commit();
        OpenJPAEntityManagerFactorySPI emf2 = this.createEMF(CacheableEntity.class, "openjpa.LockManager", "mixed", "openjpa.ConnectionFactoryProperties", "PrintParameters=true");
        EntityManager em2 = emf2.createEntityManager();
        em2.getTransaction().begin();
        CacheableEntity ce2 = (CacheableEntity)em2.find(CacheableEntity.class, (Object)ceid, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        ce2.setName("Updated Cached Entity");
        em2.getTransaction().commit();
        em2.close();
        emf2.close();
        HashMap<String, CacheStoreMode> cacheStoreModeMap = new HashMap<String, CacheStoreMode>();
        cacheStoreModeMap.put("javax.persistence.cache.storeMode", CacheStoreMode.REFRESH);
        em.refresh((Object)ce, cacheStoreModeMap);
        this.verifyUpdatedEntity(ce, ceid);
        ce = (CacheableEntity)em.find(CacheableEntity.class, (Object)ceid);
        this.verifyUpdatedEntity(ce, ceid);
        em.clear();
        TestMultiEMFCacheModes.assertTrue((boolean)cache.contains(CacheableEntity.class, (Object)ceid));
        ce = (CacheableEntity)em.find(CacheableEntity.class, (Object)ceid);
        this.verifyUpdatedEntity(ce, ceid);
        em.close();
    }

    public void testCacheRefreshModeRefreshDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CacheableEntity ce = this.createEntity((EntityManager)em);
        int ceid = ce.getId();
        Cache cache = this.emf.getCache();
        cache.evictAll();
        TestMultiEMFCacheModes.assertFalse((boolean)cache.contains(CacheableEntity.class, (Object)ceid));
        em.getTransaction().begin();
        ce = (CacheableEntity)em.find(CacheableEntity.class, (Object)ceid);
        TestMultiEMFCacheModes.assertTrue((boolean)em.contains((Object)ce));
        TestMultiEMFCacheModes.assertTrue((boolean)cache.contains(CacheableEntity.class, (Object)ceid));
        TestMultiEMFCacheModes.assertTrue((em.getLockMode((Object)ce) == LockModeType.NONE ? 1 : 0) != 0);
        TestMultiEMFCacheModes.assertEquals((String)ce.getName(), (String)"Cached Entity");
        TestMultiEMFCacheModes.assertEquals((int)ce.getVersion(), (int)1);
        em.getTransaction().commit();
        OpenJPAEntityManagerFactorySPI emf2 = this.createEMF(CacheableEntity.class, "openjpa.LockManager", "mixed", "openjpa.ConnectionFactoryProperties", "PrintParameters=true");
        EntityManager em2 = emf2.createEntityManager();
        em2.getTransaction().begin();
        CacheableEntity ce2 = (CacheableEntity)em2.find(CacheableEntity.class, (Object)ceid);
        TestMultiEMFCacheModes.assertNotNull((Object)ce2);
        em2.remove((Object)ce2);
        em2.getTransaction().commit();
        em2.close();
        emf2.close();
        HashMap<String, CacheStoreMode> cacheStoreModeMap = new HashMap<String, CacheStoreMode>();
        cacheStoreModeMap.put("javax.persistence.cache.storeMode", CacheStoreMode.REFRESH);
        try {
            em.refresh((Object)ce, cacheStoreModeMap);
            TestMultiEMFCacheModes.fail((String)"Refresh operation should have thrown an exception");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        try {
            ce = (CacheableEntity)em.find(CacheableEntity.class, (Object)ceid);
            TestMultiEMFCacheModes.fail((String)"OpenJPA should have detected the removed entity");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        em.clear();
        TestMultiEMFCacheModes.assertFalse((boolean)cache.contains(CacheableEntity.class, (Object)ceid));
        ce = (CacheableEntity)em.find(CacheableEntity.class, (Object)ceid);
        TestMultiEMFCacheModes.assertNull((Object)ce);
        em.close();
    }

    private CacheableEntity createEntity(EntityManager em) {
        CacheableEntity ce = new CacheableEntity();
        int ceid = new Random().nextInt();
        ce.setId(ceid);
        ce.setName("Cached Entity");
        em.getTransaction().begin();
        em.persist((Object)ce);
        em.getTransaction().commit();
        em.clear();
        return ce;
    }

    private void verifyUpdatedEntity(CacheableEntity ce, int id) {
        TestMultiEMFCacheModes.assertEquals((int)id, (int)ce.getId());
        TestMultiEMFCacheModes.assertEquals((String)"Updated Cached Entity", (String)ce.getName());
        TestMultiEMFCacheModes.assertEquals((int)2, (int)ce.getVersion());
    }
}

