/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Cache;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.cache.jpa.AbstractCacheModeTestCase;
import org.apache.openjpa.persistence.test.FilteringJDBCListener;

public class TestCacheModeUnspecifiedDataCacheTrue
extends AbstractCacheModeTestCase {
    private static Cache cache = null;
    private static List<String> sql = new ArrayList<String>();
    private static JDBCListener listener;
    private static Class<?>[] expectedInCache;
    private static Class<?>[] expectedNotInCache;

    @Override
    public OpenJPAEntityManagerFactorySPI getEntityManagerFactory() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("openjpa.DataCache", "true");
        props.put("openjpa.RemoteCommitProvider", "sjvm");
        if (emf == null) {
            emf = this.createEntityManagerFactory("cache-mode-unspecified", props);
            TestCacheModeUnspecifiedDataCacheTrue.assertNotNull((Object)emf);
            cache = emf.getCache();
            TestCacheModeUnspecifiedDataCacheTrue.assertNotNull((Object)cache);
        }
        return emf;
    }

    @Override
    public JDBCListener getListener() {
        if (listener == null) {
            listener = new FilteringJDBCListener(this.getSql());
        }
        return listener;
    }

    @Override
    public List<String> getSql() {
        return sql;
    }

    public void testCacheables() {
        this.assertCacheables(cache, true);
    }

    public void testUncacheables() {
        this.assertUncacheables(cache, true);
    }

    public void testUnspecified() {
        this.assertUnspecified(cache, true);
    }

    @Override
    protected Class<?>[] getExpectedInCache() {
        return expectedInCache;
    }

    @Override
    protected Class<?>[] getExpectedNotInCache() {
        return expectedNotInCache;
    }

    static {
        expectedInCache = persistentTypes;
        expectedNotInCache = new Class[0];
    }
}

