/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.util.List;
import javax.persistence.Cache;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import junit.framework.TestCase;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.cache.jpa.AbstractCacheTestCase;
import org.apache.openjpa.persistence.cache.jpa.model.CacheEntity;
import org.apache.openjpa.persistence.cache.jpa.model.CacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.NegatedCachableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.NegatedUncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UnspecifiedEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlCacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlUncacheableEntity;

public abstract class AbstractCacheModeTestCase
extends AbstractCacheTestCase {
    @Override
    public abstract OpenJPAEntityManagerFactorySPI getEntityManagerFactory();

    public abstract List<String> getSql();

    protected abstract Class<?>[] getExpectedNotInCache();

    protected abstract Class<?>[] getExpectedInCache();

    protected void assertCacheContents(Cache cache, boolean expectCacheables, boolean expectUncacheables, boolean expectUnspecified) {
        this.assertCacheables(cache, expectCacheables);
        this.assertUncacheables(cache, expectUncacheables);
        this.assertUnspecified(cache, expectUnspecified);
    }

    protected void assertCacheables(Cache cache, boolean expected) {
        this.assertCached(cache, CacheableEntity.class, 1, expected);
        this.assertCached(cache, NegatedUncacheableEntity.class, 1, expected);
        this.assertCached(cache, XmlCacheableEntity.class, 1, expected);
    }

    protected void assertUncacheables(Cache cache, boolean expected) {
        this.assertCached(cache, UncacheableEntity.class, 1, expected);
        this.assertCached(cache, XmlUncacheableEntity.class, 1, expected);
        this.assertCached(cache, NegatedCachableEntity.class, 1, expected);
    }

    protected void assertUnspecified(Cache cache, boolean expected) {
        this.assertCached(cache, UnspecifiedEntity.class, 1, expected);
    }

    public void assertNoSql(Action act) {
        this.assertSqlInc(act, 0);
    }

    public void assertSqlInc(Action act, int expectedSqls) {
        int before = this.getSql().size();
        act.run();
        AbstractCacheModeTestCase.assertEquals((int)(before + expectedSqls), (int)this.getSql().size());
    }

    public boolean getCacheEnabled() {
        return true;
    }

    public void testReadModeByass() {
        this.assertSqlInc(new Action(){

            @Override
            public void run() {
                OpenJPAEntityManagerSPI em = AbstractCacheModeTestCase.this.getEntityManagerFactory().createEntityManager();
                em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.BYPASS);
                for (Class<?> cls : AbstractCacheTestCase.persistentTypes) {
                    em.find(cls, (Object)1);
                }
                em.close();
            }
        }, persistentTypes.length);
    }

    public void testRetrieveModeUse() {
        if (this.getCacheEnabled()) {
            this.assertNoSql(new Action(){

                @Override
                public void run() {
                    OpenJPAEntityManagerSPI em = AbstractCacheModeTestCase.this.getEntityManagerFactory().createEntityManager();
                    em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
                    for (Class<?> cls : AbstractCacheModeTestCase.this.getExpectedInCache()) {
                        AbstractCacheModeTestCase.this.assertCached(AbstractCacheModeTestCase.this.getEntityManagerFactory().getCache(), cls, 1, true);
                        TestCase.assertNotNull((Object)em.find(cls, (Object)1));
                    }
                    em.close();
                }
            });
            this.assertSqlInc(new Action(){

                @Override
                public void run() {
                    OpenJPAEntityManagerSPI em = AbstractCacheModeTestCase.this.getEntityManagerFactory().createEntityManager();
                    em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
                    for (Class<?> cls : AbstractCacheModeTestCase.this.getExpectedNotInCache()) {
                        AbstractCacheModeTestCase.this.assertCached(AbstractCacheModeTestCase.this.getEntityManagerFactory().getCache(), cls, 1, false);
                        TestCase.assertNotNull((Object)em.find(cls, (Object)1));
                    }
                    em.close();
                }
            }, this.getExpectedNotInCache().length);
        }
    }

    public void updateAndFind(Class<? extends CacheEntity> classToUpdate, int idToUpdate, Class<? extends CacheEntity> classToFind, int idToFind, CacheStoreMode storeMode, CacheRetrieveMode retrieveMode) {
        OpenJPAEntityManagerSPI em = this.getEntityManagerFactory().createEntityManager();
        if (storeMode != null) {
            em.setProperty("javax.persistence.cache.storeMode", (Object)storeMode);
        }
        if (retrieveMode != null) {
            em.setProperty("javax.persistence.cache.retrieveMode", (Object)retrieveMode);
        }
        em.getTransaction().begin();
        CacheEntity ce1 = (CacheEntity)em.find(classToUpdate, (Object)idToUpdate);
        CacheEntity ce2 = (CacheEntity)em.find(classToFind, (Object)idToFind);
        AbstractCacheModeTestCase.assertNotNull((Object)ce1);
        AbstractCacheModeTestCase.assertNotNull((Object)ce2);
        ce1.setName(ce1.getName() + "UPD");
        em.getTransaction().commit();
        em.close();
    }

    public void entityManagerStoreModeTest(CacheStoreMode tran1StoreMode, CacheStoreMode tran2StoreMode, boolean cacheUpdatedForTran1, boolean cacheUpdatedForTran2, int version) {
        this.updateAndFind(CacheableEntity.class, 1, XmlCacheableEntity.class, 1, tran1StoreMode, null);
        this.updateAndFind(XmlCacheableEntity.class, 1, CacheableEntity.class, 1, tran2StoreMode, null);
        OpenJPAEntityManagerSPI em = this.getEntityManagerFactory().createEntityManager();
        em = this.getEntityManagerFactory().createEntityManager();
        CacheableEntity ceFromEM = (CacheableEntity)em.find(CacheableEntity.class, (Object)1);
        XmlCacheableEntity xceFromEM = (XmlCacheableEntity)em.find(XmlCacheableEntity.class, (Object)1);
        em.close();
        AbstractCacheModeTestCase.assertEquals((int)(cacheUpdatedForTran1 ? version + 1 : version), (int)ceFromEM.getVersion());
        AbstractCacheModeTestCase.assertEquals((int)(cacheUpdatedForTran2 ? version + 1 : version), (int)xceFromEM.getVersion());
        em = this.getEntityManagerFactory().createEntityManager();
        em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.BYPASS);
        CacheableEntity ceFromDB = (CacheableEntity)em.createNativeQuery("Select * from CacheableEntity where ID = 1", CacheableEntity.class).getSingleResult();
        XmlCacheableEntity xceFromDB = (XmlCacheableEntity)em.createNativeQuery("Select * from XmlCacheableEntity where ID = 1", XmlCacheableEntity.class).getSingleResult();
        AbstractCacheModeTestCase.assertEquals((int)(version + 1), (int)ceFromDB.getVersion());
        AbstractCacheModeTestCase.assertEquals((int)(version + 1), (int)xceFromDB.getVersion());
        em.close();
    }

    public void testStoreModeUseBypass() throws Exception {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.USE, CacheStoreMode.BYPASS, true, false, 1);
        }
    }

    public void testStoreModeUseUse() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.USE, CacheStoreMode.USE, true, true, 1);
        }
    }

    public void testRefresh() {
        if (this.getCacheEnabled()) {
            OpenJPAEntityManagerSPI em = this.getEntityManagerFactory().createEntityManager();
            CacheableEntity e1 = (CacheableEntity)em.find(CacheableEntity.class, (Object)1);
            XmlCacheableEntity e2 = (XmlCacheableEntity)em.find(XmlCacheableEntity.class, (Object)1);
            AbstractCacheModeTestCase.assertNotNull((Object)e1);
            AbstractCacheModeTestCase.assertNotNull((Object)e2);
            int e1Version = e1.getVersion();
            int e2Version = e2.getVersion();
            String e1Sql = "UPDATE CacheableEntity SET VERSN=?1 WHERE ID=?2";
            String e2Sql = "UPDATE XmlCacheableEntity SET VERSN=?1 WHERE ID=?2";
            em.getTransaction().begin();
            AbstractCacheModeTestCase.assertEquals((int)1, (int)em.createNativeQuery(e1Sql).setParameter(1, (Object)(e1Version + 1)).setParameter(2, (Object)e1.getId()).executeUpdate());
            AbstractCacheModeTestCase.assertEquals((int)1, (int)em.createNativeQuery(e2Sql).setParameter(1, (Object)(e2Version + 1)).setParameter(2, (Object)e2.getId()).executeUpdate());
            em.getTransaction().commit();
            em.refresh((Object)e1);
            em.refresh((Object)e2);
            AbstractCacheModeTestCase.assertEquals((int)(e1Version + 1), (int)e1.getVersion());
            AbstractCacheModeTestCase.assertEquals((int)(e2Version + 1), (int)e2.getVersion());
            em.close();
        }
    }

    public void testStoreModeUseRefresh() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.USE, CacheStoreMode.REFRESH, true, true, 1);
        }
    }

    public void entityManagerStoreModeTest() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.BYPASS, CacheStoreMode.BYPASS, false, false, 1);
        }
    }

    public void testStoreModeBypassUse() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.BYPASS, CacheStoreMode.USE, false, true, 1);
        }
    }

    public void testStoreModeBypassRefresh() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.BYPASS, CacheStoreMode.REFRESH, true, true, 1);
        }
    }

    public void testStoreModeRefreshUse() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.REFRESH, CacheStoreMode.USE, true, true, 1);
        }
    }

    public void testStoreModeRefreshBypass() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.REFRESH, CacheStoreMode.BYPASS, true, false, 1);
        }
    }

    public void testStoreModeRefreshRefresh() {
        if (this.getCacheEnabled()) {
            this.entityManagerStoreModeTest(CacheStoreMode.REFRESH, CacheStoreMode.REFRESH, true, true, 1);
        }
    }

    public void testResultsFromQueryAreInCache() {
        if (this.getCacheEnabled()) {
            this.getEntityManagerFactory().getStoreCache().evictAll();
            this.getEntityManagerFactory().getQueryResultCache().evictAll();
            OpenJPAEntityManagerSPI em = this.getEntityManagerFactory().createEntityManager();
            for (Class clazz : persistentTypes) {
                String query = "Select e from " + this.getAlias(clazz) + " e";
                List res = em.createQuery(query).getResultList();
                AbstractCacheModeTestCase.assertNotNull((String)String.format("Expected to find some results when running query %s", query), (Object)res);
                AbstractCacheModeTestCase.assertTrue((String)String.format("Expected more than 0 results running query %s", query), (res.size() != 0 ? 1 : 0) != 0);
            }
            for (Class clazz : this.getExpectedInCache()) {
                this.assertCached(this.getEntityManagerFactory().getCache(), clazz, 1, true);
            }
            for (Class clazz : this.getExpectedNotInCache()) {
                this.assertCached(this.getEntityManagerFactory().getCache(), clazz, 1, false);
            }
            em.close();
        }
    }

    public void testResultsFromFindAreInCache() {
        if (this.getCacheEnabled()) {
            this.getEntityManagerFactory().getStoreCache().evictAll();
            this.getEntityManagerFactory().getQueryResultCache().evictAll();
            OpenJPAEntityManagerSPI em = this.getEntityManagerFactory().createEntityManager();
            for (Class clazz : persistentTypes) {
                AbstractCacheModeTestCase.assertNotNull((String)String.format("Expected to find %s::%d from database or from cache", clazz, 1), (Object)em.find(clazz, (Object)1));
            }
            for (Class clazz : this.getExpectedInCache()) {
                this.assertCached(this.getEntityManagerFactory().getCache(), clazz, 1, true);
            }
            for (Class clazz : this.getExpectedNotInCache()) {
                this.assertCached(this.getEntityManagerFactory().getCache(), clazz, 1, false);
            }
            em.close();
        }
    }

    private String getAlias(Class<?> cls) {
        ClassMapping mapping = (ClassMapping)this.getEntityManagerFactory().getConfiguration().getMetaDataRepositoryInstance().getMetaData(cls, null, true);
        return mapping.getTypeAlias();
    }

    public static interface Action {
        public void run();
    }
}

