/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.blob.mysql;

import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.persistence.blob.mysql.BlobColumnEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBlobColumnType
extends SingleEMFTestCase {
    private static boolean _firstRun = true;
    private boolean _runTest = false;

    @Override
    public void setUp() throws Exception {
        super.setUp(new Object[]{null});
        if (!(this.getDBDictionary() instanceof MySQLDictionary) && !(this.getDBDictionary() instanceof MariaDBDictionary)) {
            return;
        }
        this.tearDown();
        this._runTest = true;
        super.setUp(BlobColumnEntity.class, DROP_TABLES, "openjpa.jdbc.SchemaFactory", "native");
        if (_firstRun) {
            this.emf.createEntityManager().close();
            _firstRun = false;
        }
    }

    private Column getCol(String name) {
        ClassMapping mapping = this.getMapping(BlobColumnEntity.class);
        Table t = mapping.getTable();
        Column col = t.getColumn(DBIdentifier.newIdentifier((String)name, (DBIdentifier.DBIdentifierType)DBIdentifier.DBIdentifierType.COLUMN, (boolean)true));
        TestBlobColumnType.assertNotNull((Object)col);
        return col;
    }

    public void testSmallLob() {
        if (this._runTest) {
            TestBlobColumnType.assertEquals((String)"TINYBLOB", (String)this.getCol("smallLob").getTypeIdentifier().getName());
        }
    }

    public void testMedLob() {
        if (this._runTest) {
            TestBlobColumnType.assertEquals((String)"MEDIUMBLOB", (String)this.getCol("medLob").getTypeIdentifier().getName());
        }
    }

    public void testLongBlob() {
        if (this._runTest) {
            TestBlobColumnType.assertEquals((String)"LONGBLOB", (String)this.getCol("longLob").getTypeIdentifier().getName());
        }
    }

    public void testOldLob() {
        if (this._runTest) {
            TestBlobColumnType.assertEquals((String)this.getDBDictionary().blobTypeName, (String)this.getCol("oldLob").getTypeIdentifier().getName());
        }
    }

    public void testDefaultLob() {
        if (this._runTest) {
            TestBlobColumnType.assertEquals((String)this.getDBDictionary().blobTypeName, (String)this.getCol("defaultLob").getTypeIdentifier().getName());
        }
    }

    public void testDefinedLob() {
        if (this._runTest) {
            TestBlobColumnType.assertEquals((String)"BINARY", (String)this.getCol("definedLob").getTypeIdentifier().getName());
        }
    }
}

