/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.batch.exception;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.batch.exception.Ent1;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;
import org.apache.openjpa.util.ExceptionInfo;

public class TestBatchLimitException
extends AbstractPersistenceTestCase {
    static Ent1 expectedFailedObject;
    static Ent1 expectedFailedObjectOracle;
    static boolean isOracle;
    static boolean isPostgres;
    final String expectedFailureMsg = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 200, (String) twohundred]";
    final String expectedFailureMsg18 = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 18, (String) name18]";
    String expectedFailureMsgOracle = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 18, (String) name18]";

    public EntityManagerFactory newEmf(String batchLimit) {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(Ent1.class, "openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)", "openjpa.jdbc.DBDictionary", batchLimit, "openjpa.ConnectionFactoryProperties", "PrintParameters=true", CLEAR_TABLES);
        TestBatchLimitException.assertNotNull((String)"Unable to create EntityManagerFactory", (Object)emf);
        JDBCConfiguration conf = (JDBCConfiguration)emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        isOracle = dict instanceof OracleDictionary;
        isPostgres = dict instanceof PostgresDictionary;
        return emf;
    }

    public void setUp() {
        expectedFailedObject = null;
        expectedFailedObjectOracle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionInFirstBatch() throws Throwable {
        EntityManagerFactory emf = this.newEmf("batchLimit=-1");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new Ent1(1, "one"));
        expectedFailedObject = new Ent1(200, "twohundred");
        em.persist((Object)expectedFailedObject);
        em.persist((Object)new Ent1(5, "five"));
        em.getTransaction().commit();
        em.close();
        EntityManager em2 = emf.createEntityManager();
        em2.getTransaction().begin();
        expectedFailedObjectOracle = new Ent1(18, "name18");
        this.expectedFailureMsgOracle = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 18, (String) name18]";
        em2.persist((Object)expectedFailedObjectOracle);
        em2.persist((Object)new Ent1(2, "two"));
        em2.persist((Object)new Ent1(200, "twohundred"));
        em2.persist((Object)new Ent1(3, "three"));
        em2.persist((Object)new Ent1(1, "one"));
        em2.persist((Object)new Ent1(5, "five"));
        try {
            em2.getTransaction().commit();
        }
        catch (Throwable excp) {
            this.verifyExDetails(excp);
        }
        finally {
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            em2.close();
            this.closeEMF(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionSingleBatchedRow() throws Throwable {
        EntityManagerFactory emf = this.newEmf("batchLimit=-1");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        expectedFailedObjectOracle = expectedFailedObject = new Ent1(200, "twohundred");
        this.expectedFailureMsgOracle = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 200, (String) twohundred]";
        em.persist((Object)expectedFailedObject);
        em.getTransaction().commit();
        em.close();
        EntityManager em2 = emf.createEntityManager();
        em2.getTransaction().begin();
        em2.persist((Object)new Ent1(200, "twohundred"));
        try {
            em2.getTransaction().commit();
        }
        catch (Throwable excp) {
            this.verifyExDetails(excp);
        }
        finally {
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            em2.close();
            this.closeEMF(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionInSecondBatch() throws Throwable {
        EntityManagerFactory emf = this.newEmf("batchLimit=9");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        expectedFailedObjectOracle = expectedFailedObject = new Ent1(200, "twohundred");
        this.expectedFailureMsgOracle = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 200, (String) twohundred]";
        em.persist((Object)expectedFailedObject);
        em.getTransaction().commit();
        em.close();
        EntityManager em2 = emf.createEntityManager();
        em2.getTransaction().begin();
        for (int i = 0; i < 9; ++i) {
            em2.persist((Object)new Ent1(i, "name" + i));
        }
        em2.persist((Object)new Ent1(200, "twohundred"));
        try {
            em2.getTransaction().commit();
        }
        catch (Throwable excp) {
            this.verifyExDetails(excp);
        }
        finally {
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            em2.close();
            this.closeEMF(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionInThirdBatch() throws Throwable {
        int i;
        int batchLimit = 9;
        EntityManagerFactory emf = this.newEmf("batchLimit=9");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        expectedFailedObject = new Ent1(200, "twohundred");
        em.persist((Object)expectedFailedObject);
        em.getTransaction().commit();
        em.close();
        EntityManager em2 = emf.createEntityManager();
        em2.getTransaction().begin();
        for (i = 0; i < 18; ++i) {
            em2.persist((Object)new Ent1(i, "name" + i));
        }
        expectedFailedObjectOracle = new Ent1(i, "name" + i++);
        this.expectedFailureMsgOracle = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 18, (String) name18]";
        em2.persist((Object)expectedFailedObjectOracle);
        em2.persist((Object)new Ent1(i, "name" + i++));
        em2.persist((Object)new Ent1(i, "name" + i++));
        em2.persist((Object)new Ent1(i, "name" + i++));
        em2.persist((Object)new Ent1(200, "twohundred"));
        for (i = 22; i < 36; ++i) {
            em2.persist((Object)new Ent1(i, "name" + i));
        }
        try {
            em2.getTransaction().commit();
        }
        catch (Throwable excp) {
            this.verifyExDetails(excp);
        }
        finally {
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            em2.close();
            this.closeEMF(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSecondExceptionHasRightIndex() throws Throwable {
        int i;
        int batchLimit = 9;
        this.testExceptionInThirdBatch();
        EntityManagerFactory emf = this.newEmf("batchLimit=9");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        for (i = 36; i < 45; ++i) {
            em.persist((Object)new Ent1(i, "name" + i));
        }
        expectedFailedObjectOracle = new Ent1(200, "twohundred");
        this.expectedFailureMsgOracle = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 200, (String) twohundred]";
        em.persist((Object)expectedFailedObjectOracle);
        for (i = 45; i < 63; ++i) {
            em.persist((Object)new Ent1(i, "name" + i));
        }
        try {
            em.getTransaction().commit();
        }
        catch (Throwable excp) {
            this.verifyExDetails(excp);
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
            this.closeEMF(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionWithMultipleCommits() throws Throwable {
        EntityManagerFactory emf = this.newEmf("batchLimit=-1");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new Ent1(1, "one"));
        expectedFailedObject = new Ent1(200, "twohundred");
        em.persist((Object)expectedFailedObject);
        em.persist((Object)new Ent1(5, "five"));
        em.getTransaction().commit();
        em.close();
        EntityManager em2 = emf.createEntityManager();
        em2.getTransaction().begin();
        em2.persist((Object)new Ent1(4, "four"));
        em2.persist((Object)new Ent1(0, "zero"));
        em2.persist((Object)new Ent1(2, "two"));
        em2.persist((Object)new Ent1(3, "three"));
        em2.getTransaction().commit();
        em2.getTransaction().begin();
        expectedFailedObjectOracle = new Ent1(18, "name18");
        this.expectedFailureMsgOracle = "INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 18, (String) name18]";
        em2.persist((Object)expectedFailedObjectOracle);
        em2.persist((Object)new Ent1(6, "six"));
        em2.persist((Object)new Ent1(200, "twohundred"));
        em2.persist((Object)new Ent1(7, "seven"));
        try {
            em2.getTransaction().commit();
        }
        catch (Throwable excp) {
            this.verifyExDetails(excp);
        }
        finally {
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            em2.close();
            this.closeEMF(emf);
        }
    }

    public void verifyExDetails(Throwable excp) throws Throwable {
        this.verifyFailedObject(excp);
        Throwable cause = excp.getCause().getCause();
        this.verifyExMsg(cause.getMessage());
    }

    public void verifyFailedObject(Throwable excp) throws Throwable {
        if (excp instanceof ExceptionInfo) {
            ExceptionInfo e = (ExceptionInfo)excp;
            Ent1 failedObject = (Ent1)e.getFailedObject();
            TestBatchLimitException.assertNotNull((String)"Failed object was null.", (Object)failedObject);
            if (!isOracle && !isPostgres) {
                TestBatchLimitException.assertEquals((Object)expectedFailedObject, (Object)failedObject);
            } else if (isOracle) {
                TestBatchLimitException.assertTrue((failedObject.equals(expectedFailedObject) || failedObject.equals(expectedFailedObjectOracle) ? 1 : 0) != 0);
            } else {
                TestBatchLimitException.assertEquals((Object)expectedFailedObjectOracle, (Object)failedObject);
            }
        } else {
            throw excp;
        }
    }

    public void verifyExMsg(String msg) {
        TestBatchLimitException.assertNotNull((String)"Exception message was null.", (Object)msg);
        if (!isOracle && !isPostgres) {
            TestBatchLimitException.assertTrue((String)("Did not see expected text in message. Expected <INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 200, (String) twohundred]> but was " + msg), (boolean)msg.contains("INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 200, (String) twohundred]"));
        } else if (isOracle) {
            TestBatchLimitException.assertTrue((msg.contains("INSERT INTO Ent1 (pk, name) VALUES (?, ?) [params=(int) 200, (String) twohundred]") || msg.contains(this.expectedFailureMsgOracle) ? 1 : 0) != 0);
        } else {
            TestBatchLimitException.assertTrue((String)("Did not see expected text in message. Expected <" + this.expectedFailureMsgOracle + "> but was " + msg), (boolean)msg.contains(this.expectedFailureMsgOracle));
        }
    }

    static {
        isOracle = false;
        isPostgres = false;
    }
}

