/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.arrays;

import java.util.ArrayList;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.arrays.model.AnnoExceptionEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestAnnoExceptionEntity
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(AnnoExceptionEntity.class);
    }

    public void testExceptionArrayAsLob() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoExceptionEntity e = new AnnoExceptionEntity();
        e.setId(1);
        em.persist((Object)e);
        e.setExceptions(new ArrayList<Exception>());
        e.getExceptions().add(new Exception("Exception 1"));
        e.getExceptions().add(new Exception("Exception 2"));
        em.getTransaction().commit();
        em.clear();
        e = (AnnoExceptionEntity)em.find(AnnoExceptionEntity.class, (Object)1);
        TestAnnoExceptionEntity.assertNotNull((Object)e);
        TestAnnoExceptionEntity.assertNotNull(e.getExceptions());
        TestAnnoExceptionEntity.assertEquals((int)2, (int)e.getExceptions().size());
        em.getTransaction().begin();
        em.remove((Object)e);
        em.getTransaction().commit();
        em.close();
    }

    public void testExceptionPersistentCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoExceptionEntity e = new AnnoExceptionEntity();
        e.setId(1);
        em.persist((Object)e);
        e.setPersCollExceptions(new ArrayList<Exception>());
        e.getPersCollExceptions().add(new Exception("Exception 1"));
        e.getPersCollExceptions().add(new Exception("Exception 2"));
        em.getTransaction().commit();
        em.clear();
        e = (AnnoExceptionEntity)em.find(AnnoExceptionEntity.class, (Object)1);
        TestAnnoExceptionEntity.assertNotNull((Object)e);
        TestAnnoExceptionEntity.assertNotNull(e.getPersCollExceptions());
        TestAnnoExceptionEntity.assertEquals((int)2, (int)e.getPersCollExceptions().size());
        em.getTransaction().begin();
        em.remove((Object)e);
        em.getTransaction().commit();
        em.close();
    }

    public void testExceptionElementCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoExceptionEntity e = new AnnoExceptionEntity();
        e.setId(1);
        em.persist((Object)e);
        e.setElemCollExceptions(new ArrayList<String>());
        e.getElemCollExceptions().add(new Exception("Exception 1").toString());
        e.getElemCollExceptions().add(new Exception("Exception 2").toString());
        em.getTransaction().commit();
        em.clear();
        e = (AnnoExceptionEntity)em.find(AnnoExceptionEntity.class, (Object)1);
        TestAnnoExceptionEntity.assertNotNull((Object)e);
        TestAnnoExceptionEntity.assertNotNull(e.getElemCollExceptions());
        TestAnnoExceptionEntity.assertEquals((int)2, (int)e.getElemCollExceptions().size());
        em.getTransaction().begin();
        em.remove((Object)e);
        em.getTransaction().commit();
        em.close();
    }
}

