/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbedValue;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.TablePerClass1;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.TablePerClass2;

public class TestTablePerClassInheritance
extends AnnotationTestCase {
    public TestTablePerClassInheritance(String name) {
        super(name, "annotationcactusapp");
    }

    public void testInsertAndRetrieve() {
        this.deleteAll(TablePerClass1.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        TablePerClass1 tpc1 = new TablePerClass1();
        tpc1.setBasic(1);
        EmbedValue ev = new EmbedValue();
        ev.setBasic("11");
        tpc1.setEmbed(ev);
        TablePerClass2 tpc2 = new TablePerClass2();
        tpc2.setBasic(2);
        tpc2.setBasic2("2");
        ev = new EmbedValue();
        ev.setBasic("22");
        tpc2.setEmbed(ev);
        em.persistAll(new Object[]{tpc1, tpc2});
        this.endTx((EntityManager)em);
        int id1 = tpc1.getPk();
        int id2 = tpc2.getPk();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        tpc1 = (TablePerClass1)em.find(TablePerClass1.class, (Object)id1);
        TestTablePerClassInheritance.assertEquals((int)1, (int)tpc1.getBasic());
        TestTablePerClassInheritance.assertEquals((String)"11", (String)tpc1.getEmbed().getBasic());
        tpc2 = (TablePerClass2)em.find(TablePerClass1.class, (Object)id2);
        TestTablePerClassInheritance.assertEquals((int)2, (int)tpc2.getBasic());
        TestTablePerClassInheritance.assertEquals((String)"2", (String)tpc2.getBasic2());
        TestTablePerClassInheritance.assertEquals((String)"22", (String)tpc2.getEmbed().getBasic());
        this.endEm((EntityManager)em);
    }
}

