/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.PropertyAccess1;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestPropertyAccess
extends AnnotationTestCase {
    public TestPropertyAccess(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(PropertyAccess1.class);
    }

    public void testPropertyAccessBasicCreation() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        PropertyAccess1 pa1_1 = new PropertyAccess1(10);
        pa1_1.setName("foo");
        em.persist((Object)pa1_1);
        this.endTx((EntityManager)em);
        em = this.currentEntityManager();
        PropertyAccess1 pa1_2 = (PropertyAccess1)em.find(PropertyAccess1.class, (Object)10);
        TestPropertyAccess.assertNotSame((Object)pa1_1, (Object)pa1_2);
        TestPropertyAccess.assertNotNull((Object)pa1_2);
        TestPropertyAccess.assertEquals((int)10, (int)pa1_2.getId());
        TestPropertyAccess.assertEquals((String)"foo", (String)pa1_2.getName());
    }

    public void testPropertyAccessBasicMutation() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        PropertyAccess1 pa1_1 = new PropertyAccess1(10);
        pa1_1.setName("foo");
        em.persist((Object)pa1_1);
        this.endTx((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        PropertyAccess1 pa1_2 = (PropertyAccess1)em.find(PropertyAccess1.class, (Object)10);
        pa1_2.setName(pa1_2.getName() + "bar");
        this.endTx((EntityManager)em);
        em = this.currentEntityManager();
        PropertyAccess1 pa1_3 = (PropertyAccess1)em.find(PropertyAccess1.class, (Object)10);
        TestPropertyAccess.assertNotSame((Object)pa1_2, (Object)pa1_3);
        TestPropertyAccess.assertEquals((String)"foobar", (String)pa1_3.getName());
    }

    public void testJPQL() {
        OpenJPAEntityManager em = this.currentEntityManager();
        em.createQuery("select o from PropertyAccess1 o where o.name = 'foo'").getResultList();
        em.createQuery("select o from PropertyAccess1 o order by o.name asc").getResultList();
        this.endEm((EntityManager)em);
    }

    public void testJPQLWithFieldNameMismatch() {
        OpenJPAEntityManager em = this.currentEntityManager();
        em.createQuery("select o from PropertyAccess1 o where o.intValue = 0").getResultList();
        em.createQuery("select o from PropertyAccess1 o order by o.intValue asc").getResultList();
        this.endEm((EntityManager)em);
    }
}

