/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.ArrayList;
import java.util.Date;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.PartyId;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Site;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Site1;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Store;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Store1;

public class TestMappedSuperClass
extends AnnotationTestCase {
    public static Long pkey = 1500L;
    public static String pstr = "TestParty";
    public static int ikey = 1501;
    public static PartyId pid = new PartyId(pstr, ikey);

    public TestMappedSuperClass(String name) {
        super(name, "annotationMappedSuperclassApp");
    }

    public void setUp() {
        this.deleteAll(Store.class);
        this.deleteAll(Site.class);
        this.deleteAll(Site1.class);
        this.deleteAll(Store1.class);
    }

    public void testMappedSuperClassSameKeys() {
        this.createSite();
        this.createStore();
    }

    public void testMappedSuperClassIdClass() {
        this.createSite1();
        this.createStore1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSite() {
        OpenJPAEntityManager em = this.currentEntityManager();
        boolean persistSuccess = true;
        try {
            this.startTx((EntityManager)em);
            Site s = new Site();
            s.setPartyId(pkey);
            s.setSiteName("San Jose");
            s.setSiteDescription("San Jose site");
            s.setStatus("2");
            s.setArchiveStatus("2");
            s.setCreateDate(new Date());
            em.persist((Object)s);
            this.endTx((EntityManager)em);
        }
        catch (Exception e) {
            persistSuccess = false;
        }
        finally {
            TestMappedSuperClass.assertTrue((boolean)persistSuccess);
        }
        this.endEm((EntityManager)em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStore() {
        OpenJPAEntityManager em = this.currentEntityManager();
        boolean persistSuccess = true;
        try {
            this.startTx((EntityManager)em);
            Site site = (Site)em.find(Site.class, (Object)pkey);
            Store store = new Store();
            store.setPartyId(pkey);
            store.setStoreDescription("storeDescription");
            store.setStoreName("storeName");
            store.setStatus("1");
            store.setArchiveStatus("1");
            store.setCreateDate(new Date());
            store.setSiteId(site.getPartyId());
            store.setSite(site);
            ArrayList<Store> stores = new ArrayList<Store>();
            stores.add(store);
            site.setStores(stores);
            em.persist((Object)store);
            this.endTx((EntityManager)em);
        }
        catch (Exception e) {
            persistSuccess = false;
        }
        finally {
            TestMappedSuperClass.assertTrue((boolean)persistSuccess);
        }
        this.endEm((EntityManager)em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSite1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        boolean persistSuccess = true;
        try {
            this.startTx((EntityManager)em);
            Site1 s = new Site1();
            s.setId(ikey);
            s.setPartyName(pstr);
            s.setSiteName("San Jose");
            s.setSiteDescription("San Jose site");
            s.setStatus("2");
            s.setArchiveStatus("2");
            s.setCreateDate(new Date());
            em.persist((Object)s);
            this.endTx((EntityManager)em);
        }
        catch (Exception e) {
            persistSuccess = false;
        }
        finally {
            TestMappedSuperClass.assertTrue((boolean)persistSuccess);
        }
        this.endEm((EntityManager)em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStore1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        boolean persistSuccess = true;
        try {
            this.startTx((EntityManager)em);
            Site1 site = (Site1)em.find(Site1.class, (Object)pid);
            Store1 store = new Store1();
            store.setId(ikey);
            store.setPartyName(pstr);
            store.setStoreDescription("storeDescription");
            store.setStoreName("storeName");
            store.setStatus("1");
            store.setArchiveStatus("1");
            store.setCreateDate(new Date());
            store.setSite(site);
            ArrayList<Store1> stores = new ArrayList<Store1>();
            stores.add(store);
            site.setStores(stores);
            em.persist((Object)store);
            this.endTx((EntityManager)em);
        }
        catch (Exception e) {
            persistSuccess = false;
        }
        finally {
            TestMappedSuperClass.assertTrue((boolean)persistSuccess);
        }
        this.endEm((EntityManager)em);
    }
}

