/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest1;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest2;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Flat1;

public class TestMapKey
extends AnnotationTestCase {
    public TestMapKey(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(Flat1.class);
        this.deleteAll(AnnoTest2.class);
        this.deleteAll(AnnoTest1.class);
    }

    public void testInsertAndRetrieve() {
        Flat1 f1 = new Flat1(1);
        f1.setBasic(100);
        Flat1 f2 = new Flat1(2);
        f2.setBasic(200);
        AnnoTest2 a1 = new AnnoTest2(1L, "1");
        a1.setBasic("100");
        AnnoTest2 a2 = new AnnoTest2(2L, "2");
        a2.setBasic("200");
        AnnoTest1 pc = new AnnoTest1(1L);
        pc.getDefaultMapKey().put(f1.getPk(), f1);
        pc.getDefaultMapKey().put(f2.getPk(), f2);
        pc.getNamedMapKey().put(f1.getBasic(), f1);
        pc.getNamedMapKey().put(f2.getBasic(), f2);
        pc.getInverseOwnerMapKey().put(a1.getBasic(), a1);
        pc.getInverseOwnerMapKey().put(a2.getBasic(), a2);
        a1.setOneManyOwner(pc);
        a2.setOneManyOwner(pc);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{pc, f1, f2, a1, a2});
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, em.getObjectId((Object)pc));
        TestMapKey.assertEquals((int)2, (int)pc.getDefaultMapKey().size());
        TestMapKey.assertEquals((int)1, (int)pc.getDefaultMapKey().get(1).getPk());
        TestMapKey.assertEquals((int)2, (int)pc.getDefaultMapKey().get(2).getPk());
        TestMapKey.assertEquals((int)2, (int)pc.getNamedMapKey().size());
        TestMapKey.assertEquals((int)100, (int)pc.getNamedMapKey().get(100).getBasic());
        TestMapKey.assertEquals((int)200, (int)pc.getNamedMapKey().get(200).getBasic());
        TestMapKey.assertEquals((int)2, (int)pc.getInverseOwnerMapKey().size());
        TestMapKey.assertEquals((String)"100", (String)pc.getInverseOwnerMapKey().get("100").getBasic());
        TestMapKey.assertEquals((String)"200", (String)pc.getInverseOwnerMapKey().get("200").getBasic());
        this.endEm((EntityManager)em);
    }
}

