/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest1;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.AnnoTest2;

public class TestManyToMany
extends AnnotationTestCase {
    public TestManyToMany(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(AnnoTest1.class);
        this.deleteAll(AnnoTest2.class);
    }

    public void testManyToMany() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        long lid = 4L;
        AnnoTest1 pc = new AnnoTest1(lid);
        em.persist((Object)pc);
        for (int i = 0; i < 3; ++i) {
            AnnoTest2 pc2 = new AnnoTest2(5 + i, "foo" + i);
            pc.getManyMany().add(pc2);
            em.persist((Object)pc2);
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)lid);
        Set<AnnoTest2> many = pc.getManyMany();
        TestManyToMany.assertEquals((int)3, (int)many.size());
        block6: for (AnnoTest2 manyPc2 : many) {
            switch ((int)manyPc2.getPk1()) {
                case 5: {
                    TestManyToMany.assertEquals((String)"foo0", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 6: {
                    TestManyToMany.assertEquals((String)"foo1", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 7: {
                    TestManyToMany.assertEquals((String)"foo2", (String)manyPc2.getPk2());
                    continue block6;
                }
            }
            TestManyToMany.fail((String)("bad pk:" + manyPc2.getPk1()));
        }
        this.endEm((EntityManager)em);
    }

    public void testInverseOwnerManyToMany() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        long lid = 4L;
        AnnoTest1 pc = new AnnoTest1(lid);
        em.persist((Object)pc);
        for (int i = 0; i < 3; ++i) {
            AnnoTest2 pc2 = new AnnoTest2(5 + i, "foo" + i);
            pc2.getManyMany().add(pc);
            em.persist((Object)pc2);
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)lid);
        Set<AnnoTest2> many = pc.getInverseOwnerManyMany();
        TestManyToMany.assertEquals((int)3, (int)many.size());
        block6: for (AnnoTest2 manyPc2 : many) {
            TestManyToMany.assertTrue((boolean)manyPc2.getManyMany().contains(pc));
            switch ((int)manyPc2.getPk1()) {
                case 5: {
                    TestManyToMany.assertEquals((String)"foo0", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 6: {
                    TestManyToMany.assertEquals((String)"foo1", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 7: {
                    TestManyToMany.assertEquals((String)"foo2", (String)manyPc2.getPk2());
                    continue block6;
                }
            }
            TestManyToMany.fail((String)("bad pk:" + manyPc2.getPk1()));
        }
        this.endEm((EntityManager)em);
    }
}

