/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Generator;

public class TestGenerators
extends AnnotationTestCase {
    public TestGenerators(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() throws Exception {
        this.deleteAll(Generator.class);
    }

    public void testGet() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Generator g = new Generator();
        g.setPk(5);
        em.persist((Object)g);
        this.assertPks(g);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        this.assertNew();
    }

    public void testFlush() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Generator g = new Generator();
        g.setPk(5);
        em.persist((Object)g);
        em.flush();
        this.assertPks(g);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        this.assertNew();
    }

    public void testCommit() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Generator g = new Generator();
        g.setPk(5);
        em.persist((Object)g);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        this.assertNew();
    }

    private void assertNew() {
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAQuery q = em.createQuery("select g from Generator g where g.stringField = 'foo'");
        for (Object o : q.getResultList()) {
            this.assertPks((Generator)o);
        }
        this.endEm((EntityManager)em);
    }

    private void assertPks(Generator g) {
        this.assertNotEquals(0L, g.getPk());
        TestGenerators.assertNotNull((Object)g.getPk2());
        this.assertNotEquals(0L, g.getPk3());
    }

    private boolean assertNotEquals(long n, long num) {
        return n != num;
    }
}

