/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.OrderByEntity;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestEntityOrderBy
extends AnnotationTestCase {
    public TestEntityOrderBy(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
    }

    public void testUse() {
        this.deleteAll(OrderByEntity.class);
        OrderByEntity pc = new OrderByEntity();
        pc.setId(1L);
        pc.getStrings().add("2");
        pc.getStrings().add("1");
        pc.getStrings().add("3");
        OrderByEntity rel1 = new OrderByEntity();
        rel1.setId(102L);
        rel1.setString("2");
        OrderByEntity rel2 = new OrderByEntity();
        rel2.setId(101L);
        rel2.setString("1");
        OrderByEntity rel3 = new OrderByEntity();
        rel3.setId(103L);
        rel3.setString("3");
        pc.getPKRels().add(rel1);
        pc.getPKRels().add(rel2);
        pc.getPKRels().add(rel3);
        pc.getStringRels().add(rel1);
        pc.getStringRels().add(rel2);
        pc.getStringRels().add(rel3);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{pc, rel1, rel2, rel3});
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        pc = (OrderByEntity)em.find(OrderByEntity.class, (Object)1L);
        List<String> strings = pc.getStrings();
        TestEntityOrderBy.assertEquals((String)"1", (String)strings.get(0));
        TestEntityOrderBy.assertEquals((String)"2", (String)strings.get(1));
        TestEntityOrderBy.assertEquals((String)"3", (String)strings.get(2));
        List<OrderByEntity> pkRels = pc.getPKRels();
        TestEntityOrderBy.assertEquals((long)101L, (long)pkRels.get(0).getId());
        TestEntityOrderBy.assertEquals((long)102L, (long)pkRels.get(1).getId());
        TestEntityOrderBy.assertEquals((long)103L, (long)pkRels.get(2).getId());
        List<OrderByEntity> stringRels = pc.getStringRels();
        TestEntityOrderBy.assertEquals((String)"3", (String)stringRels.get(0).getString());
        TestEntityOrderBy.assertEquals((String)"2", (String)stringRels.get(1).getString());
        TestEntityOrderBy.assertEquals((String)"1", (String)stringRels.get(2).getString());
        this.endEm((EntityManager)em);
    }
}

