/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.CallbackStorage;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.ContractEmployee;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.Employee;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestEntityListenerAnnot
extends AnnotationTestCase {
    public TestEntityListenerAnnot(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(Employee.class);
        this.deleteAll(ContractEmployee.class);
        CallbackStorage.clearStore();
    }

    public void testPrePersist() {
        OpenJPAEntityManager em = this.currentEntityManager();
        ContractEmployee cemp = new ContractEmployee(21, "afam", 25, 5);
        em.persist((Object)cemp);
        CallbackStorage store = CallbackStorage.getInstance();
        TestEntityListenerAnnot.assertNotNull(store.getClist());
        TestEntityListenerAnnot.assertEquals((String)"@pre/post persist callback is over/under-firing", (int)2, (int)store.getClist().size());
        TestEntityListenerAnnot.assertEquals((String)"longnamevalidatorprr", (String)store.getClist().get(0));
        TestEntityListenerAnnot.assertEquals((String)"contractemployee", (String)store.getClist().get(1));
        this.endEm((EntityManager)em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPostPersist() {
        OpenJPAEntityManager em = null;
        try {
            em = this.currentEntityManager();
            this.startTx((EntityManager)em);
            Employee emp = new Employee(1, "john");
            em.persist((Object)emp);
            CallbackStorage store = CallbackStorage.getInstance();
            TestEntityListenerAnnot.assertNotNull(store.getClist());
            TestEntityListenerAnnot.assertEquals((String)"@pre/post persist callback is over/under-firing", (int)4, (int)store.getClist().size());
            TestEntityListenerAnnot.assertEquals((String)"namevalidator", (String)store.getClist().get(0));
            TestEntityListenerAnnot.assertEquals((String)"longnamevalidatorprr", (String)store.getClist().get(1));
            TestEntityListenerAnnot.assertEquals((String)"employeepop", (String)store.getClist().get(2));
            TestEntityListenerAnnot.assertEquals((String)("We expected 'gen#" + emp.getCheck() + " : " + emp.getCheck() + "'. However, we got '" + store.getClist().get(3) + "'"), (String)("gen#" + emp.getCheck()), (String)store.getClist().get(3));
        }
        finally {
            this.endTx((EntityManager)em);
            this.endEm((EntityManager)em);
        }
    }

    public void testPre_PostRemove() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Employee emp = new Employee(8, "Jonathan");
        em.persist((Object)emp);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        emp = (Employee)em.find(Employee.class, (Object)8);
        CallbackStorage.clearStore();
        TestEntityListenerAnnot.assertTrue((boolean)CallbackStorage.isEmpty());
        em.remove((Object)emp);
        TestEntityListenerAnnot.assertTrue((!CallbackStorage.isEmpty() ? 1 : 0) != 0);
        TestEntityListenerAnnot.assertEquals((String)"callback is under/over-firing...", (int)2, (int)CallbackStorage.size());
        TestEntityListenerAnnot.assertEquals((String)"namevalidatorprr", (String)CallbackStorage.getInstance().getClist().get(0));
        TestEntityListenerAnnot.assertEquals((String)"namevalidatorpor", (String)CallbackStorage.getInstance().getClist().get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testPreUpdate() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Employee emp = new Employee(5, "Abraham");
        em.persist((Object)emp);
        CallbackStorage.clearStore();
        String query = "Update Employee e SET e.name = 'Joseph' WHERE e.id = :id";
        int result = em.createQuery(query).setParameter("id", (Object)5).executeUpdate();
        List<String> store = CallbackStorage.getInstance().getClist();
        TestEntityListenerAnnot.assertNotNull((Object)result);
        TestEntityListenerAnnot.assertEquals((int)1, (int)result);
        TestEntityListenerAnnot.assertNotNull(store);
        TestEntityListenerAnnot.assertEquals((int)3, (int)store.size());
        TestEntityListenerAnnot.assertEquals((Object)"namevalidatorpou", (Object)store.get(0));
        TestEntityListenerAnnot.assertEquals((Object)"longnamevalidatorpou", (Object)store.get(1));
        TestEntityListenerAnnot.assertEquals((Object)"employeepou", (Object)store.get(2));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testPreUpdate2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Employee emp = new Employee(5, "Abraham");
        em.persist((Object)emp);
        CallbackStorage.clearStore();
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        emp = (Employee)em.find(Employee.class, (Object)5);
        CallbackStorage.clearStore();
        TestEntityListenerAnnot.assertEquals((String)"Abraham", (String)emp.getName());
        emp.setName("Abrahamovich");
        em.flush();
        List<String> store = CallbackStorage.getInstance().getClist();
        TestEntityListenerAnnot.assertNotNull(store);
        TestEntityListenerAnnot.assertEquals((String)"update callback is either underfiring or overfiring...", (int)3, (int)store.size());
        TestEntityListenerAnnot.assertEquals((Object)"namevalidatorpou", (Object)store.get(0));
        TestEntityListenerAnnot.assertEquals((Object)"longnamevalidatorpou", (Object)store.get(1));
        TestEntityListenerAnnot.assertEquals((Object)"employeepou", (Object)store.get(2));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testPostLoad() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Employee emp = new Employee(6, "Jefferson");
        em.persist((Object)emp);
        CallbackStorage.clearStore();
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        CallbackStorage.clearStore();
        TestEntityListenerAnnot.assertTrue((boolean)CallbackStorage.getInstance().getClist().isEmpty());
        emp = (Employee)em.find(Employee.class, (Object)6);
        em.refresh((Object)emp);
        TestEntityListenerAnnot.assertNotNull((Object)emp);
        TestEntityListenerAnnot.assertNotNull(CallbackStorage.getInstance().getClist());
        TestEntityListenerAnnot.assertEquals((String)"PostLoad is overfiring...not accurate", (int)2, (int)CallbackStorage.getInstance().getClist().size());
        TestEntityListenerAnnot.assertEquals((String)"employeepol", (String)CallbackStorage.getInstance().getClist().get(0));
        TestEntityListenerAnnot.assertEquals((String)"employeepol", (String)CallbackStorage.getInstance().getClist().get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testGenPriKeyAvailInPostPersist() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        TestEntityListenerAnnot.assertNotNull((Object)em);
        Employee emp = new Employee(7, "Maxwell");
        TestEntityListenerAnnot.assertEquals((int)0, (int)emp.getCheck());
        em.persist((Object)emp);
        int check = emp.getCheck();
        TestEntityListenerAnnot.assertNotNull((Object)check);
        TestEntityListenerAnnot.assertTrue((boolean)CallbackStorage.getInstance().getClist().contains("gen#" + check));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

