/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbeddableSuperSub;

public class TestEmbeddableSuperclass
extends AnnotationTestCase {
    public TestEmbeddableSuperclass(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(EmbeddableSuperSub.class);
    }

    public void testPersistAndFind() {
        EmbeddableSuperSub parent = new EmbeddableSuperSub();
        parent.setClob("parent");
        EmbeddableSuperSub sub = new EmbeddableSuperSub();
        sub.setClob("sub");
        EmbeddableSuperSub sup = new EmbeddableSuperSub();
        sup.setClob("sup");
        parent.setSub(sub);
        parent.setSup(sup);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{parent, sub, sup});
        this.endTx((EntityManager)em);
        long pk = parent.getPK();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        parent = (EmbeddableSuperSub)em.find(EmbeddableSuperSub.class, (Object)pk);
        TestEmbeddableSuperclass.assertEquals((String)"parent", (String)parent.getClob());
        TestEmbeddableSuperclass.assertEquals((String)"sub", (String)parent.getSub().getClob());
        TestEmbeddableSuperclass.assertEquals((String)"sup", (String)parent.getSup().getClob());
        this.endEm((EntityManager)em);
    }
}

