/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.access;

import java.util.Random;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.access.MappedCallbackSup;
import org.apache.openjpa.persistence.access.PropEntity;
import org.apache.openjpa.persistence.access.xml.XMLDefFieldMixedPropAccess2;
import org.apache.openjpa.persistence.access.xml.XMLDefPropMixedFieldAccess2;
import org.apache.openjpa.persistence.access.xml.XMLFieldAccess2;
import org.apache.openjpa.persistence.access.xml.XMLPropAccess2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDefaultAccess
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, PropEntity.class, MappedCallbackSup.class);
    }

    public void testDefaultMappedSuperclassAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PropEntity pe = new PropEntity();
        pe.setId(new Random().nextInt());
        pe.setName("Name");
        em.getTransaction().begin();
        em.persist((Object)pe);
        em.getTransaction().commit();
        em.close();
    }

    public void testEMDefaultFieldAccess() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Access-EMFldDef", (String)"org/apache/openjpa/persistence/access/access-def-persistence.xml");
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        this.verifyDefaultFieldAccess(em);
        em.close();
        this.clear((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf1);
    }

    public void testEMDefaultPropertyAccess() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Access-EMPropDef", (String)"org/apache/openjpa/persistence/access/access-def-persistence.xml");
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        this.verifyDefaultPropertyAccess(em);
        em.close();
        this.clear((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf1);
    }

    public void testPUDefaultFieldAccess() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Access-PUFldDef", (String)"org/apache/openjpa/persistence/access/access-pudef-persistence.xml");
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        this.verifyDefaultFieldAccess(em);
        em.close();
        this.clear((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf1);
    }

    public void testPUDefaultPropertyAccess() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Access-PUPropDef", (String)"org/apache/openjpa/persistence/access/access-pudef-persistence.xml");
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        this.verifyDefaultPropertyAccess(em);
        em.close();
        this.clear((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf1);
    }

    private void verifyDefaultFieldAccess(OpenJPAEntityManagerSPI em) {
        XMLFieldAccess2 fa = new XMLFieldAccess2();
        fa.setStringField("XMLFieldAccess2");
        em.getTransaction().begin();
        em.persist((Object)fa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLFieldAccess2.query");
        qry.setParameter("id", (Object)fa.getId());
        qry.setParameter("strVal", (Object)"XMLFieldAccess2");
        XMLFieldAccess2 fa2 = (XMLFieldAccess2)qry.getSingleResult();
        TestDefaultAccess.assertEquals((int)fa.getId(), (int)fa2.getId());
        XMLDefFieldMixedPropAccess2 dfmpa = new XMLDefFieldMixedPropAccess2();
        dfmpa.setStrField("NonPCSetter");
        dfmpa.setStringField("XMLDFMPA2");
        em.getTransaction().begin();
        em.persist((Object)dfmpa);
        em.getTransaction().commit();
        em.clear();
        qry = em.createNamedQuery("XMLDFMPA2.query");
        qry.setParameter("id", (Object)dfmpa.getId());
        qry.setParameter("strVal", (Object)"XMLDFMPA2");
        XMLDefFieldMixedPropAccess2 dfmpa2 = (XMLDefFieldMixedPropAccess2)qry.getSingleResult();
        TestDefaultAccess.assertEquals((Object)dfmpa, (Object)dfmpa2);
        TestDefaultAccess.assertEquals((String)dfmpa2.getStringField(), (String)"XMLDFMPA2");
        try {
            qry = em.createNamedQuery("XMLDFMPA2.badQuery");
            qry.setParameter("id", (Object)dfmpa.getId());
            qry.setParameter("strVal", (Object)"XMLDFMPA2");
            qry.getSingleResult();
            TestDefaultAccess.fail((String)"Execution of this query should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyDefaultPropertyAccess(OpenJPAEntityManagerSPI em) {
        XMLPropAccess2 pa = new XMLPropAccess2();
        pa.setStrProp("PropertyAccess");
        em.getTransaction().begin();
        em.persist((Object)pa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLPropAccess2.query");
        qry.setParameter("id", (Object)pa.getId());
        qry.setParameter("strVal", (Object)"PropertyAccess");
        XMLPropAccess2 pa2 = (XMLPropAccess2)qry.getSingleResult();
        TestDefaultAccess.assertEquals((Object)pa, (Object)pa2);
        XMLDefPropMixedFieldAccess2 dpmfa = new XMLDefPropMixedFieldAccess2();
        dpmfa.setStrProp("XMLDPMFA2");
        em.getTransaction().begin();
        em.persist((Object)dpmfa);
        em.getTransaction().commit();
        em.clear();
        qry = em.createNamedQuery("XMLDPMFA2.query");
        qry.setParameter("id", (Object)dpmfa.getId());
        qry.setParameter("strVal", (Object)"XMLDPMFA2");
        XMLDefPropMixedFieldAccess2 dpmfa2 = (XMLDefPropMixedFieldAccess2)qry.getSingleResult();
        TestDefaultAccess.assertEquals((Object)dpmfa, (Object)dpmfa2);
        TestDefaultAccess.assertEquals((String)dpmfa2.getStrProp(), (String)"XMLDPMFA2");
        try {
            qry = em.createNamedQuery("XMLDPMFA2.badQuery");
            qry.setParameter("id", (Object)dpmfa.getId());
            qry.setParameter("strVal", (Object)"XMLDPMFA2");
            qry.getSingleResult();
            TestDefaultAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

