/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.DelegatingBroker;
import org.apache.openjpa.kernel.DelegatingQuery;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.lib.jdbc.DelegatingConnection;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.OpenJPAQuerySPI;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestUnwrap
extends SingleEMFTestCase {
    public void testValidQueryUnwrap() {
        Class[] validCasts;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery query = em.createQuery("openjpa.SQL", "");
        for (Class c : validCasts = new Class[]{OpenJPAQuery.class, OpenJPAQuerySPI.class, DelegatingQuery.class, Query.class, QueryImpl.class}) {
            Object unwrapped = query.unwrap(c);
            TestUnwrap.assertTrue((boolean)c.isInstance(unwrapped));
        }
        em.close();
    }

    public void testValidEntityManagerUnwrap() {
        Class[] validCasts;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (Class c : validCasts = new Class[]{OpenJPAEntityManager.class, OpenJPAEntityManagerSPI.class, DelegatingBroker.class, Broker.class}) {
            Object unwrapped = em.unwrap(c);
            TestUnwrap.assertTrue((boolean)c.isInstance(unwrapped));
        }
        em.close();
    }

    public void testValidOtherUnwrap() {
        Class[] validCasts;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (Class c : validCasts = new Class[]{Connection.class}) {
            Object unwrapped = em.unwrap(c);
            TestUnwrap.assertTrue((boolean)c.isInstance(unwrapped));
        }
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionUnwrap() throws Exception {
        block10: {
            String dbDict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().getClass().getName();
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            OpenJPAEntityManager oem = (OpenJPAEntityManager)em.unwrap(OpenJPAEntityManager.class);
            try {
                Connection c = (Connection)oem.getConnection();
                TestUnwrap.assertNotNull((Object)c);
                TestUnwrap.assertTrue((boolean)DelegatingConnection.class.isAssignableFrom(c.getClass()));
                ArrayList acceptedConnectionClassTypes = new ArrayList();
                if (DerbyDictionary.class.getName().equals(dbDict)) {
                    String[] connectionTypes;
                    for (String ct : connectionTypes = new String[]{"org.apache.derby.impl.jdbc.EmbedConnection40", "org.apache.derby.impl.jdbc.EmbedConnection30", "org.apache.derby.iapi.jdbc.BrokeredConnection40", "org.apache.derby.iapi.jdbc.BrokeredConnection30"}) {
                        try {
                            Class<?> cls = Class.forName(ct);
                            acceptedConnectionClassTypes.add(cls);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (acceptedConnectionClassTypes.isEmpty()) break block10;
                boolean pass = false;
                for (Class clazz : acceptedConnectionClassTypes) {
                    try {
                        Connection castC = (Connection)c.unwrap(clazz);
                        TestUnwrap.assertNotNull((Object)castC);
                        TestUnwrap.assertEquals((Object)clazz, castC.getClass());
                        pass = true;
                        break;
                    }
                    catch (Throwable throwable) {
                        TestUnwrap.assertTrue((boolean)pass);
                    }
                }
            }
            finally {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNegativeConnectionUnwrap() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em.unwrap(OpenJPAEntityManager.class);
        try {
            Connection c = (Connection)oem.getConnection();
            TestUnwrap.assertNotNull((Object)c);
            TestUnwrap.assertTrue((boolean)DelegatingConnection.class.isAssignableFrom(c.getClass()));
            try {
                c.unwrap(TestUnwrap.class);
                TestUnwrap.fail((String)"Bogus unwrap should have thrown a SQLException.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            em.close();
        }
    }

    public void testInvalidEntityManagerUnwrap() {
        Class[] invalidCasts;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (Class c : invalidCasts = new Class[]{Object.class, Properties.class, Map.class, null}) {
            try {
                em.getTransaction().begin();
                em.unwrap(c);
                TestUnwrap.fail((String)("Expected to fail to unwarp with invalid " + c));
            }
            catch (PersistenceException e) {
                EntityTransaction txn = em.getTransaction();
                TestUnwrap.assertTrue((boolean)txn.getRollbackOnly());
                txn.rollback();
            }
        }
        em.close();
    }

    public void testInvalidQueryUnwrap() {
        Class[] invalidCasts;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (Class c : invalidCasts = new Class[]{Object.class, Properties.class, Map.class, null}) {
            try {
                em.getTransaction().begin();
                OpenJPAQuery query = em.createQuery("openjpa.SQL", "");
                query.unwrap(c);
                TestUnwrap.fail((String)("Expected to fail to unwarp with invalid " + c));
            }
            catch (PersistenceException e) {
                OpenJPAEntityTransaction txn = em.getTransaction();
                TestUnwrap.assertTrue((boolean)txn.getRollbackOnly());
                txn.rollback();
            }
        }
        em.close();
    }
}

