/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.openjpa2018;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import org.apache.openjpa.openjpa2018.User2018;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaBuilder;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class OpenJPA2018Test
extends SingleEMTestCase {
    @Override
    public void setUp() {
        super.setUp(User2018.class, CLEAR_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInCriteriaWithArray() {
        this.em.getTransaction().begin();
        try {
            User2018 user = new User2018();
            this.em.persist((Object)user);
            this.em.flush();
            OpenJPACriteriaBuilder builder = this.em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(User2018.class);
            Root root = criteria.from(User2018.class);
            criteria.where((Expression)root.get("id").in(new Expression[]{builder.parameter(Long[].class)}));
            TypedQuery query = this.em.createQuery(criteria);
            for (ParameterExpression parameter : criteria.getParameters()) {
                query.setParameter((Parameter)parameter, (Object)new Long[]{User2018.pcGetid(user), 123456789L});
            }
            List result = query.getResultList();
            OpenJPA2018Test.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInJpqlWithArray() {
        this.em.getTransaction().begin();
        try {
            User2018 user = new User2018();
            this.em.persist((Object)user);
            this.em.flush();
            TypedQuery query = this.em.createQuery("select u from User2018 as u where u.id in (:userIds)", User2018.class);
            query.setParameter("userIds", (Object)new Long[]{User2018.pcGetid(user), 123456789L});
            List result = query.getResultList();
            OpenJPA2018Test.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInCriteriaWithCollection() {
        this.em.getTransaction().begin();
        try {
            User2018 user = new User2018();
            this.em.persist((Object)user);
            this.em.flush();
            OpenJPACriteriaBuilder builder = this.em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(User2018.class);
            Root root = criteria.from(User2018.class);
            criteria.where((Expression)root.get("id").in(new Expression[]{builder.parameter(Collection.class)}));
            TypedQuery query = this.em.createQuery(criteria);
            for (ParameterExpression parameter : criteria.getParameters()) {
                query.setParameter((Parameter)parameter, Arrays.asList(User2018.pcGetid(user), 123456789L));
            }
            List result = query.getResultList();
            OpenJPA2018Test.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInJpqlWithCollection() {
        this.em.getTransaction().begin();
        try {
            User2018 user = new User2018();
            this.em.persist((Object)user);
            this.em.flush();
            TypedQuery query = this.em.createQuery("select u from User2018 as u where u.id in (:userIds)", User2018.class);
            query.setParameter("userIds", Arrays.asList(User2018.pcGetid(user), 123456789L));
            List result = query.getResultList();
            OpenJPA2018Test.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testId() {
        this.em.getTransaction().begin();
        try {
            User2018 user = new User2018();
            this.em.persist((Object)user);
            this.em.flush();
            OpenJPACriteriaBuilder builder = this.em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(User2018.class);
            Root root = criteria.from(User2018.class);
            criteria.where((Expression)builder.equal((Expression)root.get("id"), (Object)User2018.pcGetid(user)));
            TypedQuery query = this.em.createQuery(criteria);
            for (ParameterExpression parameter : criteria.getParameters()) {
                query.setParameter((Parameter)parameter, (Object)User2018.pcGetid(user));
            }
            List result = query.getResultList();
            OpenJPA2018Test.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.em.getTransaction().commit();
        }
    }
}

