/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.meta.A;
import org.apache.openjpa.meta.AbstractThing;
import org.apache.openjpa.meta.B;
import org.apache.openjpa.meta.C;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.InheritanceComparator;
import org.apache.openjpa.meta.MetaDataInheritanceComparator;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMetaDataInheritanceComparator
extends SingleEMFTestCase {
    public void testInheritanceComparatorWithBase() {
        this.inheritanceComparatorHelper(true);
    }

    @Override
    public void setUp() {
        this.setUp(A.class, B.class, C.class, AbstractThing.class);
    }

    private void inheritanceComparatorHelper(boolean base) {
        InheritanceComparator comp = new InheritanceComparator();
        if (base) {
            comp.setBase(AbstractThing.class);
        }
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare(A.class, B.class));
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare(B.class, C.class));
        TestMetaDataInheritanceComparator.assertTrue((comp.compare(A.class, C.class) < 0 ? 1 : 0) != 0);
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare(AbstractThing.class, A.class));
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare(AbstractThing.class, B.class));
        TestMetaDataInheritanceComparator.assertTrue((comp.compare(AbstractThing.class, C.class) < 0 ? 1 : 0) != 0);
    }

    public void testMetaDataInheritanceComparatorWithBase() {
        this.metaDataInheritanceComparatorHelper(true);
    }

    private void metaDataInheritanceComparatorHelper(boolean base) {
        MetaDataInheritanceComparator comp = new MetaDataInheritanceComparator();
        if (base) {
            comp.setBase(AbstractThing.class);
        }
        ClassMetaData a = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, A.class);
        ClassMetaData b = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, B.class);
        ClassMetaData c = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, C.class);
        ClassMetaData at = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, AbstractThing.class);
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare((Object)a, (Object)b));
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare((Object)b, (Object)c));
        TestMetaDataInheritanceComparator.assertTrue((comp.compare((Object)a, (Object)c) < 0 ? 1 : 0) != 0);
        TestMetaDataInheritanceComparator.assertEquals((int)1, (int)comp.compare((Object)b, (Object)a));
        TestMetaDataInheritanceComparator.assertEquals((int)1, (int)comp.compare((Object)c, (Object)b));
        TestMetaDataInheritanceComparator.assertTrue((comp.compare((Object)c, (Object)a) > 0 ? 1 : 0) != 0);
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare((Object)at, (Object)a));
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare((Object)at, (Object)b));
        TestMetaDataInheritanceComparator.assertEquals((int)-1, (int)comp.compare((Object)at, (Object)c));
    }

    public void testEndToEnd() {
        this.emf.createEntityManager().close();
    }
}

