/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.test.DatabasePlatform;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

@DatabasePlatform(value="org.apache.derby.jdbc.EmbeddedDriver")
public class TestEquivalentConfiguration
extends SingleEMFTestCase {
    private EntityManagerFactory emf1 = null;
    private Properties _system;
    private static final String OLD_STYLE_URL_KEY = "openjpa.ConnectionURL";
    private static final String OLD_STYLE_DRIVER_KEY = "openjpa.ConnectionDriverName";
    private static final String NEW_STYLE_DRIVER_KEY = "javax.persistence.jdbc.driver";
    private static final String NEW_STYLE_URL_KEY = "javax.persistence.jdbc.url";
    private static final String[] KEYS = new String[]{"openjpa.ConnectionDriverName", "openjpa.ConnectionURL", "javax.persistence.jdbc.driver", "javax.persistence.jdbc.url"};
    private static final String PERSISTENCE_UNIT = "org/apache/openjpa/lib/conf/META-INF/persistence-config.xml";
    private static final String OLD_STYLE_UNIT_NAME = "old-style";
    private static final String NEW_STYLE_UNIT_NAME = "new-style";
    private static final String MIXED_STYLE_UNIT_NAME = "mixed-style";
    private static final String CONFLICT_STYLE_UNIT_NAME = "conflict-style";
    private static final String SYSTEM_CONFIGURED_UNIT_NAME = "system-configured";
    private static final String RUNTIME_CONFIGURED_UNIT_NAME = "runtime-configured";
    private static final String URL = "jdbc:derby:target/database/openjpa-test-database;create=true";
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DerbyDictionary.class);
        this._system = this.backup();
        this.clear(this._system);
    }

    @Override
    public void tearDown() throws Exception {
        this.restore(this._system);
        super.tearDown();
        if (this.emf1 != null) {
            this.clear(this.emf1);
            this.closeEMF(this.emf1);
            this.emf1 = null;
        }
    }

    public void testOldStylePersistenceUnitConfiguration() {
        this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)OLD_STYLE_UNIT_NAME, (String)PERSISTENCE_UNIT);
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testNewStylePersistenceUnitConfiguration() {
        this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)NEW_STYLE_UNIT_NAME, (String)PERSISTENCE_UNIT);
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testMixedStylePersistenceUnitConfiguration() {
        this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)MIXED_STYLE_UNIT_NAME, (String)PERSISTENCE_UNIT);
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testConflictStylePersistenceUnitConfiguration() {
        try {
            this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)CONFLICT_STYLE_UNIT_NAME, (String)PERSISTENCE_UNIT);
            TestEquivalentConfiguration.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testNewStyleSystemPropertyConfiguration() {
        try {
            System.setProperty(NEW_STYLE_DRIVER_KEY, DRIVER);
            System.setProperty(NEW_STYLE_URL_KEY, URL);
            this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)SYSTEM_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT);
        }
        finally {
            System.getProperties().remove(NEW_STYLE_DRIVER_KEY);
            System.getProperties().remove(NEW_STYLE_URL_KEY);
        }
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testOldStyleSystemPropertyConfiguration() {
        try {
            System.setProperty(OLD_STYLE_DRIVER_KEY, DRIVER);
            System.setProperty(OLD_STYLE_URL_KEY, URL);
            this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)SYSTEM_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT);
        }
        finally {
            System.getProperties().remove(OLD_STYLE_DRIVER_KEY);
            System.getProperties().remove(OLD_STYLE_URL_KEY);
        }
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testMixedStyleSystemPropertyConfiguration() {
        System.setProperty(OLD_STYLE_DRIVER_KEY, DRIVER);
        System.setProperty(NEW_STYLE_URL_KEY, URL);
        try {
            this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)SYSTEM_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT);
        }
        finally {
            System.getProperties().remove(OLD_STYLE_DRIVER_KEY);
            System.getProperties().remove(NEW_STYLE_URL_KEY);
        }
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testConflictStyleSystemPropertyConfiguration() {
        System.setProperty(OLD_STYLE_DRIVER_KEY, DRIVER);
        System.setProperty(NEW_STYLE_DRIVER_KEY, DRIVER);
        try {
            this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)SYSTEM_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT);
            TestEquivalentConfiguration.fail();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            System.getProperties().remove(OLD_STYLE_DRIVER_KEY);
            System.getProperties().remove(NEW_STYLE_DRIVER_KEY);
        }
    }

    public void testOldStyleRuntimePropertyConfiguration() {
        Properties conf = new Properties();
        conf.setProperty(OLD_STYLE_DRIVER_KEY, DRIVER);
        conf.setProperty(OLD_STYLE_URL_KEY, URL);
        this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)RUNTIME_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT, (Map)conf);
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testNewStyleRuntimePropertyConfiguration() {
        Properties conf = new Properties();
        conf.setProperty(NEW_STYLE_DRIVER_KEY, DRIVER);
        conf.setProperty(NEW_STYLE_URL_KEY, URL);
        this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)RUNTIME_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT, (Map)conf);
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testMixedStyleRuntimePropertyConfiguration() {
        Properties conf = new Properties();
        conf.setProperty(OLD_STYLE_DRIVER_KEY, DRIVER);
        conf.setProperty(NEW_STYLE_URL_KEY, URL);
        this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)RUNTIME_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT, (Map)conf);
        TestEquivalentConfiguration.assertNotNull((Object)this.emf1);
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(OLD_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(OLD_STYLE_URL_KEY));
        TestEquivalentConfiguration.assertFalse((boolean)this.containsProperty(NEW_STYLE_DRIVER_KEY));
        TestEquivalentConfiguration.assertTrue((boolean)this.containsProperty(NEW_STYLE_URL_KEY));
        this.verifyDatabaseConnection();
    }

    public void testConflictStyleRuntimePropertyConfiguration() {
        Properties conf = new Properties();
        conf.setProperty(OLD_STYLE_DRIVER_KEY, DRIVER);
        conf.setProperty(NEW_STYLE_DRIVER_KEY, DRIVER);
        try {
            this.emf1 = OpenJPAPersistence.createEntityManagerFactory((String)RUNTIME_CONFIGURED_UNIT_NAME, (String)PERSISTENCE_UNIT, (Map)conf);
            TestEquivalentConfiguration.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void verifyDatabaseConnection() {
        String driver = OpenJPAPersistence.cast((EntityManagerFactory)this.emf1).getConfiguration().getConnectionDriverName();
        EntityManager em = this.emf1.createEntityManager();
        em.getTransaction().begin();
        em.flush();
        em.getTransaction().commit();
    }

    boolean containsProperty(String key) {
        return this.getConfiguration().toProperties(true).containsKey(key);
    }

    OpenJPAConfiguration getConfiguration() {
        return ((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)this.emf1)).getConfiguration();
    }

    Properties backup() {
        Properties p = new Properties();
        for (String key : KEYS) {
            if (System.getProperty(key) == null) continue;
            p.setProperty(key, System.getProperty(key));
        }
        return p;
    }

    private void clear(Properties p) {
        for (Object key : p.keySet()) {
            System.getProperties().remove(key);
        }
    }

    private void restore(Properties p) {
        for (Object key : p.keySet()) {
            System.setProperty(key.toString(), p.get(key).toString());
        }
    }
}

